<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容组合套餐</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出美容组合套餐报名成绩表数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/groomer/groomerPackage/exportGrade");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/groomer/groomerPackage/grade");
			$("#searchForm").submit();
        	return false;
        }
		//上传证件照
		function openLayer2(id){
			top.layer.open({
				type: 2,
				title: ['修改成绩', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '400px'],
				content: "${ctx}/groomer/groomerPackage/saveGrade?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
		
		
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/groomer/groomerPackage/">报名信息</a></li>
		<li  class="active"><a href="${ctx}/groomer/groomerPackage/grade">成绩管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerPackage" action="${ctx}/groomer/groomerPackage/grade" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><span><label>会员号/姓名：</label></span>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li> 
			<li>
				<label>报名时间：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerPackage.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${groomerPackage.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>成绩：</label>
				<form:select path="grade" class="input-medium">
				<form:option value="" label="全部"/>
					<form:option value="0" label="待审核"/>
					<form:option value="1" label="未通过"/>
					<form:option value="2" label="已通过"/>
				</form:select>
			<li class="btns">
			     <input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				<button id="btnExport" type="button" class="btn btn-primary" >导出</button>
			</li>
			
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>报名序号</th>
				<th>提交时间</th>
				<th>会员号</th>
				<th>姓名</th>
				<th>美容师类型</th>
				<th>移动电话</th>
				<th>性别</th>
				<th>培训学校</th>
				<th>比赛犬种</th>
				<th>赛事级别</th>
				<th>成绩</th>
				<th>查看</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerPackage">
			<tr>
				<td>
					${fns:escapeHtml(groomerPackage.applyCode)}
				</td>
				<td>	
					<fmt:formatDate value="${groomerPackage.paymentTime}" pattern="yyyy-MM-dd"/>
				</td>
				<td title='${fn:replace(groomerPackage.memberCode, ",", "  ")}'>
					<a href="${ctx}/sys/user/member/form?id=${groomerPackage.member.id}">
					${fns:escapeHtml(groomerPackage.memberCode)}
					</a>
				</td>
				<td>
					${fns:escapeHtml(groomerPackage.name)}
				</td>
				<td>
					${fns:getDictLabels(groomerPackage.member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					${fns:escapeHtml(groomerPackage.member.mobile)}
				</td>
				<td>
					${fns:getDictLabel(groomerPackage.member.gender, 'user_gender', '')}
				</td>
				<td>
					${fn:replace(groomerPackage.schoolNameCn, ",", "  ")}
				</td>
				
				<td>
					${fns:escapeHtml(groomerPackage.dogBreed)}
				</td>
				<td>
						${groomerPackage.showLevel }
				</td>
				<td>	
					<c:if test="${groomerPackage.grade == 0}"> 
						待审核
					</c:if>
					<c:if test="${groomerPackage.grade == 1}"> 
						<font  style="color: red">未通过</font>
					</c:if>
					<c:if test="${groomerPackage.grade == 2}"> 
						<font  style="color: green">已通过</font>
					</c:if>
				 </td>
				<td>
					<a href="#" onclick="openLayer2('${fns:escapeHtml(groomerPackage.id)}')">编辑</a>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>