<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>繁育证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
			    <th>血统证书号</th>
				<th>繁育证书编号</th>
				<th>犬主人</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogBreedCertified">
			<tr>
			    <td>
			        ${fns:escapeHtml(dogBreedCertified.dog.pedigreeCertifiedCode) }
			    </td>
				<td>
				    ${fns:escapeHtml(dogBreedCertified.breedCertifiedCode) }
				</td>
				<td title="${fns:escapeHtml(dogBreedCertified.dog.memberCode) }">
                    ${fns:escapeHtml(dogBreedCertified.dog.dogOwner) }
                </td>
				<td>
					<fmt:formatDate value="${dogBreedCertified.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					<c:if test="${dogBreedCertified.paymentState==1}"><font color="red">${fns:getDictLabel(dogBreedCertified.paymentState, 'user_payment_state', '')}</font></c:if>
                    <c:if test="${dogBreedCertified.paymentState==2}"><font color="green">${fns:getDictLabel(dogBreedCertified.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td>
					<c:if test="${dogBreedCertified.reviewState==0}"><font color="red"></c:if>
                            ${fns:getDictLabel(dogBreedCertified.reviewState, 'review_state', '')}
                        <c:if test="${dogBreedCertified.reviewState==0}"></font></c:if>
                    </a></td>
                <shiro:hasPermission name="dogbreed:dogBreedCertified:process">
				<td>
					${fns:getDictLabel(dogBreedCertified.processState, 'proccess_state', '')}
				</td>
				</shiro:hasPermission>
				<td>
    			<shiro:hasPermission name="dogbreed:dogBreedCertified:delete">
					<a href="${ctx}/dogbreed/dogBreedCertified/orderDelete?id=${fns:escapeHtml(dogBreedCertified.id) }" onclick="return confirmx('确认要删除该繁育证书吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</html>