<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>出生证明编号</th>
				<th>配种证明编号</th>
				<th>性别</th>
				<th>英文犬名</th>
				<th>犬种代码</th>
				<th>出生日期</th>
				<th>芯片号码</th>
				<th>犬主人</th>
				<th>加急</th>
				<th>缴费</th>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit"><th>审核</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print"><th>打印</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view"><th>管理</th></shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete"><th>删除</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogBirthCertificate">
			<tr>
				<td>
					${fns:escapeHtml(dogBirthCertificate.birthCerRegCode)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.fmdogBreedCertifiedCode)}
				</td>
				<td>
					${fns:getDictLabel(dogBirthCertificate.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogEnName)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${dogBirthCertificate.dogBirthday}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.identificationFlag)}
				</td>
				<td>
					${fns:escapeHtml(dogBirthCertificate.dogOwenr)}
				</td>
				<td style="color:${dogBirthCertificate.urgent=='1'?'#F00':''}">
					${fns:getDictLabel(dogBirthCertificate.urgent, 'urgent_status', '')}
				</td>
				<td style="color:${dogBirthCertificate.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogBirthCertificate.paymentState, 'user_payment_state', '未缴费')}
					<c:if test="${dogBirthCertificate.paymentState=='2'}">
						<fmt:formatDate value="${dogBirthCertificate.paymentTime}" pattern="yyyy-MM-dd"/>
					</c:if>
				</td>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:audit">
				<td style="color:#000">
					<c:if test="${dogBirthCertificate.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogBirthCertificate.businessRefundState}">
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" >
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='0'}">
							<a style="color:#F00" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:when test="${dogBirthCertificate.reviewState=='2'}">
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							<a style="color:#000" title="${fns:escapeHtml(dogBirthCertificate.reviewRemarks)}" href="${ctx}/birthcertificate/dogBirthCertificate/auditForm?id=${dogBirthCertificate.id}">
							${fns:getDictLabel(dogBirthCertificate.reviewState, 'dog_birth_certificate_review_state', '')}
							</a>
						</c:otherwise>
					</c:choose>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:print">
				<td>
					<c:if test="${dogBirthCertificate.reviewState=='1' and !dogBirthCertificate.businessRefundState}">
						<c:if test="${dogBirthCertificate.printType=='0'}">
	    					<a href="${ctx}/birthcertificate/dogBirthCertificate/print?id=${dogBirthCertificate.id}">
	    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
						</c:if>
						<c:if test="${dogBirthCertificate.printType=='1'}">
	    					<a href="${ctx}/birthcertificate/dogBirthCertificate/print?id=${dogBirthCertificate.id}">
	    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
						</c:if>
						<c:if test="${dogBirthCertificate.printType=='9'}">
	    					<a href="${ctx}/birthcertificate/dogBirthCertificate/resetPrint?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要打印重置吗？', this.href)">
	    					${fns:getDictLabel(dogBirthCertificate.printType, 'birth_certificate_print_type', '')}</a>
						</c:if>
					</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:view">
			<td>
				<c:if test="${!dogBirthCertificate.businessRefundState}">
					<a href="${ctx}/birthcertificate/dogBirthCertificate/form?id=${dogBirthCertificate.id}">编辑</a>
				</c:if>
    			</td>
				</shiro:hasPermission>
				<shiro:hasPermission name="birthcertificate:dogBirthCertificate:delete">
    			<td>
    				<c:if test="${!dogBirthCertificate.businessRefundState}">
					<a href="${ctx}/birthcertificate/dogBirthCertificate/delete?id=${dogBirthCertificate.id}" onclick="return confirmx('确认要删除该出生证明吗？', this.href)">删除</a>
				</c:if>
			</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>