package com.cku.restful.v1.show.service;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowJudgeDao;
import com.cku.oa.show.entity.ShowJudge;
import com.cku.restful.v1.show.model.CkuChampionLogin;
import com.cku.restful.v1.show.model.CkuShowJudge;
import com.cku.restful.v1.show.model.RestMainShows;

/**
 *user chaixueteng
 *2017年3月15日
 */
@Service
@Transactional(readOnly = true)
public class CkuShowJudgeService {
	@Autowired
	private ShowJudgeDao showJudgeDao;

	/**
	 * 根据id 
	 * 获取裁判的信息
	 * @Author chaixueteng
	 * @2017年3月15日下午2:12:07
	 */
	public RESTResponse getShowJudge(String id) {
		List<CkuShowJudge> restList = new ArrayList<>();
		if (StringUtils.isNotBlank(id)) {
			if(id.contains(",")){
				String[] ids = id.split(",");
				for (int i = 0; i < ids.length; i++) {
					CkuShowJudge judge=new CkuShowJudge();
					ShowJudge showJudge = showJudgeDao.get(ids[i]);
					if(showJudge!=null){
						judge.setCku_content(showJudge.getIntroduce());
						judge.setCku_title(showJudge.getJudgeName());
						judge.setCku_picture(showJudge.getJudgePicture());
						judge.setCku_position(showJudge.getJudgeTitle());
						judge.setCku_country(showJudge.getCitizenship());
						restList.add(judge);
					}
				}
			}else{
				CkuShowJudge judge=new CkuShowJudge();
				ShowJudge showJudge = showJudgeDao.get(id);
				if(showJudge!=null){
					judge.setCku_content(showJudge.getIntroduce());
					judge.setCku_title(showJudge.getJudgeName());
					judge.setCku_picture(showJudge.getJudgePicture());
					judge.setCku_position(showJudge.getJudgeTitle());
					judge.setCku_country(showJudge.getCitizenship());
					restList.add(judge);
				}
			}
		}
		return new RESTResponse("list",restList);
	}
	
	
}
