package com.cku.restful.v1.shop.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.shop.service.RestShopGoodsService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 商品管理Controller
 * 
 * @author lyy
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/shop")
public class RestShopGoodsController extends BaseRestController {

	@Autowired
	private RestShopGoodsService restShopGoodsService;

	@RequestMapping(value = "/shopGoods", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restShopGoodsService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shopGoods/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restShopGoodsService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 
	 * @description: 获取商品可买赠商品列表
	 * @author: laiguanglong
	 * @date: 2016年10月23日 上午11:43:58
	 */
	@RequestMapping(value = "/shopGoods/getBuyGifts", method = RequestMethod.GET)
	@ResponseBody
	public void getBuyGifts(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restShopGoodsService.getBuyGifts(request);
		ServletUtils.writeResponse(response, result);
	}

}