package com.cku.restful.v1.dog.vo;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class DogVideoAppraisalVo {

	@ApiModelProperty(value = "犬只品种")
	@NotNull(message = "犬只品种为空")
	private String dogBreed;

	@ApiModelProperty(value = "犬只品种中文")
	@NotNull(message = "犬只品种为空")
	private String dogBreedCn;

	@ApiModelProperty(value = "犬只毛色")
	@NotNull(message = "犬只毛色为空")
	private String dogColor;

	@ApiModelProperty(value = "犬只毛色中文")
	@NotNull(message = "犬只毛色为空")
	private String dogColorCn;

	@ApiModelProperty(value = "犬只性别")
	@NotNull(message = "犬只性别为空")
	private String dogGender;

	@ApiModelProperty(value = "犬只名称")
	@NotNull(message = "犬只名称为空")
	@Pattern(regexp = "^[A-Za-z]+$", message = "犬只名称仅限英文")
	private String dogName;

	@ApiModelProperty(value = "鼻纹")
	@NotNull(message = "鼻纹为空")
	private String dogNose;

	@ApiModelProperty(value = "新会员标示 0:老会员 1:新会员")
	@NotNull(message = "newMemberFlag为空")
	private String newMemberFlag;

	@ApiModelProperty(value = "出生日期")
	@NotNull(message = "出生日期为空")
	private Date dogBirth;

	@ApiModelProperty(value = "会员信息")
	private MemberVo memberVo;

	@ApiModelProperty(value = "图片id集合")
	@Size(min = 4, message = "图片集合长度为4")
	private List<ImgVo> imgIds;

//	@ApiModelProperty(value = "视频id")
//	@NotNull(message = "视频为空")
//	private String vodId;
	
	@ApiModelProperty(value = "视频集合")
	@NotNull(message = "视频为空")
	private List<VodVo> vods;

	public MemberVo getMemberVo() {
		return memberVo;
	}

	public void setMemberVo(MemberVo memberVo) {
		this.memberVo = memberVo;
	}

	public List<ImgVo> getImgIds() {
		return imgIds;
	}

	public void setImgIds(List<ImgVo> imgIds) {
		this.imgIds = imgIds;
	}

	public List<VodVo> getVods() {
		return vods;
	}

	public void setVods(List<VodVo> vods) {
		this.vods = vods;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public String getDogBreedCn() {
		return dogBreedCn;
	}

	public void setDogBreedCn(String dogBreedCn) {
		this.dogBreedCn = dogBreedCn;
	}

	public String getDogColor() {
		return dogColor;
	}

	public void setDogColor(String dogColor) {
		this.dogColor = dogColor;
	}

	public String getDogColorCn() {
		return dogColorCn;
	}

	public void setDogColorCn(String dogColorCn) {
		this.dogColorCn = dogColorCn;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public String getDogNose() {
		return dogNose;
	}

	public void setDogNose(String dogNose) {
		this.dogNose = dogNose;
	}

	public String getNewMemberFlag() {
		return newMemberFlag;
	}

	public void setNewMemberFlag(String newMemberFlag) {
		this.newMemberFlag = newMemberFlag;
	}

	public Date getDogBirth() {
		return dogBirth;
	}

	public void setDogBirth(Date dogBirth) {
		this.dogBirth = dogBirth;
	}

}
