/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogActivationDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBirthCertificateTransfer;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogSticker;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBirthCertificateTransferService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogStickerService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.kennel.service.KennelAllianceService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.entity.UserCouponCompose;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.coupon.vo.CouponGroupVO;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.oa.tcb.service.TcbKennelService;
import com.cku.restful.v1.breeder.dto.RestPupDogDto;
import com.cku.restful.v1.breeder.dto.RestQueryDogDto;
import com.cku.restful.v1.breeder.model.IEnumDogBirthCertificate;
import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.dog.vo.RestDogBirthCertificatePostVO;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.util.DateUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 出生证明Service
 *
 * @author lgl
 * @version 2016-08-04
 */
@Service
@Transactional(readOnly = true)
public class BreederDogBirthCertificateService {
	@Autowired
	private RestDogBirthCertificateService restDogBirthCertificateService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private KennelAllianceService kennelAllianceService;
	@Autowired
	private TcbKennelService tcbKennelService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogActivationDao dogActivationDao;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private StudDogService studDogService;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogStickerService dogStickerService;
	@Autowired
	private DogBirthCertificateTransferService dogBirthCertificateTransferService;
	/**
	 * 第二繁殖人登记服务费
	 */
	private static final String SECOND_BREEDER = "second_breeder@all";

	private Logger logger = LoggerFactory.getLogger(BreederDogBirthCertificateService.class);


	@Transactional(readOnly = false)
	public RESTResponse post(String json, HttpServletRequest request) {
		RESTResponse response = restDogBirthCertificateService.post(json);
		String[] cardIds = response.getData().getString("data").split(",");
		return restOrderService.cartToOrder(cardIds);
	}

	public RESTResponse order(String id) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		PaymentOrder paymentOrder = paymentOrderDao.get(id);
		if (paymentOrder == null || !paymentOrder.getMemberCode().equals(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号有误");
		}
		String productNum = "";
		String fmdogBreedCertifiedCode = null;
		PaymentOrderDetail detail = null;
		JSONObject couponComposeJo = null;// 券包购买费
		JSONObject sysCouponJo = null;// 券包购买费
		// 组装返回对象
		JSONObject jo = new JSONObject();
		jo.put("orderCode", paymentOrder.getOrderCode());
		JSONArray ja = new JSONArray();
		DecimalFormat df = new DecimalFormat("0.00");

		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrderDetailDao
				.getOrderByRunningNum(paymentOrder.getOrderCode(), memberCode);
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			if ("dog_birth_certificate".equals(paymentOrderDetail.getBusinessTable())) {
				if ("242".equals(paymentOrderDetail.getChargingItemId())) {
					detail = paymentOrderDetail;
					fmdogBreedCertifiedCode = paymentOrderDetail.getBusinessIds();
					productNum = paymentOrderDetail.getNum();
				}
				String chargingItemId = paymentOrderDetail.getChargingItemId();
				PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(chargingItemId);
				logger.info("BreederDogBirthCertificateService order ------------ paymentChargingItem : {}", JSONObjectUtils.toJsonString(paymentChargingItem));
				if (Objects.nonNull(paymentChargingItem)) {
					if (Objects.equals(paymentChargingItem.getShortName(), SECOND_BREEDER)) {
						logger.info("-----------------已经添加收费项，第二繁育人---------------");
						// 第二繁育人的费用明细
						JSONObject secondBreeder = new JSONObject();
						secondBreeder.put("name", paymentChargingItem.getName());
						secondBreeder.put("info", "");
						secondBreeder.put("price", df.format(Double.valueOf(paymentChargingItem.getPrice())));
						secondBreeder.put("productNum", Constants.STRING_NUM_ONE);
						ja.add(secondBreeder);
					}
				}
			}
			// 是否有券包
			if ("user_coupon_compose".equals(paymentOrderDetail.getBusinessTable())) {
				UserCouponCompose userCouponCompose = sysCouponService
						.getUserComposeById(paymentOrderDetail.getBusinessIds());
				couponComposeJo = new JSONObject();
				couponComposeJo.put("name", "登记卡优惠包费用");
				couponComposeJo.put("info", null);
				couponComposeJo.put("price", df.format(Double.valueOf(userCouponCompose.getComposePrice())));
			}
			// 是否有优惠券抵扣
			if ("sys_coupon".equals(paymentOrderDetail.getBusinessTable())) {
				sysCouponJo = new JSONObject();
				sysCouponJo.put("name", "登记卡抵扣费用X" + paymentOrderDetail.getNum());
				sysCouponJo.put("info", null);
				sysCouponJo.put("price", paymentOrderDetail.getTotalPrice());
			}
		}
		if (StringUtils.isBlank(fmdogBreedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单有误");
		}

		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao
				.findByFmdogBreedCertifiedCodeAndRunningNumber(fmdogBreedCertifiedCode, paymentOrder.getOrderCode());
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateList.get(0);



		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(detail.getChargingItemId());
		String productPrice = paymentChargingItem.getPrice();

		// if ("1".equals(dogBirthCertificate.getEcertFlag())) {
		// JSONObject otherJo = new JSONObject();
		// otherJo.put("name", "电子版证书");
		// otherJo.put("info", "每张节省" + RestDogBirthCertificateService.ECERT_DISCOUNTS +
		// "元");
		// otherJo.put("num", productNum);
		// otherJo.put("price", "-" + RestDogBirthCertificateService.ECERT_DISCOUNTS *
		// Double.parseDouble(productNum));
		// ja.add(otherJo);
		// }

		if ("1".equals(dogBirthCertificate.getUrgent())) {
			Double urgentFee = Double.parseDouble(productPrice) * 0.3 * Double.parseDouble(productNum);
			// 加急
			JSONObject urgentJo = new JSONObject();
			urgentJo.put("name", "加急办理");
			urgentJo.put("info", "1天完成审批，增加30%手续费");
			urgentJo.put("price", df.format(urgentFee));
			ja.add(urgentJo);
			if (kennelAllianceService.isUrgentFree(dogBirthCertificate.getBreederMemberCode())
					|| tcbKennelService.isUrgentFree(dogBirthCertificate.getBreederMemberCode())) {
				// 免加急费
				JSONObject urgentFreeJo = new JSONObject();
				urgentFreeJo.put("name", "免加急费");
				urgentFreeJo.put("info", "淘宠宝用户或犬舍联盟免加急费");
				urgentFreeJo.put("price", "-" + df.format(urgentFee));
				ja.add(urgentFreeJo);
			}
		}
		// 是否有优惠券包收费项
		if (couponComposeJo != null) {
			ja.add(couponComposeJo);
		}
		// 是否有优惠券抵扣
		if (sysCouponJo != null) {
			ja.add(sysCouponJo);
		}
		jo.put("other", ja);
		jo.put("totalPrice", paymentOrder.getTotalPrice());
		// 判断产品类型
		jo.put("productName", "新生犬登记服务费");
		jo.put("productNum", productNum);

		PaymentChargingItem otherPaymentChargingItem = paymentChargingItemService
				.getByShortName("dog_chip_change@chipFee");
		Double productPriceDouble = Double.parseDouble(productPrice)
				+ Double.parseDouble(otherPaymentChargingItem.getPrice());
		jo.put("productPrice", df.format(productPriceDouble));
		return new RESTResponse("data", jo);
	}

	public RESTResponse getTransferList(HttpServletRequest request, HttpServletResponse response) {
		Member member = UserUtils.getLoginMember();
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 根据编号查询
		String number = request.getParameter("number");
		String source = request.getParameter("source");
		String club = request.getHeader("club");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.getTransferList(number,
				member.getMemberCode(), source, (pageNoInt - 1) * pageSizeInt, pageSizeInt);
		List<JSONObject> list = Lists.newArrayList();
		for (DogBirthCertificate obj : dogBirthCertificateList) {
			JSONObject dogBirthCertificateJson = new JSONObject();
			dogBirthCertificateJson.put("id", getString(obj.getId()));
			dogBirthCertificateJson.put("dogName", obj.getDogEnName());
			dogBirthCertificateJson.put("dogGender", getString(obj.getDogGender()));
			dogBirthCertificateJson.put("birthCerRegCode", getString(obj.getBirthCerRegCode()));
			dogBirthCertificateJson.put("identificationFlag", getString(obj.getIdentificationFlag()));
			dogBirthCertificateJson.put("isAll", getString(obj.getIsAll()));
			String dogColorMarkCn = dogColorMarkService.getDogColorMarkCn(obj.getColorFlag());
			if (dogColorMarkCn.contains("-")) {
				String[] dogColorMarkCnArray = dogColorMarkCn.split("-");
				if (dogColorMarkCnArray.length == 2) {
					dogColorMarkCn = dogColorMarkCnArray[1];
				}
			}
			dogBirthCertificateJson.put("colorFlag", getString(dogColorMarkCn));
			dogBirthCertificateJson.put("ecertFlag", getString(obj.getEcertFlag()));
			dogBirthCertificateJson.put("businessState", dogBirthCertificateService.getBusinessState(obj));
			// 是否能申请血统证书标记位
			dogBirthCertificateJson.put("canApplyPedigreeCertifiedFlag",
					getString(getCanApplyPedigreeCertifiedFlag(obj)));
			// String dogActivationState = "";
			// String dogActivationReviewState = "";
			// DogActivation dogActivation =
			// dogActivationDao.getByBirthCode(obj.getBirthCerRegCode());
			// if (dogActivation != null) {
			// dogActivationState = dogActivation.getState();
			// dogActivationReviewState = dogActivation.getReviewState();
			// }
			// dogBirthCertificateJson.put("dogActivationState", dogActivationState);
			// dogBirthCertificateJson.put("dogActivationReviewState",
			// dogActivationReviewState);
			// 是否可以转让 0:可以 1:不可
			// 可转让条件 新生成数据（历史数据不能转让），同时审核状态为通过，匹配有芯片记录
			dogBirthCertificateJson.put("canTransferFlag", getTransferFlag(club, obj));
			// 鼻纹信息
			DogNose dogNose = new DogNose();
			dogNose.setDogBirthCertificateId(obj.getId());
			dogNose.setDelFlag("0");
			List<DogNose> ns = dogNoseService.findList(dogNose);
			if (!CollectionUtils.isEmpty(ns)) {
				DogNose n = ns.get(0);
				dogBirthCertificateJson.put("noseCode", n.getNoseCode());
			} else {
				dogBirthCertificateJson.put("noseCode", "");
			}

			dogBirthCertificateJson.put("cabPassport", obj.getCabPassport());

			DogSticker dogSticker = dogStickerService
					.getDogStickerByIdentificationFlagByOne(obj.getIdentificationFlag());
			if (dogSticker != null) {
				dogBirthCertificateJson.put("registerGrade", dogSticker.getStickerNo().substring(0, 1));
				dogBirthCertificateJson.put("registerGradeDesc", getStickerDesc(dogSticker.getStickerClass()));
			} else {
				dogBirthCertificateJson.put("registerGrade", "");
				dogBirthCertificateJson.put("registerGradeDesc", "");
			}

			dogBirthCertificateJson.put("snCode", obj.getSnCode());
			dogBirthCertificateJson.put("dogBreed", dogTypeService.getBreedCnName(obj.getDogBreed()));
			dogBirthCertificateJson.put("dogEnBreed", dogTypeService.getBreedEnName(obj.getDogBreed()));
			dogBirthCertificateJson.put("dogBreedCode", obj.getDogBreed());

			dogBirthCertificateJson.put("dogBirthday", DateUtils.dateToStr(obj.getDogBirthday()));
			dogBirthCertificateJson.put("pedigreeCertified", obj.getPedigreeCertified());
			dogBirthCertificateJson.put("breeder", obj.getBreeder());
			list.add(dogBirthCertificateJson);
		}
		Long count = dogBirthCertificateDao.getTransferListCount(number, member.getMemberCode(), source);
		return new RESTResponse("list", new PageBeanResult<>(list, count));
	}

	// public RESTResponse getTransfer(HttpServletRequest request) {
	// Member member = UserUtils.getLoginMember();
	// String id = request.getParameter("id");
	// if (StringUtils.isBlank(id)) {
	// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数id为空");
	// }
	// DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(id);
	// if(!member.getMemberCode().equals(dogBirthCertificate.getTransferCode())) {
	// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登记卡所属人已变更");
	// }
	//
	// return null;
	// }

	private String getStickerDesc(String stickerNo) {
		String str = "";
		switch (stickerNo) {
		case "1":
			str = "纯种级";
			break;
		case "2":
			str = "纯血级";
			break;
		case "3":
			str = "赛级";
			break;
		case "4":
			str = "冠军级";
			break;
		default:
			break;
		}
		return str;
	}

	public RESTResponse getInfo(HttpServletRequest request) {
		// Member member = UserUtils.getLoginMember();
		String id = request.getParameter("id");
		String club = request.getHeader("club");
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数id为空");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(id);
		JSONObject dogBirthCertificateJson = new JSONObject();

		dogBirthCertificateJson.put("id", getString(dogBirthCertificate.getId()));
		dogBirthCertificateJson.put("dogName", dogBirthCertificate.getDogEnName());
		dogBirthCertificateJson.put("dogGender", getString(dogBirthCertificate.getDogGender()));
		dogBirthCertificateJson.put("birthCerRegCode", getString(dogBirthCertificate.getBirthCerRegCode()));
		dogBirthCertificateJson.put("identificationFlag", getString(dogBirthCertificate.getIdentificationFlag()));
		dogBirthCertificateJson.put("isAll", getString(dogBirthCertificate.getIsAll()));
		String dogColorMarkCn = dogColorMarkService.getDogColorMarkCn(dogBirthCertificate.getColorFlag());
		if (dogColorMarkCn.contains("-")) {
			String[] dogColorMarkCnArray = dogColorMarkCn.split("-");
			if (dogColorMarkCnArray.length == 2) {
				dogColorMarkCn = dogColorMarkCnArray[1];
			}
		}
		dogBirthCertificateJson.put("colorFlag", getString(dogColorMarkCn));
		dogBirthCertificateJson.put("ecertFlag", getString(dogBirthCertificate.getEcertFlag()));
		dogBirthCertificateJson.put("businessState", dogBirthCertificateService.getBusinessState(dogBirthCertificate));
		// 是否能申请血统证书标记位
		dogBirthCertificateJson.put("canApplyPedigreeCertifiedFlag",
				getString(getCanApplyPedigreeCertifiedFlag(dogBirthCertificate)));
		String dogActivationState = "";
		String dogActivationReviewState = "";
		DogActivation dogActivation = dogActivationDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogActivation != null) {
			dogActivationState = dogActivation.getState();
			dogActivationReviewState = dogActivation.getReviewState();
		}
		dogBirthCertificateJson.put("dogActivationState", dogActivationState);
		dogBirthCertificateJson.put("dogActivationReviewState", dogActivationReviewState);
		// 是否可以转让 1:可以 0:不可
		// 可转让条件 新生成数据（历史数据不能转让），同时审核状态为通过，匹配有芯片记录
		dogBirthCertificateJson.put("canTransferFlag", getTransferFlag(club, dogBirthCertificate));
		// 是否可以申请实体护照 TODO zhaoxy
		dogBirthCertificateJson.put("canCabPassportFlag", "");
		// 鼻纹信息
		DogNose dogNose = new DogNose();
		dogNose.setDogBirthCertificateId(dogBirthCertificate.getId());
		dogNose.setDelFlag("0");
		List<DogNose> ns = dogNoseService.findList(dogNose);
		if (!CollectionUtils.isEmpty(ns)) {
			DogNose n = ns.get(0);
			dogBirthCertificateJson.put("noseCode", n.getNoseCode());
		} else {
			dogBirthCertificateJson.put("noseCode", "");
		}
		dogBirthCertificateJson.put("birthCerRegCode", dogBirthCertificate.getBirthCerRegCode());
		dogBirthCertificateJson.put("cabPassport", dogBirthCertificate.getCabPassport());

		DogSticker dogSticker = dogStickerService
				.getDogStickerByIdentificationFlagByOne(dogBirthCertificate.getIdentificationFlag());
		if (dogSticker != null) {
			dogBirthCertificateJson.put("registerGrade", dogSticker.getStickerNo().substring(0, 1));
			dogBirthCertificateJson.put("registerGradeDesc", getStickerDesc(dogSticker.getStickerClass()));
		} else {
			dogBirthCertificateJson.put("registerGrade", "");
			dogBirthCertificateJson.put("registerGradeDesc", "");
		}
		dogBirthCertificateJson.put("snCode", dogBirthCertificate.getSnCode());
		dogBirthCertificateJson.put("dogBreed", dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed()));
		dogBirthCertificateJson.put("dogEnBreed", dogTypeService.getBreedEnName(dogBirthCertificate.getDogBreed()));
		dogBirthCertificateJson.put("dogBreedCode", dogBirthCertificate.getDogBreed());
		dogBirthCertificateJson.put("dogBirthday", DateUtils.dateToStr(dogBirthCertificate.getDogBirthday()));

		return new RESTResponse("data", dogBirthCertificateJson);
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();
		String club = request.getHeader("club");
		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String canApplyDogBirthCertificateFlag = request.getParameter("canApplyDogBirthCertificateFlag");
		// 根据编号查询
		String number = request.getParameter("number");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		if (StringUtils.isBlank(canApplyDogBirthCertificateFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数canApplyDogBirthCertificateFlag为空");
		}
		if (!"0".equals(canApplyDogBirthCertificateFlag) && !"1".equals(canApplyDogBirthCertificateFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数canApplyDogBirthCertificateFlag只能为0或1");
		}

		// 查询并组装返回对象
		List<DogNewborn> dogNewbornList = dogNewbornDao.getList(member.getMemberCode(), canApplyDogBirthCertificateFlag,
				(pageNoInt - 1) * pageSizeInt, pageSizeInt, number);
		List<JSONObject> list = Lists.newArrayList();
		for (DogNewborn dogNewborn : dogNewbornList) {
			JSONObject jo = new JSONObject();
			jo.put("id", dogNewborn.getId());
			jo.put("breedCertifiedCode", dogNewborn.getBreedCertifiedCode());
			jo.put("malePedigreeCertified", dogNewborn.getMalePedigreeCertified());
			jo.put("femalePedigreeCertified", dogNewborn.getFemalePedigreeCertified());
			jo.put("dogBreed", dogTypeService.getBreedCnName(dogNewborn.getDogBreed()));
			jo.put("dogBreedCode", dogNewborn.getDogBreed());
			jo.put("puppyRegisterNum", dogNewborn.getPuppyRegisterNum());
			jo.put("birthday", dogNewborn.getBirthday() == null ? "" : DateUtils.dateToStr(dogNewborn.getBirthday()));
			jo.put("createDate", DateUtils.dateToStr(dogNewborn.getCreateDate()));
			jo.put("breedDate", DateUtils.dateToStr(dogNewborn.getBreedDate()));
			jo.put("maleDogOwner", dogNewborn.getMaleDogOwner());
			jo.put("femaleDogOwner", dogNewborn.getFemaleDogOwner());
			jo.put("reviewState", dogNewborn.getReviewState());
			JSONArray ja = new JSONArray();
			if ("0".equals(canApplyDogBirthCertificateFlag)) {
				// 查询出生纸信息
				List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao
						.findByFmdogBreedCertifiedCode(dogNewborn.getBreedCertifiedCode());
				for (DogBirthCertificate dogBirthCertificate : dogBirthCertificateList) {
					JSONObject dogBirthCertificateJson = new JSONObject();
					dogBirthCertificateJson.put("id", getString(dogBirthCertificate.getId()));
					dogBirthCertificateJson.put("dogGender", getString(dogBirthCertificate.getDogGender()));
					dogBirthCertificateJson.put("birthCerRegCode", getString(dogBirthCertificate.getBirthCerRegCode()));
					dogBirthCertificateJson.put("identificationFlag",
							getString(dogBirthCertificate.getIdentificationFlag()));
					dogBirthCertificateJson.put("isAll", getString(dogBirthCertificate.getIsAll()));
					String dogColorMarkCn = dogColorMarkService.getDogColorMarkCn(dogBirthCertificate.getColorFlag());
					if (dogColorMarkCn.contains("-")) {
						String[] dogColorMarkCnArray = dogColorMarkCn.split("-");
						if (dogColorMarkCnArray.length == 2) {
							dogColorMarkCn = dogColorMarkCnArray[1];
						}
					}
					dogBirthCertificateJson.put("colorFlag", getString(dogColorMarkCn));
					dogBirthCertificateJson.put("ecertFlag", getString(dogBirthCertificate.getEcertFlag()));
					dogBirthCertificateJson.put("businessState",
							dogBirthCertificateService.getBusinessState(dogBirthCertificate));
					// 是否能申请血统证书标记位
					dogBirthCertificateJson.put("canApplyPedigreeCertifiedFlag",
							getString(getCanApplyPedigreeCertifiedFlag(dogBirthCertificate)));
					String dogActivationState = "";
					String dogActivationReviewState = "";
					DogActivation dogActivation = dogActivationDao
							.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
					if (dogActivation != null) {
						dogActivationState = dogActivation.getState();
						dogActivationReviewState = dogActivation.getReviewState();
					}
					dogBirthCertificateJson.put("dogActivationState", dogActivationState);
					dogBirthCertificateJson.put("dogActivationReviewState", dogActivationReviewState);
					// 是否可以转让 0:可以 1:不可
					// 可转让条件 新生成数据（历史数据不能转让），同时审核状态为通过，匹配有芯片记录
					// dogBirthCertificateJson.put("canTransferFlag", getTransferFlag(club, dogBirthCertificate));
					dogBirthCertificateJson.put("canTransferFlag", "");

					// DogNose dogNose = dogNoseService.getByDogIdODogBirthCertificateId(getString(dogBirthCertificate.getId()), null);
					// dogBirthCertificateJson.put("dogNoseFlag", dogNose == null);
					dogBirthCertificateJson.put("snCode", dogBirthCertificate.getSnCode());

					ja.add(dogBirthCertificateJson);
				}
			}
			jo.put("dogBirthCertificateList", ja);
			list.add(jo);
		}
		long count = dogNewbornDao.getListCount(member.getMemberCode(), canApplyDogBirthCertificateFlag, number);
		return new RESTResponse("list", new PageBeanResult<>(list, count));
	}

	/**
	 * 更改状态
	 *
	 * @param mcode
	 * @param state
	 * @param id
	 * @return
	 */
	@Transactional(readOnly = false)
	public void updateState(String mcode, String state, String id) {

		DogActivation dogActivation = dogActivationService.getByBirthCode(id);
		if (dogActivation == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");

		if (StringUtils.isBlank(dogActivation.getState()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少上架状态参数");

		if (!"0".equals(dogActivation.getState()) && !"1".equals(dogActivation.getState()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "上架状态只能为0或1");

		dogActivation.setState(state);
		if (state.equals("1")) {
			int monthAge = getMonthAge(new Date(), dogActivation.getDogBirthday());
			if (monthAge > 24)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬龄大于24个月、不能上架");

			dogActivation.setAddTime(new Date());
			dogActivation.setUpperReview("1");
		} else {
			dogActivation.setConsign("0");
		}
		if ("0".equals(dogActivation.getPrice()) || StringUtils.isBlank(dogActivation.getPrice()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报价为0或为空不能做此操作");
		dogActivationService.save(dogActivation);

		// return dogBirthCertificateDao.updateState(mcode, state, id);
	}

	private int getMonthAge(Date date, Date birthdate) {
		Calendar dateCalendar = Calendar.getInstance();
		Calendar birthdateCalendar = Calendar.getInstance();
		dateCalendar.setTime(date);
		birthdateCalendar.setTime(birthdate);
		int monthAge = dateCalendar.get(Calendar.MONTH) - birthdateCalendar.get(Calendar.MONTH);
		if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar.get(Calendar.YEAR)) {
			monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar.get(Calendar.YEAR)) * 12 + monthAge;
		}
		birthdateCalendar.add(Calendar.MONTH, monthAge);
		if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
			monthAge = monthAge - 1;
		}
		return monthAge;
	}

	public RESTResponse excludeCkuhk(HttpServletRequest request) {
		String breedCertifiedCode = request.getParameter("breedCertifiedCode");
		if (StringUtils.isEmpty(breedCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "breedCertifiedCode参数为空");
		}
		DogNewborn born = dogNewbornDao.getByBreedCertifiedCode(breedCertifiedCode);
		if (born != null) {
			String fdog = born.getMalePedigreeCertified();
			String mdog = born.getFemalePedigreeCertified();
			if (StringUtils.isNotBlank(fdog) && StringUtils.isNotBlank(mdog)
					&& (fdog.toUpperCase().contains("CKUHK") || mdog.toUpperCase().contains("CKUHK"))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写新生犬登记表进行线下提交，如有疑问请致电4006607000.");
			}
		}
		return new RESTResponse();
	}

	public RESTResponse getList1(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();

		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String searchKey = request.getParameter("searchKey");
		// 性別
		String dogGender = request.getParameter("dogGender");
		// 品种
		String dogBreed = request.getParameter("dogBreed");
		// 状态
		String state = request.getParameter("state");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		int dogGenderInt = 0;
		int stateInt = 0;

		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
			if (StringUtils.isNoneBlank(dogGender))
				dogGenderInt = Integer.parseInt(dogGender);
			if (StringUtils.isNoneBlank(state))
				stateInt = Integer.parseInt(state);

		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		if (!IEnumDogBirthCertificate.EnumDogType.isInEnum(stateInt))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "state超出范围");
		if (!IEnumDogBirthCertificate.EnumGender.isInEnum(dogGenderInt))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "dogGender超出范围");
		String type = request.getParameter("type");
		if (StringUtils.isBlank(type)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "type参数为空");
		}
		if (!"sold".equals(type) && !"unsold".equals(type)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "type参数只能为sold或者unsold");
		}
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.getList1(dogBreed, stateInt,
				dogGenderInt, member.getMemberCode(), type, searchKey, (pageNoInt - 1) * pageSizeInt, pageSizeInt,
				new Date(DogBirthCertificateService.DOG_ACTIVATION_MILLIS));
		int len = dogBirthCertificateList.size();
		StringBuffer currentPageIdentifyFlags = null;
		currentPageIdentifyFlags = new StringBuffer();
		// 查询犬只购买保险信息
		for (int i = 0; i < len; i++) {
			if (StringUtils.isNotEmpty(dogBirthCertificateList.get(i).getIdentificationFlag()))
				if (i == len - 1) {
					currentPageIdentifyFlags.append(dogBirthCertificateList.get(i).getIdentificationFlag());
				} else {
					currentPageIdentifyFlags.append(dogBirthCertificateList.get(i).getIdentificationFlag()).append(",");
				}
		}
		// JSONObject jsonObject = null;
		// String data = getDogInsuranceInfo(currentPageIdentifyFlags.toString(),
		// member.getMemberCode());
		// if (data != null) {
		// jsonObject = JSONObject.fromObject(data);
		// }
		// Object ob = jsonObject.get("data");
		// jsonObject = JSONObject.fromObject(ob);
		List<JSONObject> list = Lists.newArrayList();

		for (DogBirthCertificate dogBirthCertificate : dogBirthCertificateList) {
			JSONObject jo = new JSONObject();
			// Object obj = jsonObject.get(dogBirthCertificate.getIdentificationFlag());
			// Object insuranceCount = jsonObject.get("insuranceCount");
			// if ("true".equals(obj)) {
			// jo.put("insuranceState", "1");
			// } else {
			// jo.put("insuranceState", "0");
			// }
			jo.put("insuranceState", "0");
			// jo.put("isShowBuyInsurance",
			// isCanBuyInsurance(dogBirthCertificate.getDogBirthday(), insuranceCount));
			jo.put("isShowBuyInsurance", isCanBuyInsurance(dogBirthCertificate.getDogBirthday(), 0));
			jo.put("birthCerRegCode", getString(dogBirthCertificate.getBirthCerRegCode()));
			jo.put("dogBreed", dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed()));
			jo.put("dogGender", getString(dogBirthCertificate.getDogGender()));
			String dogColorMarkCn = dogColorMarkService.getDogColorMarkCn(dogBirthCertificate.getColorFlag());
			if (dogColorMarkCn.contains("-")) {
				String[] dogColorMarkCnArray = dogColorMarkCn.split("-");
				if (dogColorMarkCnArray.length == 2) {
					dogColorMarkCn = dogColorMarkCnArray[1];
				}
			}
			jo.put("colorFlag", getString(dogColorMarkCn));
			jo.put("age", studDogService.getAge(dogBirthCertificate.getDogBirthday()));
			jo.put("identificationFlag", getString(dogBirthCertificate.getIdentificationFlag()));
			jo.put("businessState", dogBirthCertificateService.getBusinessState(dogBirthCertificate));
			String frontPic = "";
			String price = "";
			String dogActivationState = "";
			String dogActivationReviewState = "";
			DogActivation dogActivation = dogActivationDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
			if (dogActivation != null) {
				frontPic = ImgUtil.getImgUrl(request, dogActivation.getFrontPic());
				price = getString(dogActivation.getPrice());
				dogActivationState = dogActivation.getState();
				dogActivationReviewState = dogActivation.getReviewState();
			}
			jo.put("frontPic", frontPic);
			jo.put("price", price);
			jo.put("dogActivationState", dogActivationState);
			jo.put("dogActivationReviewState", dogActivationReviewState);
			String upr = dogBirthCertificate.getUpperReview();
			String s = dogBirthCertificate.getState();
			jo.put("upperReview", StringUtils.isEmpty(upr) ? "-1" : upr);
			jo.put("state", StringUtils.isEmpty(s) ? "-1" : s);
			list.add(jo);
		}
		long count = dogBirthCertificateDao.getList1Count(dogBreed, stateInt, dogGenderInt, member.getMemberCode(),
				type, searchKey, new Date(DogBirthCertificateService.DOG_ACTIVATION_MILLIS));
		return new RESTResponse("list", new PageBeanResult<>(list, count));
	}

	/**
	 * @param birthData
	 * @param insuranceCount 是否能领取保险 0 否 1 是
	 **/
	private String isCanBuyInsurance(Date birthData, Object insuranceCount) {
		int insuranceNum = 0;
		if (birthData == null) {
			return "0";
		}
		if (insuranceCount != null) {
			insuranceNum = Integer.parseInt(insuranceCount.toString());
		}

		int monthAge = studDogService.getMonthAge(new Date(), birthData);
		if (monthAge >= 3 && monthAge <= 9 && insuranceNum > 0) {
			return "1";
		} else {
			return "0";
		}
	}

	@Transactional(readOnly = false)
	public RESTResponse updateSoldState(String json) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("birthCode") || StringUtils.isBlank(jo.getString("birthCode"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "birthCode为空");
		}
		if (!jo.containsKey("soldState") || StringUtils.isBlank(jo.getString("soldState"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "soldState为空");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
				.getByBirthCerRegCode(jo.getString("birthCode"));
		if (dogBirthCertificate == null || !memberCode.equals(dogBirthCertificate.getBreederMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// 已售
		if ("sold".equals(jo.getString("soldState"))) {
			dogBirthCertificateDao.saveSoldDogBirthCertificate(dogBirthCertificate);
		}
		// 犬只激活需要下架
		DogActivation dogActivation = dogActivationDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogActivation != null && "1".equals(dogActivation.getState())) {
			dogActivation.setState("0");
			dogActivationService.save(dogActivation);
		}
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse updateDogActivationState(String json) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		JSONObject jo = JSONObject.fromObject(json);
		if (!jo.containsKey("birthCode") || StringUtils.isBlank(jo.getString("birthCode"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "birthCode为空");
		}
		if (!jo.containsKey("state") || StringUtils.isBlank(jo.getString("state"))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "state为空");
		}
		String state = jo.getString("state");
		if (!"0".equals(state) && !"1".equals(state)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "state只能为0或1");
		}
		DogActivation po = dogActivationDao.getByBirthCode(jo.getString("birthCode"));
		if (po == null || !memberCode.equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		po.setState(state);
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(po.getBirthCode());
		dogActivationService.validatInfo(po);
		dogActivationService.validatePrice(po, dogBirthCertificate, "请重新编辑犬只价格后再上架");
		// 更新上架时间
		dogActivationService.setAddTime(po, state);
		dogActivationService.save(po);
		return new RESTResponse();
	}

	/**
	 * @description: 获取是否能申请血统证书标记位，0表示不可以申请，1表示可以申请
	 * @author: laiguanglong
	 * @date: 2017/12/28 14:50
	 */
	private String getCanApplyPedigreeCertifiedFlag(DogBirthCertificate dogBirthCertificate) {
		if (!UserUtils.getLoginMember().getMemberCode().equals(dogBirthCertificate.getMemberCode())) {
			return "0";
		}
		if (StringUtils.isNotBlank(dogChipService.checkDogBirthCertificateString(dogBirthCertificate))) {
			return "0";
		}
		if ("1".equals(dogBirthCertificate.getIsAll())) {
			return "0";
		}
		// 已申请过血统证书
		// 校验重复订单
		DogChip example = new DogChip();
		example.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		// 已撤销的不校验
		example.setIsCanceled("0");
		example.setReviewStateExclud("3");
		List<DogChip> findList = dogChipService.findList(example);
		if (findList.size() > 0) {
			// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
			// "该新生犬登记卡已申请血统证书业务，请勿重复申请业务");
			return "0";
		}

		return "1";
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	@Value("${DogBirthCertificateTransferLaunchDate}")
	private String DogBirthCertificateTransferLaunchDate;

	private String getTransferFlag(String club, DogBirthCertificate dogBirthCertificate) {
		String[] temps = DogBirthCertificateTransferLaunchDate.split("-");
		Integer y = Integer.valueOf(temps[0]);
		Integer m = Integer.valueOf(temps[1]);
		Integer d = Integer.valueOf(temps[2]);
		Date TRANSFER_LAUNCH_DATE = new Date(y - 1900, m - 1, d + 1, 0, 0);

		// 审核未通过不可转让
		if (!"1".equals(dogBirthCertificate.getReviewState())) {
			return "1";
		}
		// 正窝办理不可转让
		if ("1".equals(dogBirthCertificate.getIsAll())) {
			return "1";
		}
		// 匹配无芯片记录不可转让
		if (StringUtils.isEmpty(dogBirthCertificate.getIdentificationFlag())) {
			return "1";
		}
		// 已申请血统证书不可转让
		DogChip dogChip = dogChipService.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (dogChip != null) {
			return "1";
		}

		// 老数据不可转让
		if (dogBirthCertificate.getPaymentTime() != null) {
			if (TRANSFER_LAUNCH_DATE.after(dogBirthCertificate.getPaymentTime())) {
				return "1";
			}
		}

		// if
		// (!dogBirthCertificate.getBreederMemberCode().equals(dogBirthCertificate.getTempMemberCode()))
		// {
		// return "2";
		// }
		// 已转让
		DogBirthCertificateTransfer dogBirthCertificateTransfer = new DogBirthCertificateTransfer();
		dogBirthCertificateTransfer.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (!CollectionUtils.isEmpty(dogBirthCertificateTransferService.findList(dogBirthCertificateTransfer))) {
			return "2";
		}

		// 杜高/马犬不可转让
		if (!"cku".equals(club)) {
			return "3";
		}
		return "0";
	}

	/**
	 * 改正护照类型 0实体 1电子
	 *
	 * @param id
	 * @return
	 */
	@Transactional(readOnly = false)
	public void updatePhysicalCabPassport(String cabPassportType, String id) {
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.get(id);
		if (dogBirthCertificate == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		dogBirthCertificate.setEcertFlag(cabPassportType);// 电子证书标记位：0否；1是
		dogBirthCertificate.preUpdate();
		dogBirthCertificateDao.update(dogBirthCertificate);
	}

	// public static void main(String[] args) {
	// Date TRANSFER_LAUNCH_DATE = new Date(2020 - 1900, 6 - 1, 30 + 1, 0, 0);
	// String str =
	// com.thinkgem.jeesite.common.utils.DateUtils.formatDateTime(TRANSFER_LAUNCH_DATE);
	// System.out.println("上线日期：" + TRANSFER_LAUNCH_DATE);
	// System.out.println("日期：" + new Date());
	// System.out.println(TRANSFER_LAUNCH_DATE.after(new Date()));
	// if (TRANSFER_LAUNCH_DATE.after(new Date()))
	// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "老数据不可转让");
	// else
	// System.out.println("可以转让");
	//
	// }

	public PageResultDto<RestPupDogDto> findMarketPopDogByKennelCode(RestQueryDogDto queryDto,
			HttpServletRequest request) {
		// 获取参数
		String kennelCode = queryDto.getKennelCode();
		// 默认查询上架幼犬
		int stateInt = IEnumDogBirthCertificate.EnumDogType.OnShelves.getValue();
		if (StringUtils.isBlank(kennelCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬舍编号不能为空");
		}
		// 查询并组装返回对象
		List<DogBirthCertificate> dogBirthCertificateList = dogBirthCertificateDao.getList1(null, stateInt, null,
				kennelCode, "unsold", null, (queryDto.getPageNo() - 1) * queryDto.getPageSize(), queryDto.getPageSize(),
				new Date(DogBirthCertificateService.DOG_ACTIVATION_MILLIS));
		long totalCount = dogBirthCertificateDao.getList1Count(null, stateInt, null, kennelCode, "unsold", null,
				new Date(DogBirthCertificateService.DOG_ACTIVATION_MILLIS));
		List<RestPupDogDto> resultList = Collections.emptyList();
		if (!CollectionUtils.isEmpty(dogBirthCertificateList)) {
			resultList = dogBirthCertificateList.stream().map(dogBirthCertificate -> {
				RestPupDogDto restDog = new RestPupDogDto();
				restDog.setBirthCerRegCode(getString(dogBirthCertificate.getBirthCerRegCode()));
				restDog.setDogBreed(dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed()));
				restDog.setDogGender(getString(dogBirthCertificate.getDogGender()));
				String dogColorMarkCn = dogColorMarkService.getDogColorMarkCn(dogBirthCertificate.getColorFlag());
				if (dogColorMarkCn.contains("-")) {
					String[] dogColorMarkCnArray = dogColorMarkCn.split("-");
					if (dogColorMarkCnArray.length == 2) {
						dogColorMarkCn = dogColorMarkCnArray[1];
					}
				}
				restDog.setColorFlag(getString(dogColorMarkCn));
				restDog.setAge(studDogService.getAge(dogBirthCertificate.getDogBirthday()));
				restDog.setIdentificationFlag(getString(dogBirthCertificate.getIdentificationFlag()));
				String frontPic = "";
				String price = "";
				DogActivation dogActivation = dogActivationDao.getByBirthCode(dogBirthCertificate.getBirthCerRegCode());
				if (dogActivation != null) {
					frontPic = ImgUtil.getImgUrl(request, dogActivation.getFrontPic());
					price = getString(dogActivation.getPrice());
				}
				restDog.setFrontPic(frontPic);
				restDog.setPrice(price);
				restDog.setState(dogBirthCertificate.getState());
				return restDog;
			}).collect(Collectors.toList());
		}
		return PageResultDto.success(resultList, totalCount);

	}

	@Autowired
	private SysCouponService sysCouponService;

	public static final String SUPPOSITIONAL_COUPON_FLAG = "suppositional_";

	@Transactional(readOnly = false)
	public PageResultDto<RestCouponGroup> getCoupons(int pageNoInt, int pageSizeInt) throws Exception {
		Member member = UserUtils.getLoginMember();

		SysCoupon example = new SysCoupon();
		example.setState("0");
		example.setMemberCode(member.getMemberCode());
		example.setTargetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGBIRTHCERTIFICATE }));
		Page<CouponGroupVO> result = sysCouponService.findGroupPage(new Page<SysCoupon>(pageNoInt, pageSizeInt),
				example);
		// 结果处理
		List<RestCouponGroup> resultList = new ArrayList<RestCouponGroup>();
		for (CouponGroupVO vo : result.getList()) {
			RestCouponGroup cg = new RestCouponGroup();
			cg.setGroupId(vo.getGroupId());
			cg.setCouponName(vo.getCouponName());
			cg.setCouponType(vo.getCouponType());
			cg.setCouponTypeDesc(vo.getCouponTypeDesc());
			cg.setCouponNum(vo.getCouponNum());
			cg.setFacePrice(vo.getFacePrice());
			cg.setTarget(vo.getTarget());
			cg.setExplains("");
			resultList.add(cg);
		}
		return PageResultDto.success(resultList, result.getCount());
	}

	@Transactional(readOnly = false)
	public ResultDto<RestCouponGroup> getOptimalCoupons(int num) throws Exception {
		Member member = UserUtils.getLoginMember();

		if (num <= 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只数量必须大于0!");
		}
		// 所有优惠券
		SysCoupon example = new SysCoupon();
		example.setState("0");
		example.setMemberCode(member.getMemberCode());
		example.setTargetList(Arrays.asList(new String[] { ConstantUtils.COUPON_TARGET_DOGBIRTHCERTIFICATE }));
		List<CouponGroupVO> result = sysCouponService.findGroupList(example);

		if (result.size() > 0) {
			RestCouponGroup dto = new RestCouponGroup();
			// 总额最大
			BigDecimal discount = BigDecimal.ZERO;
			for (CouponGroupVO vo : result) {
				BigDecimal discountT = num > vo.getCouponNum()
						? vo.getFacePrice().multiply(BigDecimal.valueOf(vo.getCouponNum()))
						: vo.getFacePrice().multiply(BigDecimal.valueOf(num));
				if (discountT.compareTo(discount) == 1) {
					discount = discountT;
					dto.setGroupId(vo.getGroupId());
					dto.setCouponName(vo.getCouponName());
					dto.setCouponType(vo.getCouponType());
					dto.setCouponTypeDesc(vo.getCouponTypeDesc());
					dto.setCouponNum(vo.getCouponNum());
					dto.setFacePrice(vo.getFacePrice());
					dto.setTarget(vo.getTarget());
					dto.setExplains("");
					dto.setUseNum(num > vo.getCouponNum() ? vo.getCouponNum() : num);
				}
			}
			return ResultDto.success(dto);
		}

		return ResultDto.SUCCESSFUL();
	}

	@Transactional(readOnly = false)
	public ResultDto<String> getPrice(RestDogBirthCertificatePostVO postVO) throws Exception {
		Double price = restDogBirthCertificateService.getPrice(postVO);
		DecimalFormat df = new DecimalFormat("0.00");
		return ResultDto.success(df.format(price));
	}

}