package com.cku.partner.club.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 国外证书换发
 * @author chaixueteng
 *
 */
@Service
@Transactional(readOnly = true)
public class DogClubService {
	private static final String CLUBDOG_FEE = "club_dog@jd"; //淘宠宝纯种犬鉴定登记费

	@Autowired
	public DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	public PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	public RestOrderService restOrderService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public PaymentOrderDao paymentOrderDao;
	/**
	 * 鉴定犬换发构建订单
	 * @param id
	 */
	@Transactional(readOnly = false)
	public PaymentOrder toOrder(ClubDog clubDog) {
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(clubDog);
		//构造订单详情
		List<PaymentOrderDetail> paymentOrderDetailList =new ArrayList<PaymentOrderDetail>();
		paymentOrderDetailList= buildPaymentOrderDetailList(clubDog,paymentOrder);
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		//更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			//更新业务表不为空且不为会员表的收费项
			if(StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())&&!"sys_member".equals(paymentOrderDetail.getBusinessTable())&&!"kennel".equals(paymentOrderDetail.getBusinessTable())){
				String businessIds = paymentOrderDetail.getBusinessIds();
				if(businessIds.contains(",")){
					String[] bids = businessIds.split(",");
					for(int j=0;j<bids.length;j++){
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				}else{
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrder;
	}
	
	/**
	 * 构建犬只订单订单详情
	 * @param dogPedigreeCertifiedChange
	 * @return
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> buildPaymentOrderDetailList(ClubDog clubDog,PaymentOrder paymentOrder) {
		PaymentChargingItem clubDogFee = paymentChargingItemDao.getByShortName(CLUBDOG_FEE);
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		PaymentOrderDetail detail1 = new PaymentOrderDetail();
		detail1.setAddTime(paymentOrder.getAddTime());
		detail1.setProccessState("0");
		detail1.setTotalPrice(clubDogFee.getPrice());
		detail1.setNum("1");
		detail1.setPrice(clubDogFee.getPrice());
		detail1.setChargingItemId(clubDogFee.getId());
		detail1.setBusinessIds(clubDog.getId());
		detail1.setBusinessTable("club_dog");
		detail1.setMemberCode(paymentOrder.getMemberCode());
		detail1.setMemberName(paymentOrder.getMemberName());
		detail1.setChargingItemName(clubDogFee.getName());
		paymentOrderDetailList.add(detail1);
		return paymentOrderDetailList;
	}
	/**
	 * 构建订单基本信息
	 * @return
	 */
	@Transactional(readOnly = false)
	public PaymentOrder buildPaymentOrder(ClubDog clubDog) {
		PaymentOrder order = new PaymentOrder();
		order.setMemberCode(clubDog.getMemberCode());
		order.setMemberName(clubDog.getDogOwner());
		order.setAddTime(new Date());
		return order;
	}

	/**
	 * 根据订单号跳转到支付页面
	 * @Author chaixueteng
	 * @2017年10月13日上午11:51:57
	 */
	public List<PaymentOrderDetail> toPayPage(PaymentOrder order) {
		String orderCode = order.getOrderCode();
		List<PaymentOrderDetail> paymentOrderDetailList =paymentOrderDetailDao.getOrderByRunningNum(orderCode, order.getMemberCode());
		return paymentOrderDetailList;
	}

}
