/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.partner.club.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 伴侣级鉴定Entity
 * @author pp
 * @version 2019-07-04
 * test
 */
public class CompanionDogAppraisal extends DataEntity<CompanionDogAppraisal> {

	private static final long serialVersionUID = 1L;
	private String petType;		// 宠物类型 0犬,1猫
	private String petName;		// 宠物姓名
	private String petGender;		// 宠物性别 1公，2母
	private Date petBirthdate;		// 出生日期
	private String petColor;		// 宠物毛色
	private String petSize;		// 宠物体型 1大型，2中型，3小型
	private String petHair;		// 宠物毛发 1长毛，2短毛，3无毛
	private String petOwner;		// 宠物主人
	private String petOwnerMobile;		// 宠主手机号
	private String postalProvince;		// 通讯地址省
	private String postalCity;		// 通讯地址市
	private String postalAddress;		// 详细通讯地址
	private String appraisalProvince;		// 鉴定地址省
	private String appraisalCity;		// 鉴定地址城市
	private String appraisalShop;		// 鉴定地址 宠物店
	private String appraisalResult;		// 鉴定结果 0待鉴定，1鉴定通过，2鉴定未通过
	private String appraisalReason;		// 鉴定未通过 原因
	private String appraisal;		// 鉴定人
	private String appraisalL;		// 鉴定人下拉
	private Date appraisalDate;		// 鉴定时间
	private String identificationFlag;		// 芯片号(身份识别码)
	private String chipType;		// 芯片类型：1埋植芯片，2已有芯片
	private String frontPic;		// 正面照片
	private String sidePic;		// 侧面照片
	private String backPic;		// 背面照片
	private String price;		// 价格
	private String identitySticker;		// 身份贴纸 0未打印，1已打印
	private String gradeSticker;		// 等级贴纸 0未打印 ，1已打印
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态 // 是否缴费，0未交费 ，2已缴费
	private Date paymentTime;		// 付款时间
	private Date identityPrintTime;		// 身份贴纸打印时间
	private Date gradePrintTime;		// 等级贴纸打印时间
private String petColorO;
	private String passportNo; //护照号
	private String cabRegisterCode; //宠爱登记卡号
	private String classCode; //宠爱登记卡号
	private String orgId; //机构序号
	private String operation;//1浏览2编辑

	public String getPetColorO() {
		return petColorO;
	}

	public void setPetColorO(String petColorO) {
		this.petColorO = petColorO;
	}

	public String getClassCode() {
		return classCode;
	}

	public void setClassCode(String classCode) {
		this.classCode = classCode;
	}

	public String getAppraisalL() {
		return appraisalL;
	}

	public void setAppraisalL(String appraisalL) {
		this.appraisalL = appraisalL;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	public Date getIdentityPrintTime() {
        return identityPrintTime;
    }

    public void setIdentityPrintTime(Date identityPrintTime) {
        this.identityPrintTime = identityPrintTime;
    }

    public Date getGradePrintTime() {
        return gradePrintTime;
    }

    public void setGradePrintTime(Date gradePrintTime) {
        this.gradePrintTime = gradePrintTime;
    }

    public String getCabRegisterCode() {
        return cabRegisterCode;
    }

    public void setCabRegisterCode(String cabRegisterCode) {
        this.cabRegisterCode = cabRegisterCode;
    }

    public String getPassportNo() {
		return passportNo;
	}

	public void setPassportNo(String passportNo) {
		this.passportNo = passportNo;
	}

	public String getOperation() {
		return operation;
	}

	public void setOperation(String operation) {
		this.operation = operation;
	}
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public CompanionDogAppraisal() {
		super();
	}

	public CompanionDogAppraisal(String id){
		super(id);
	}

	@Length(min=0, max=2, message="宠物类型 0犬,1猫长度必须介于 0 和 2 之间")
	public String getPetType() {
		return petType;
	}

	public void setPetType(String petType) {
		this.petType = petType;
	}

	@Length(min=0, max=50, message="宠物姓名长度必须介于 0 和 50 之间")
	public String getPetName() {
		return petName;
	}

	public void setPetName(String petName) {
		this.petName = petName;
	}

	@Length(min=0, max=10, message="宠物性别 1公，2母长度必须介于 0 和 10 之间")
	public String getPetGender() {
		return petGender;
	}

	public void setPetGender(String petGender) {
		this.petGender = petGender;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPetBirthdate() {
		return petBirthdate;
	}

	public void setPetBirthdate(Date petBirthdate) {
		this.petBirthdate = petBirthdate;
	}

	@Length(min=0, max=100, message="宠物毛色长度必须介于 0 和 100 之间")
	public String getPetColor() {
		return petColor;
	}

	public void setPetColor(String petColor) {
		this.petColor = petColor;
	}

	@Length(min=0, max=2, message="宠物体型 1大型，2中型，3小型长度必须介于 0 和 2 之间")
	public String getPetSize() {
		return petSize;
	}

	public void setPetSize(String petSize) {
		this.petSize = petSize;
	}

	@Length(min=0, max=2, message="宠物毛发 1长毛，2短毛，3无毛长度必须介于 0 和 2 之间")
	public String getPetHair() {
		return petHair;
	}

	public void setPetHair(String petHair) {
		this.petHair = petHair;
	}

	@Length(min=0, max=50, message="宠物主人长度必须介于 0 和 50 之间")
	public String getPetOwner() {
		return petOwner;
	}

	public void setPetOwner(String petOwner) {
		this.petOwner = petOwner;
	}

	@Length(min=0, max=20, message="宠主手机号长度必须介于 0 和 20 之间")
	public String getPetOwnerMobile() {
		return petOwnerMobile;
	}

	public void setPetOwnerMobile(String petOwnerMobile) {
		this.petOwnerMobile = petOwnerMobile;
	}

	@Length(min=0, max=50, message="通讯地址省长度必须介于 0 和 50 之间")
	public String getPostalProvince() {
		return postalProvince;
	}

	public void setPostalProvince(String postalProvince) {
		this.postalProvince = postalProvince;
	}

	@Length(min=0, max=50, message="通讯地址市长度必须介于 0 和 50 之间")
	public String getPostalCity() {
		return postalCity;
	}

	public void setPostalCity(String postalCity) {
		this.postalCity = postalCity;
	}

	@Length(min=0, max=300, message="详细通讯地址长度必须介于 0 和 300 之间")
	public String getPostalAddress() {
		return postalAddress;
	}

	public void setPostalAddress(String postalAddress) {
		this.postalAddress = postalAddress;
	}

	@Length(min=0, max=50, message="鉴定地址省长度必须介于 0 和 50 之间")
	public String getAppraisalProvince() {
		return appraisalProvince;
	}

	public void setAppraisalProvince(String appraisalProvince) {
		this.appraisalProvince = appraisalProvince;
	}

	@Length(min=0, max=50, message="鉴定地址城市长度必须介于 0 和 50 之间")
	public String getAppraisalCity() {
		return appraisalCity;
	}

	public void setAppraisalCity(String appraisalCity) {
		this.appraisalCity = appraisalCity;
	}

	@Length(min=0, max=20, message="鉴定地址 宠物店长度必须介于 0 和 20 之间")
	public String getAppraisalShop() {
		return appraisalShop;
	}

	public void setAppraisalShop(String appraisalShop) {
		this.appraisalShop = appraisalShop;
	}

	@Length(min=0, max=4, message="鉴定结果 0待鉴定，1鉴定通过，2鉴定未通过长度必须介于 0 和 4 之间")
	public String getAppraisalResult() {
		return appraisalResult;
	}

	public void setAppraisalResult(String appraisalResult) {
		this.appraisalResult = appraisalResult;
	}

	@Length(min=0, max=200, message="鉴定未通过 原因长度必须介于 0 和 200 之间")
	public String getAppraisalReason() {
		return appraisalReason;
	}

	public void setAppraisalReason(String appraisalReason) {
		this.appraisalReason = appraisalReason;
	}

	@Length(min=0, max=50, message="鉴定人长度必须介于 0 和 50 之间")
	public String getAppraisal() {
		return appraisal;
	}

	public void setAppraisal(String appraisal) {
		this.appraisal = appraisal;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAppraisalDate() {
		return appraisalDate;
	}

	public void setAppraisalDate(Date appraisalDate) {
		this.appraisalDate = appraisalDate;
	}

	@Length(min=0, max=64, message="芯片号(身份识别码)长度必须介于 0 和 64 之间")
	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	@Length(min=0, max=2, message="芯片类型：1埋植芯片，2已有芯片长度必须介于 0 和 2 之间")
	public String getChipType() {
		return chipType;
	}

	public void setChipType(String chipType) {
		this.chipType = chipType;
	}

	@Length(min=0, max=64, message="正面照片长度必须介于 0 和 64 之间")
	public String getFrontPic() {
		return frontPic;
	}

	public void setFrontPic(String frontPic) {
		this.frontPic = frontPic;
	}

	@Length(min=0, max=64, message="侧面照片长度必须介于 0 和 64 之间")
	public String getSidePic() {
		return sidePic;
	}

	public void setSidePic(String sidePic) {
		this.sidePic = sidePic;
	}

	@Length(min=0, max=64, message="背面照片长度必须介于 0 和 64 之间")
	public String getBackPic() {
		return backPic;
	}

	public void setBackPic(String backPic) {
		this.backPic = backPic;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min=0, max=1, message="身份贴纸 0未打印，1已打印长度必须介于 0 和 1 之间")
	public String getIdentitySticker() {
		return identitySticker;
	}

	public void setIdentitySticker(String identitySticker) {
		this.identitySticker = identitySticker;
	}

	@Length(min=0, max=1, message="等级贴纸 0未打印 ，1已打印长度必须介于 0 和 1 之间")
	public String getGradeSticker() {
		return gradeSticker;
	}

	public void setGradeSticker(String gradeSticker) {
		this.gradeSticker = gradeSticker;
	}

}