/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.trainschool.dao;

import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 合作学校DAO接口
 *
 * @author 柴雪腾
 * @version 2016-08-08
 */
@MyBatisDao
public interface TrainingInstitutionDao extends CrudDao<TrainingInstitution> {

    /**
     * 美容合作学校
     *
     * @Author chaixueteng
     * @2016年8月15日下午4:21:19
     */
    List<TrainingInstitution> findGroomerList(
            TrainingInstitution trainingInstitution);

    List<TrainingInstitution> getHandlerOrgList(
            TrainingInstitution trainingInstitution);

    //app查询
    List<TrainingInstitution> findGroomerListAPP(
            TrainingInstitution trainingInstitution);

    /**
     * 培训合作学校
     *
     * @Author chaixueteng
     * @2016年8月15日下午4:21:59
     */
    List<TrainingInstitution> findHandlerList(
            TrainingInstitution trainingInstitution);
    //查询学校根据负责人会员
    TrainingInstitution getByMemberCode(String memberCode);
    //查询学校根据会员
    TrainingInstitution getBySchoolMemberCode(String memberCode);

    /**
     * @description: CKU官网查询培训机构接口方法
     * @author: laiguanglong
     * @date: 2017/7/14 10:22
     */
    List<TrainingInstitution> getTrainingInstitution(@Param("schoolType") String schoolType, @Param("province") String province, @Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);
    List<String> getTrainingInstitutionSchoolTypeList(@Param("schoolNameCn") String schoolNameCn,@Param("telephone") String telephone,@Param("address") String address,@Param("province") String province);
    Long getTrainingInstitutionCount(@Param("schoolType") String schoolType, @Param("province") String province);
    /**
     * @description: 批量更新培训机构同名数据的电话和地址字段
     * @author: laiguanglong
     * @date: 2017/7/21 10:15
     */
    void updateBySchoolNameCn(TrainingInstitution trainingInstitution);
    /**
     * @description: 获取美容师学校过期数据
     * @author: laiguanglong
     * @date: 2017/7/14 18:06
     */
    List<String> getExpireGroomerSchoolUserId();

    public void updateIntroduce(TrainingInstitution trainingInstitution);

    TrainingInstitution getQusByMemberCode(@Param("memberCode") String memberCode);

}