package com.cku.oa.tcb.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.tcb.entity.TcbKennel;
import com.cku.oa.tcb.service.TcbKennelService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;

import java.util.Map;

/**
 * 淘宠宝犬舍Controller
 * @author lgl
 * @version 2017-02-21
 */
@Controller
@RequestMapping(value = "${adminPath}/tcb/tcbKennel")
public class TcbKennelController extends BaseController {

	@Autowired
	private TcbKennelService tcbKennelService;

	private final static String REPAGE = "redirect:"+Global.getAdminPath()+"/tcb/tcbKennel/?repage";

	private final static String AUTHORITY_PRDFIX = "tcb:tcbKennel:";
	
	@ModelAttribute
	public TcbKennel get(@RequestParam(required=false) String id) {
		TcbKennel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = tcbKennelService.get(id);
		}
		if (entity == null){
			entity = new TcbKennel();
		}
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(TcbKennel tcbKennel, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<TcbKennel> page = tcbKennelService.findPage(new Page<TcbKennel>(request, response), tcbKennel); 
		model.addAttribute("page", page);
		return "oa/tcb/kennel/tcbKennelList";

	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = "form")
	public String form(TcbKennel tcbKennel, Model model) {
		model.addAttribute("tcbKennel", tcbKennel);
		return "oa/tcb/kennel/tcbKennelForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "editForm")
	public String editForm(TcbKennel tcbKennel, Model model) {
		model.addAttribute("tcbKennel", tcbKennel);
		return "oa/tcb/kennel/tcbKennelEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "addForm")
	public String addForm(TcbKennel tcbKennel, Model model) {
		model.addAttribute("tcbKennel", tcbKennel);
		return "oa/tcb/kennel/tcbKennelEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "setMemberInfo")
	@ResponseBody
	public Map<String,Object> setMemberInfo(String memberCode){
		Map<String,Object> map = null;
		try {
			map = tcbKennelService.setMemberInfo(memberCode);
		} catch (Exception e) {
			logger.warn("查询会员信息出错",e);
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "add")
	public String save(TcbKennel tcbKennel, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, tcbKennel)){
			return form(tcbKennel, model);
		}
		try {
			tcbKennelService.add(tcbKennel);
			addMessage(redirectAttributes, "保存淘宠宝犬舍成功");
		}catch (Exception e){
			logger.warn("保存淘宠宝犬舍失败",e);
			addMessage(redirectAttributes, "保存淘宠宝犬舍失败:"+e.getMessage());
		}
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "edit")
	public String edit(TcbKennel tcbKennel, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, tcbKennel)){
			return form(tcbKennel, model);
		}
		tcbKennelService.save(tcbKennel);
		addMessage(redirectAttributes, "保存淘宠宝犬舍成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"delete")
	@RequestMapping(value = "delete")
	public String delete(TcbKennel tcbKennel, RedirectAttributes redirectAttributes) {
		tcbKennelService.delete(tcbKennel);
		addMessage(redirectAttributes, "删除淘宠宝犬舍成功");
		return REPAGE;
	}

}