package com.cku.oa.sys.web;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBreedCertifiedService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogOwnerChangeService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogPedigreeCertifiedRedoService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.handler.service.HandlerDiplomaService;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.handler.service.HandlerRegisterService;
import com.cku.oa.kennel.dao.KennelRenameDao;
import com.cku.oa.kennel.service.KennelOwnerChangeService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.thinkgem.jeesite.modules.oa.entity.OaNotify;
import com.thinkgem.jeesite.modules.oa.service.OaNotifyService;

@Controller
@RequestMapping(value = "${adminPath}/welcome")
public class WelcomeController {
	@Autowired
	private OaNotifyService oaNotifyService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private ChampionLoginService championLoginService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private DogAppraisalService dogAppraisalService;
	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;
	@Autowired
	private DogBreedCertifiedService dogBreedCertifiedService;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private DogOwnerChangeService dogOwnerChangeService;
	@Autowired
	private GroomerRegisterService groomerRegisterService;
	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	private HandlerQualificationCertificateService handlerQualificationCertificateService;
	@Autowired
	private HandlerDiplomaService handlerDiplomaService;
	@Autowired
	private HandlerRegisterService handlerRegisterService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private KennelOwnerChangeService kennelOwnerChangeService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private KennelRenameDao kennelRenameDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentOrderService paymentOrderService;

	private static ExecutorService executor = Executors.newFixedThreadPool(15);

	/**
	 * 通用首页
	 */
	@RequestMapping(value = "/default")
	public String defaultWelcome(Model model) {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		List<OaNotify> notifys = oaNotifyService.findList(notify);
		model.addAttribute("oaNotifys", notifys);
		return "oa/welcome/defaultWelcome";
	}

	/**
	 * 犬籍管理首页
	 * 
	 * @throws ExecutionException
	 * @throws InterruptedException
	 */
	@RequestMapping(value = "/dog")
	public String dogWelcome(Model model) throws Exception {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		Future<?> future1 = executor.submit(() -> {
			return oaNotifyService.findList(notify);
		});
		Future<?> future2 = executor.submit(() -> {
			return dogNewbornService.getAuditCount();
		});
		Future<?> future3 = executor.submit(() -> {
			return dogBirthCertificateService.getAuditCount();
		});
		Future<?> future4 = executor.submit(() -> {
			return dogDnaArchiveService.getAuditCount();
		});
		Future<?> future5 = executor.submit(() -> {
			return dogChipService.getAuditCount();
		});
		Future<?> future6 = executor.submit(() -> {
			return dogPedigreeCertifiedRedoService.getAuditCount();
		});
		Future<?> future7 = executor.submit(() -> {
			return dogAppraisalService.getAuditCount();
		});
		Future<?> future8 = executor.submit(() -> {
			return dogPedigreeCertifiedExportService.getAuditCount();
		});
		Future<?> future9 = executor.submit(() -> {
			return dogBreedCertifiedService.getAuditCount();
		});
		Future<?> future10 = executor.submit(() -> {
			return dogPedigreeCertifiedChangeService.getAuditCount();
		});
		Future<?> future11 = executor.submit(() -> {
			return dogOwnerChangeService.getAuditCount();
		});
		Future<?> future12 = executor.submit(() -> {
			return dogDao.getdogPictureReviewStateCount();
		});
		model.addAttribute("oaNotifys", future1.get());
		model.addAttribute("dogNewbornCount", future2.get());
		model.addAttribute("dogBirthCertificateCount", future3.get());
		model.addAttribute("dogDnaArchiveCount", future4.get());
		model.addAttribute("dogChipCount", future5.get());
		model.addAttribute("dogPedigreeCertifiedRedoCount", future6.get());
		model.addAttribute("dogAppraisalCount", future7.get());
		model.addAttribute("dogPedigreeCertifiedExportCount", future8.get());
		model.addAttribute("dogBreedCertifiedCount", future9.get());
		model.addAttribute("dogPedigreeCertifiedChangeCount", future10.get());
		model.addAttribute("dogOwnerChangeCount", future11.get());
		model.addAttribute("dogPictureReviewStateCount", future12.get());
		return "oa/welcome/dogWelcome";
	}

	/**
	 * 
	 * @Description：藏獒欢迎页
	 * @author: zhuoHeng
	 * @version: 2016年9月3日 下午7:32:13
	 */
	@RequestMapping(value = "/tibetanMastiff")
	public String tibetanMastiffWelcome(Model model) throws Exception {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		Future<?> future1 = executor.submit(() -> {
			return oaNotifyService.findList(notify);
		});
		Future<?> future2 = executor.submit(() -> {
			return dogNewbornService.getAuditCount("230");
		});
		Future<?> future3 = executor.submit(() -> {
			return dogBirthCertificateService.getAuditCount();
		});
		Future<?> future4 = executor.submit(() -> {
			return dogDnaArchiveService.getAuditCount();
		});
		Future<?> future5 = executor.submit(() -> {
			return dogChipService.getAuditCount();
		});
		Future<?> future6 = executor.submit(() -> {
			return dogPedigreeCertifiedRedoService.getAuditCount();
		});
		Future<?> future7 = executor.submit(() -> {
			return dogAppraisalService.getAuditCount();
		});
		Future<?> future8 = executor.submit(() -> {
			return dogPedigreeCertifiedExportService.getAuditCount();
		});
		Future<?> future9 = executor.submit(() -> {
			return dogBreedCertifiedService.getAuditCount();
		});
		Future<?> future10 = executor.submit(() -> {
			return dogPedigreeCertifiedChangeService.getAuditCount();
		});
		Future<?> future11 = executor.submit(() -> {
			return dogOwnerChangeService.getAuditCount();
		});
		model.addAttribute("oaNotifys", future1.get());
		model.addAttribute("dogNewbornCount", future2.get());
		model.addAttribute("dogBirthCertificateCount", future3.get());
		model.addAttribute("dogDnaArchiveCount", future4.get());
		model.addAttribute("dogChipCount", future5.get());
		model.addAttribute("dogPedigreeCertifiedRedoCount", future6.get());
		model.addAttribute("dogAppraisalCount", future7.get());
		model.addAttribute("dogPedigreeCertifiedExportCount", future8.get());
		model.addAttribute("dogBreedCertifiedCount", future9.get());
		model.addAttribute("dogPedigreeCertifiedChangeCount", future10.get());
		model.addAttribute("dogOwnerChangeCount", future11.get());
		return "oa/welcome/tibetanMastiffWelcome";
	}

	/**
	 * 培训首页
	 */
	@RequestMapping(value = "/handler")
	public String handlerWelcome(Model model) throws Exception {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		Future<?> future1 = executor.submit(() -> {
			return oaNotifyService.findList(notify);
		});
		Future<?> future2 = executor.submit(() -> {
			return handlerDiplomaService.getHandlerDiplomaCount();
		});
		Future<?> future3 = executor.submit(() -> {
			return handlerDiplomaService.getTrainDiplomaCount();
		});
		Future<?> future4 = executor.submit(() -> {
			return handlerRegisterService.getRegisterCount();
		});
		Future<?> future5 = executor.submit(() -> {
			return handlerQualificationCertificateService.getHandlerQualificationCount();
		});
		model.addAttribute("oaNotifys", future1.get());
		model.addAttribute("handlerDiplomaCount", future2.get());
		model.addAttribute("trainDiplomaCount", future3.get());
		model.addAttribute("registerCount", future4.get());
		model.addAttribute("handlerQualificationCount", future5.get());
		return "oa/welcome/handlerWelcome";
	}

	/**
	 * 美容首页
	 * 
	 * @throws @throws
	 */
	@RequestMapping(value = "/groomer")
	public String groomerWelcome(Model model) throws Exception {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		Future<?> future1 = executor.submit(() -> {
			return oaNotifyService.findList(notify);
		});
		Future<?> future2 = executor.submit(() -> {
			// 资格证书申请
			return groomerQualificationCertificateService.getAuditCount();
		});
		Future<?> future3 = executor.submit(() -> {
			// 结业证书申请
			return groomerDiplomaService.getAuditCount();
		});
		Future<?> future4 = executor.submit(() -> {
			// 考试报名
			return groomerRegisterService.getAuditCount();
		});
		Future<?> future5 = executor.submit(() -> {
			// 比赛报名
			return groomerRegisterService.getMatchAuditCount();
		});
		model.addAttribute("oaNotifys", future1.get());
		model.addAttribute("groomerQualificationCertificateCount", future2.get());
		model.addAttribute("groomerDiplomaCount", future3.get());
		model.addAttribute("groomerRegisterCount", future4.get());
		model.addAttribute("MatchAuditCount", future5.get());
		return "oa/welcome/groomerWelcome";
	}

	/**
	 * 赛事首页
	 */
	@RequestMapping(value="/show")
	public String showWelcome(Model model){
		OaNotify notify = new OaNotify();
		notify.setType("0");//类型
		notify.setStatus("1");//发布状态
		List<OaNotify> notifys = oaNotifyService.findList(notify);
		model.addAttribute("oaNotifys", notifys);
		model.addAttribute("beginCreateDate", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
		model.addAttribute("showApplyCountToday", showApplyService.getShowApplyCountToday());
		model.addAttribute("championLoginCount", championLoginService.getAuditCount());
		model.addAttribute("showRefundCount" , paymentOrderService.getShowRefundCount());
		return "oa/welcome/showWelcome";
	}	

	/**
	 * 会员中心首页
	 * 
	 * @return
	 */
	@RequestMapping(value = "/member")
	public String memberWelcome(Model model) throws Exception {
		OaNotify notify = new OaNotify();
		notify.setType("0");// 类型
		notify.setStatus("1");// 发布状态
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Calendar c = Calendar.getInstance();
		c.add(Calendar.MONTH, 0);
		c.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
		Date beginTime = c.getTime();
		// 获取当前月最后一天
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
		Date endTime = ca.getTime();
		String beginDate = sdf.format(beginTime);
		String endDate = sdf.format(endTime);
		model.addAttribute("beginDate", beginDate);
		model.addAttribute("endDate", endDate);

		Future<?> future1 = executor.submit(() -> {
			return oaNotifyService.findList(notify);
		});
		Future<?> future2 = executor.submit(() -> {
			return kennelOwnerChangeService.getOwnerChangeCount();
		});
		Future<?> future3 = executor.submit(() -> {
			return paymentOrderDetailDao.findByMemberCardCount(MemberCardTypeEnum.SILVER_CARD.code());
		});
		Future<?> future4 = executor.submit(() -> {
			return paymentOrderDetailDao.findByMemberCardCount(MemberCardTypeEnum.GOLDEN_CARD.code());
		});
		Future<?> future5 = executor.submit(() -> {
			return kennelService.getKennelCount();
		});
		Future<?> future6 = executor.submit(() -> {
			return kennelService.getProfessionalCount();
		});
		Future<?> future7 = executor.submit(() -> {
			return kennelRenameDao.findByKennelReviewCount();
		});
		model.addAttribute("oaNotifys", future1.get());
		model.addAttribute("ownerChangerCount", future2.get());
		// 银卡会员
		model.addAttribute("basicCount", future3.get());
		// 金卡会员
		model.addAttribute("professionalMemberCount", future4.get());
		// 铂金会员
		model.addAttribute("kennelCount", future5.get());
		// 紫金会员
		model.addAttribute("professionalCount", future6.get());
		// 犬舍名称变更提醒
		model.addAttribute("kennelReNameCount", future7.get());
		return "oa/welcome/memberWelcome";
	}

	/**
	 *
	 * @description: 获得当天最小时间
	 * @author: Jeff
	 * @date: 2019年12月21日
	 * @param date
	 * @return
	 */
	public static String getStartOfDay(Date date) {
		LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()),
				ZoneId.systemDefault());
		LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date from = Date.from(startOfDay.atZone(ZoneId.systemDefault()).toInstant());
		return simpleDateFormat.format(from);
	}

	/**
	 *
	 * @description: 获得当天最大时间
	 * @author: Jeff
	 * @date: 2019年12月21日
	 * @param date
	 * @return
	 */
	public static String getEndOfDay(Date date) {
		LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()),
				ZoneId.systemDefault());
		LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Date from = Date.from(endOfDay.atZone(ZoneId.systemDefault()).toInstant());
		return simpleDateFormat.format(from);
	}
}
