package com.cku.oa.sys.coupon.web;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 优惠劵Controller
 * 
 * @author 柴雪腾
 * @version 2018-04-12
 */
@Controller
@RequestMapping(value = "${adminPath}/coupon/sysCoupon")
public class SysCouponController extends BaseController {

	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private MemberService memberService;

	@ModelAttribute
	public SysCoupon get(@RequestParam(required = false) String id) {
		SysCoupon entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = sysCouponService.get(id);
		}
		if (entity == null) {
			entity = new SysCoupon();
		}
		return entity;
	}

	@RequiresPermissions("coupon:sysCoupon:view")
	@RequestMapping(value = { "list", "" })
	public String list(SysCoupon sysCoupon, HttpServletRequest request, HttpServletResponse response, Model model) {
		sysCoupon.setOrderByStr("admin");
		Page<SysCoupon> page = sysCouponService.findPage(new Page<SysCoupon>(request, response), sysCoupon);
		for (SysCoupon coupon : page.getList()) {
			if ("1".equals(coupon.getCouponType())) {
				coupon.setCouponTypeDesc("代金券");
			}
			if ("2".equals(coupon.getCouponType())) {
				coupon.setCouponTypeDesc("抵扣券");
			}
			if ("3".equals(coupon.getCouponType())) {
				coupon.setCouponTypeDesc("参展券");
			}
			if ("4".equals(coupon.getCouponType())) {
				coupon.setCouponTypeDesc("满减券");
			}
			
			if (coupon.getUseState().equals("1")) {
				coupon.setState("已使用");
			} else {
				if (coupon.getValidDate() != null
						&& DateUtils.isAfterMounth(new Date(), coupon.getValidDate(), Boolean.FALSE)) {
					coupon.setState("已过期");
				} else {
					coupon.setState("可用");
				}
			}
			coupon.setCouponDelFlag(StringUtils.isEmpty(coupon.getUserCouponComposeId()));
		}
		model.addAttribute("page", page);
		return "oa/sys/coupon/sysCouponList";
	}

	@RequiresPermissions("coupon:sysCoupon:view")
	@RequestMapping(value = "form")
	public String form(SysCoupon sysCoupon, Model model) {
		model.addAttribute("sysCoupon", sysCoupon);
		return "oa/sys/coupon/sysCouponForm";
	}

	@RequiresPermissions("coupon:sysCoupon:edit")
	@RequestMapping(value = "save")
	public String save(SysCoupon sysCoupon, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysCoupon)) {
			return form(sysCoupon, model);
		}
		sysCouponService.save(sysCoupon);
		addMessage(redirectAttributes, "保存优惠劵成功");
		return "redirect:" + Global.getAdminPath() + "/coupon/sysCoupon/?repage";
	}

	@RequiresPermissions("coupon:sysCoupon:edit")
	@RequestMapping(value = "delete")
	public String delete(SysCoupon sysCoupon, RedirectAttributes redirectAttributes) {
		sysCouponService.delete(sysCoupon);
		addMessage(redirectAttributes, "删除优惠劵成功");
		return "redirect:" + Global.getAdminPath() + "/coupon/sysCoupon/?repage";
	}

	/**
	 * 打开增加优惠券页面
	 * 
	 */
	@RequestMapping(value = { "addSysCouponView" })
	public String addSysCouponView(SysCoupon sysCoupon, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("sysCoupon", sysCoupon);
		return "oa/sys/coupon/addSysCouponView";
	}

	@RequestMapping(value = "addSysCoupon")
	@RequiresPermissions("coupon:sysCoupon:add")
	@ResponseBody
	public Object addSysCoupon(SysCoupon sysCoupon) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		if (sysCoupon.getEffectiveDate().after(sysCoupon.getValidDate())) { // 生效日期 //有效期
			map.put("rc", "1");
			map.put("msg", "截止日期需大于等于开始日期!");
			return map;
		}
		Member member = memberService.getByMemberCode(sysCoupon.getMemberCode());
		if (member == null) {
			map.put("rc", "1");
			map.put("msg", "会员号有误！");
			return map;
		}
		try {
			sysCouponService.saveNum(sysCoupon);
		} catch (Exception e) {
			logger.warn("保存失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequestMapping(value = "getMemberName")
	@ResponseBody
	public Object getMemberName(HttpServletRequest request) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			String code = request.getParameter("code");
			if (StringUtils.isBlank(code)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号必传");
			}
			Member member = memberService.getByMemberCode(code);
			if (member == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
			}
			map.put("data", member.getName());
		} catch (Exception e) {
			logger.warn("查询失败", e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	
	
	/**
	 *导入
	 */
	//@RequiresPermissions("coupon:sysCoupon:add")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			sysCouponService.importCoupon(file);
			addMessage(redirectAttributes, "导入优惠券信息成功！");
		} catch (Exception e) {
			redirectAttributes.addFlashAttribute("importError", "导入优惠券信息失败！失败信息：##" + e.getMessage());
		}
		//return "redirect:" + Global.getAdminPath() + "/sys/user/member/?repage";
		return "redirect:" + Global.getAdminPath() + "/coupon/sysCoupon/?repage";

	}
	
	
	/**
	 * 下载模版
	 */
	@RequiresPermissions("coupon:sysCoupon:add")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			return sysCouponService.importFileTemplate(response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/coupon/sysCoupon/?repage";
	}
}