package com.cku.oa.showRefereeDelegate.comparator;


import com.cku.oa.showRefereeDelegate.entity.Referee;

import java.util.Comparator;

/**
 * @author yuanshuai
 * @date 2021/2/4 15:56
 */
public class RefereeLevelOneComparator implements Comparator<Referee> {
	@Override
	public int compare(Referee o1, Referee o2) {
		//优先判断是否已经委派完毕
		int o1Diff = o1.getJoinCount() - o1.getDelegateCount();
		int o2Diff = o2.getJoinCount() - o2.getDelegateCount();
		if (o1Diff != 0 && o2Diff == 0) {
			return -1;
		} else if (o1Diff == 0 && o2Diff != 0) {
			return 1;
		}
		//1.权重
		int compare = Integer.compare(o2.getWeight(), o1.getWeight());
		//2.随机值
		if (compare == 0) {
			compare = Integer.compare(o2.getSort(), o1.getSort());
		}
		//3.级别
		if (compare == 0) {
			compare = Integer.compare(o1.getLevel().getCode(), o2.getLevel().getCode());
		}
		//4.待分配场次
		if (compare == 0) {
			compare = Integer.compare(o2Diff, o1Diff);

		}
		return compare;
	}
}
