package com.cku.oa.order.service.impl;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.common.PaymentItemIdConstants;
import com.cku.oa.common.SKUIDConstants;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerQualificationCertificateChange;
import com.cku.oa.groomer.enums.QualificationCertificateLevelEnum;
import com.cku.oa.groomer.enums.QualificationCertificateSourceEnum;
import com.cku.oa.groomer.service.GroomerQualificationCertificateChangeService;
import com.cku.oa.order.service.BaseSkuBusinessService;
import com.cku.oa.order.service.IOrderBusinessService;
import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.oa.order.vo.SingleIdOrderBusinessVo;
import com.cku.oa.order.vo.request.SingleIdRequest;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 美容资格证书换发处理类
 *
 * @author yuanshuai
 * @date 2024年1月23日15:46:10
 */
@Service
public class GroomerQCChangeOrderServiceImpl extends BaseSkuBusinessService<SingleIdOrderBusinessVo> implements IOrderBusinessService<SingleIdRequest> {

	@Autowired
	private GroomerQualificationCertificateChangeService groomerQualificationCertificateChangeService;

	@Override
	public void businessValidate(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		if (StringUtils.isBlank(businessRequest.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		GroomerQualificationCertificateChange gQCChange = groomerQualificationCertificateChangeService.get(businessRequest.getId());
		if (Objects.isNull(gQCChange)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到换发信息");
		}
		if (!"1".equals(gQCChange.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该换发信息已经缴费");
		}
	}

	@Override
	public List<OrderSkuVo> preOrder(OrderApplyRequest orderRequest, SingleIdRequest businessRequest, Member member) {
		GroomerQualificationCertificateChange gQCChange = groomerQualificationCertificateChangeService.get(businessRequest.getId());
		String skuId;
		if (QualificationCertificateSourceEnum.FCI.code().equals(gQCChange.getCertificateSource())) {
			if (QualificationCertificateLevelEnum.C.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_FCI_C;
			} else if (QualificationCertificateLevelEnum.B.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_FCI_B;
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该级别暂时无法换发CKU美容师资格证书");
			}
		} else if (QualificationCertificateSourceEnum.HK.code().equals(gQCChange.getCertificateSource())) {
			if (QualificationCertificateLevelEnum.MASTER.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_HK_M_TO_B;
			} else if (QualificationCertificateLevelEnum.A.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_HK_A_TO_B;
			} else if (QualificationCertificateLevelEnum.B.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_HK_B_TO_B;
			} else if (QualificationCertificateLevelEnum.C.code().equals(gQCChange.getCertificateLevel())) {
				skuId = SKUIDConstants.GROOMER_QC_CHANG_HK_C_TO_C;
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该级别暂时无法换发CKU美容师资格证书");
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该级别暂时无法换发CKU美容师资格证书");
		}
		//sku列表
		List<OrderSkuVo> skuVoList = Lists.newArrayList();
		//添加证书费SKU
		skuVoList.add(OrderSkuVo.builder()
				.skuId(skuId)
				.num(1)
				.businessList(Stream.of(SingleIdOrderBusinessVo.builder()
								.id(businessRequest.getId())
								.build())
						.collect(Collectors.toList()))
				.build());
		return skuVoList;
	}

	@Override
	public void processBusinessPrePay(OrderApplyRequest orderRequest, SingleIdOrderBusinessVo businessData, OrderSkuVo skuVo) {
		//无需处理
	}

	@Override
	@Transactional(readOnly = false)
	public void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList) {
		//获取业务信息
		SingleIdOrderBusinessVo businessData = (SingleIdOrderBusinessVo) skuVo.getBusinessList().get(0);
		GroomerQualificationCertificateChange gQCChange = groomerQualificationCertificateChangeService.get(businessData.getId());
		itemList.forEach(item -> item.setBusinessIds(gQCChange.getId()));
	}
}
