package com.cku.oa.handler.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.dao.HandlerScoreRankingDao;
import com.cku.oa.handler.entity.HandlerScoreRanking;
import com.cku.oa.handler.model.CkuHandlerScoreRankingGroupVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingHeadVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingListVO;
import com.cku.oa.handler.model.CkuHandlerScoreRankingVO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import edu.emory.mathcs.backport.java.util.Collections;

/**
 * 牵犬师积分榜Service
 * 
 * @author xx
 * @version 2022-06-06
 */
@Service
@Transactional(readOnly = true)
public class HandlerScoreRankingService extends CrudService<HandlerScoreRankingDao, HandlerScoreRanking> {

	@Autowired
	public MemberDao memberDao;

	public HandlerScoreRanking get(String id) {
		return super.get(id);
	}

	public List<HandlerScoreRanking> findList(HandlerScoreRanking handlerScoreRanking) {
		return super.findList(handlerScoreRanking);
	}

	public Page<HandlerScoreRanking> findPage(Page<HandlerScoreRanking> page, HandlerScoreRanking handlerScoreRanking) {
		return super.findPage(page, handlerScoreRanking);
	}

	@Transactional(readOnly = false)
	public void save(HandlerScoreRanking handlerScoreRanking) {
		super.save(handlerScoreRanking);
	}

	@Transactional(readOnly = false)
	public void delete(HandlerScoreRanking handlerScoreRanking) {
		dao.deleteGroup(handlerScoreRanking);
	}

	@Transactional(readOnly = false)
	public void upload(HandlerScoreRanking handlerScoreRanking) throws Exception {
		//逻辑删除原来的
		delete(handlerScoreRanking);
		// 解析文件
		ImportExcel ei = new ImportExcel(handlerScoreRanking.getFj(), 0, 0);
		List<HandlerScoreRanking> list = ei.getDataList(HandlerScoreRanking.class);
		int i = 2;
		for (HandlerScoreRanking r : list) {
			if (StringUtils.isBlank(r.getMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "第" + i + "行，会员号不能为空");
			}
			if (r.getRanking() == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "第" + i + "行，排名不能为空");
			}
			if (r.getScore() == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "第" + i + "行，积分不能为空");
			}
			Member member = memberDao.getByMemberCode(r.getMemberCode());
			if (member == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "第" + i + "行，会员号错误");
			}
			if ("Y".equals(handlerScoreRanking.getTableType())) {
				handlerScoreRanking.setMonth(null);
				handlerScoreRanking.setQuarter(null);
			} else if ("Q".equals(handlerScoreRanking.getTableType())) {
				handlerScoreRanking.setMonth(null);
			} else if ("M".equals(handlerScoreRanking.getTableType())) {
				handlerScoreRanking.setQuarter(null);
			}
			r.setMemberCode(r.getMemberCode());
			r.setName(member.getName());
			r.setRanking(r.getRanking());
			r.setScore(r.getScore());
			r.setTableType(handlerScoreRanking.getTableType());
			r.setYear(handlerScoreRanking.getYear());
			r.setMonth(handlerScoreRanking.getMonth());
			r.setQuarter(handlerScoreRanking.getQuarter());
			save(r);
			i++;
		}

	}


	public Page<HandlerScoreRanking> findGroupedList(Page<HandlerScoreRanking> page,
			HandlerScoreRanking handlerScoreRanking) {
		int pageNo = page.getPageNo();
		int pageSize = page.getPageSize();
		handlerScoreRanking.setPage(page);
		page.setList(dao.findGroupedList(handlerScoreRanking));
		if ((pageNo - 1) * pageSize >= page.getCount()) {
			page.setList(new ArrayList<HandlerScoreRanking>(0));
		}
		return page;
	}

	public void export(HandlerScoreRanking handlerScoreRanking, HttpServletResponse response) throws IOException {
		handlerScoreRanking.getPage().setOrderBy("ranking");
		List<HandlerScoreRanking> list = findList(handlerScoreRanking);

		StringBuilder excelName = new StringBuilder("");
		excelName.append(handlerScoreRanking.getYear());
		excelName.append("年");
		if (handlerScoreRanking.getMonth() != null) {
			excelName.append(handlerScoreRanking.getMonth());
			excelName.append("月");
		}
		if (handlerScoreRanking.getQuarter() != null) {
			excelName.append("第");
			excelName.append(handlerScoreRanking.getQuarter());
			excelName.append("季度");
		}
		excelName.append(DictUtils.getDictLabels(handlerScoreRanking.getTableType(), "table_type", ""));
		excelName.append(".xlsx");

		new ExportExcel("", HandlerScoreRanking.class, 1).setDataList(list).write(response, excelName.toString())
				.dispose();
	}

	@Transactional(readOnly = false)
	public ListResultDto<CkuHandlerScoreRankingGroupVO> getHandlerScoreRankingAbstract(String year, String tableType,
			Integer limit) {
		List<CkuHandlerScoreRankingGroupVO> listResult = new ArrayList<>();
		HandlerScoreRanking handlerScoreRanking = new HandlerScoreRanking();
		handlerScoreRanking.setYear(Integer.valueOf(year));
		handlerScoreRanking.setTableType(tableType);
		handlerScoreRanking.getPage().setOrderBy("quarter,month,ranking");
		List<HandlerScoreRanking> list = dao.findFrontList(handlerScoreRanking);
		if ("Y".equals(tableType)) {
			if (list.size() > 0) {
				// 都放第一组
				listResult.add(CkuHandlerScoreRankingGroupVO.builder().list(transformList(list)).tableType(tableType)
						.year(year).build());
			}
		} else if ("Q".equals(tableType)) {
			// 按季度分组
			Map<Integer, List<HandlerScoreRanking>> map = list.stream()
					.collect(Collectors.groupingBy(HandlerScoreRanking::getQuarter));
			for (Integer key : map.keySet()) {
				CkuHandlerScoreRankingGroupVO vo = CkuHandlerScoreRankingGroupVO.builder().tableType(tableType)
						.year(year).num(key).build();
				List<HandlerScoreRanking> groupList = map.get(key).stream()
						.sorted(Comparator.comparing(HandlerScoreRanking::getRanking)).limit(limit != null ? limit : 3)
						.collect(Collectors.toList());
				groupList.stream().forEach(a -> {
					a.setIntroduce(null);
				});
				vo.setList(transformList(groupList));
				listResult.add(vo);
			}
		} else if ("M".equals(tableType)) {
			// 按月分组
			Map<Integer, List<HandlerScoreRanking>> map = list.stream()
					.collect(Collectors.groupingBy(HandlerScoreRanking::getMonth));
			for (Integer key : map.keySet()) {
				CkuHandlerScoreRankingGroupVO vo = CkuHandlerScoreRankingGroupVO.builder().tableType(tableType)
						.year(year).num(key).build();
				List<HandlerScoreRanking> groupList = map.get(key).stream()
						.sorted(Comparator.comparing(HandlerScoreRanking::getRanking)).limit(limit != null ? limit : 3)
						.collect(Collectors.toList());
				groupList.stream().forEach(a -> {
					a.setIntroduce(null);
				});
				vo.setList(transformList(groupList));
				listResult.add(vo);
			}
		}
		listResult = listResult.stream()
				.sorted(Comparator.comparing(CkuHandlerScoreRankingGroupVO::getNum, Comparator.reverseOrder()))
				.collect(Collectors.toList());
		;
		return ListResultDto.success(listResult);

	}

	private List<CkuHandlerScoreRankingVO> transformList(List<HandlerScoreRanking> list) {
		List<CkuHandlerScoreRankingVO> listResult = new ArrayList<>();
		list.stream().forEach(a -> {
			CkuHandlerScoreRankingVO vo = CkuHandlerScoreRankingVO.builder().build();
			BeanUtils.copyProperties(a, vo);
			listResult.add(vo);
		});
		return listResult;
	}

	public ResultDto<CkuHandlerScoreRankingHeadVO> getHandlerScoreRankingHead(String year) {
		List<Integer> quarter = new ArrayList<>();
		List<Integer> month = new ArrayList<>();
		List<HandlerScoreRanking> list = dao.getHandlerScoreRankingHead(year);
		list.stream().forEach(a -> {
			if ("Q".equals(a.getTableType())) {
				quarter.add(a.getQuarter());
			} else if ("M".equals(a.getTableType())) {
				month.add(a.getMonth());
			}
		});
		Collections.reverse(quarter);// 倒叙排列
		Collections.reverse(month);
		return ResultDto.success(CkuHandlerScoreRankingHeadVO.builder().month(month).quarter(quarter).build());

	}

	public ResultDto<CkuHandlerScoreRankingListVO> getHandlerScoreRanking(Integer year, String tableType, Integer num) {
		HandlerScoreRanking entity = new HandlerScoreRanking();
		entity.setYear(year);
		entity.setTableType(tableType);
		if ("Q".equals(tableType)) {
			entity.setQuarter(num);
		} else if ("M".equals(tableType)) {
			entity.setMonth(num);
		}
		entity.getPage().setOrderBy("ranking");
		List<HandlerScoreRanking> list = dao.findFrontSimpleList(entity);
		Date updateDate = null;
		if (list.size() > 0) {
			updateDate = list.stream().max(Comparator.comparing(HandlerScoreRanking::getUpdateDate)).get()
					.getUpdateDate();
		}

		return ResultDto.success(
				CkuHandlerScoreRankingListVO.builder().list(transformList(list)).updateDate(updateDate).build());

	}

	public ResultDto<CkuHandlerScoreRankingVO> getHandlerScoreRankingDetail(String id) {
		HandlerScoreRanking entity = dao.get(id);
		if (entity == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不正确！");
		}
		CkuHandlerScoreRankingVO vo = CkuHandlerScoreRankingVO.builder().build();
		BeanUtils.copyProperties(entity, vo);
		return ResultDto.success(vo);

	}

}