/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 国外美容考试结果Entity
 * 
 * @author Sunny
 * @version 2024-01-11
 */
public class GroomerForeignRegister extends DataEntity<GroomerForeignRegister> {

	private static final long serialVersionUID = 1L;

	@ExcelField(title = "Certificate No", sort = 7)
	private String certifiedNo; // 证书号

	@ExcelField(title = "No", sort = 1)
	private String registerNo; // 编号

	@ExcelField(title = "Name", sort = 2)
	private String name; // 名称

	@ExcelField(title = "Breed", sort = 3)
	private String breed; // 犬种

	@ExcelField(title = "Result", sort = 4)
	private String result; // 结果

	@ExcelField(title = "Level", sort = 5)
	private String level; // 级别

	@ExcelField(title = "Category", sort = 6)
	private String category; // 分类

	@ExcelField(title = "国家", sort = 8)
	private String country; // 国家

	@ExcelField(title = "月份", sort = 9)
	private Date specificDate; // 月份

	private String specificDateStr; // 月份

	public GroomerForeignRegister() {
		super();
	}

	public GroomerForeignRegister(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "证书号长度必须介于 0 和 64 之间")
	public String getCertifiedNo() {
		return certifiedNo;
	}

	public void setCertifiedNo(String certifiedNo) {
		this.certifiedNo = certifiedNo;
	}

	@Length(min = 0, max = 64, message = "编号长度必须介于 0 和 64 之间")
	public String getRegisterNo() {
		return registerNo;
	}

	public void setRegisterNo(String registerNo) {
		this.registerNo = registerNo;
	}

	@Length(min = 0, max = 64, message = "名称长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Length(min = 0, max = 64, message = "犬种长度必须介于 0 和 64 之间")
	public String getBreed() {
		return breed;
	}

	public void setBreed(String breed) {
		this.breed = breed;
	}

	@Length(min = 0, max = 64, message = "结果长度必须介于 0 和 64 之间")
	public String getResult() {
		return result;
	}

	public void setResult(String result) {
		this.result = result;
	}

	@Length(min = 0, max = 64, message = "级别长度必须介于 0 和 64 之间")
	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	@Length(min = 0, max = 64, message = "分类长度必须介于 0 和 64 之间")
	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	@Length(min = 0, max = 64, message = "国家长度必须介于 0 和 64 之间")
	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSpecificDate() {
		return specificDate;
	}

	public void setSpecificDate(Date specificDate) {
		this.specificDate = specificDate;
	}

	public String getSpecificDateStr() {
		return specificDateStr;
	}

	public void setSpecificDateStr(String specificDateStr) {
		this.specificDateStr = specificDateStr;
	}

}