/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.dao;

import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import com.cku.oa.goods.entity.Sku;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 商品DAO接口
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@MyBatisDao
public interface SkuDao extends CrudDao<Sku> {

	List<Sku> findListByIdList(@Param("idList") List<String> idList);

	/**
	 * 根据业务服务查询商品列表
	 *
	 * @author yuanshuai
	 * @date 2023/7/28 16:44
	 */
	List<Sku> findListByBusiness(@Param("businessId") String businessId);
}