/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.sampling.entity.Sampling;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只DNA存档Entity
 *
 * @author lgl
 * @version 2016-08-08
 */
public class DogDnaArchive extends DataEntity<DogDnaArchive> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只信息表主键
	private String pedigreeCertified; // 血统证书号
	private String overseasPedigreeCertified; // 国外血统证书号
	private String dnaCode; // DNA样本登记号码
	private String birthCode; // 出生纸编号
	private String samplingCode; // 采样包编号
	private String geneticDiseaseJson; // 遗传疾病json
	private String paymentMemberCode; // 付款会员号
	private String operator; // 操作人
	private String price; // 价格
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核的意见
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private Date finishTime; // 完成时间
	private Date processTime; // 流程变更的时间
	private String processState; // 流程状态
	private Date beginCreateDate; // 开始 create_date
	private Date endCreateDate; // 结束 create_date
	private String memberName;// 会员姓名
	private String dogName;// 犬名
	private Date dogBirthday;// 犬出生日期
	private String dogGender;// 犬性别
	private String printState; // 打印状态
	private String dogBreed; // 犬种类代码
	private String breedCnName; // 犬种类中文名称
	private String chipCode; // 芯片号
	private String dogColorFlag; // 毛色编号
	private String dogColorName; // 毛色中文名
	private String paymentChargingItemId; // 收费项id
	private String orderDetailId; // 订单明细id
	private String pedigreeCertifiedCode;// 新证书号
	private String printTable; // 打印所需的table代码
	private String isCanceled; // 是否撤销:否0；是1
	private String orgId; // 俱乐部DNA留存标记位
	private Integer applyChannel; // 办理方式:0机构办理；1自检
	private String type;// 留存方式
	private String typeYes;// 是否完成
	private String organizationName; // 办理机构
	private String keyword; // 血统证书或者芯片号
	private Date beginFinishDate;
	private Date endFinishDate;
	private String isOEC; // 是否为口腔上皮细胞测试法:否0；是1
	private String province;//省份
	
	private List<Sampling> bindSamplingRecord;
	
	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getIsOEC() {
		return isOEC;
	}

	public void setIsOEC(String isOEC) {
		this.isOEC = isOEC;
	}

	public Date getBeginFinishDate() {
		return beginFinishDate;
	}

	public void setBeginFinishDate(Date beginFinishDate) {
		this.beginFinishDate = beginFinishDate;
	}

	public Date getEndFinishDate() {
		return endFinishDate;
	}

	public void setEndFinishDate(Date endFinishDate) {
		this.endFinishDate = endFinishDate;
	}

	public Date getFinishTime() {
		return finishTime;
	}

	public void setFinishTime(Date finishTime) {
		this.finishTime = finishTime;
	}

	public String getOrganizationName() {
		return organizationName;
	}

	public void setOrganizationName(String organizationName) {
		this.organizationName = organizationName;
	}

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public DogDnaArchive() {
		super();
	}

	public DogDnaArchive(String id) {
		super(id);
	}

	public DogDnaArchive(String runningNumber, String paymentChargingItemId, String paymentMemberCode) {
		this.runningNumber = runningNumber;
		this.paymentChargingItemId = paymentChargingItemId;
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min = 0, max = 64, message = "血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	public String getOverseasPedigreeCertified() {
		return overseasPedigreeCertified;
	}

	public void setOverseasPedigreeCertified(String overseasPedigreeCertified) {
		this.overseasPedigreeCertified = overseasPedigreeCertified;
	}

	@Length(min = 0, max = 64, message = "DNA样本登记号码长度必须介于 0 和 64 之间")
	public String getDnaCode() {
		return dnaCode;
	}

	public void setDnaCode(String dnaCode) {
		this.dnaCode = dnaCode;
	}

	public String getBirthCode() {
		return birthCode;
	}

	public void setBirthCode(String birthCode) {
		this.birthCode = birthCode;
	}

	@Length(min = 0, max = 64, message = "付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 500, message = "操作人长度必须介于 0 和 500 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 20, message = "审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 255, message = "审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 100, message = "流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 20, message = "付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	@Length(min = 0, max = 20, message = "流程状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public Date getDogBirthday() {
		return dogBirthday;
	}

	public void setDogBirthday(Date dogBirthday) {
		this.dogBirthday = dogBirthday;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	public String getPrintTable() {
		return printTable;
	}

	public void setPrintTable(String printTable) {
		this.printTable = printTable;
	}

	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}

	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}

	public String getIsCanceled() {
		return isCanceled;
	}

	public void setIsCanceled(String isCanceled) {
		this.isCanceled = isCanceled;
	}

	public String getOrgId() {
		return orgId;
	}

	public void setOrgId(String orgId) {
		this.orgId = orgId;
	}

	private String overseasPedigreeCertifiedLike;// 国外血统证书号模糊查询条件

	public String getOverseasPedigreeCertifiedLike() {
		return overseasPedigreeCertifiedLike;
	}

	public void setOverseasPedigreeCertifiedLike(String overseasPedigreeCertifiedLike) {
		this.overseasPedigreeCertifiedLike = overseasPedigreeCertifiedLike;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTypeYes() {
		return typeYes;
	}

	public void setTypeYes(String typeYes) {
		this.typeYes = typeYes;
	}

	public String getSamplingCode() {
		return samplingCode;
	}

	public void setSamplingCode(String samplingCode) {
		this.samplingCode = samplingCode;
	}

	public String getGeneticDiseaseJson() {
		return geneticDiseaseJson;
	}

	public void setGeneticDiseaseJson(String geneticDiseaseJson) {
		this.geneticDiseaseJson = geneticDiseaseJson;
	}

	public Integer getApplyChannel() {
		return applyChannel;
	}

	public void setApplyChannel(Integer applyChannel) {
		this.applyChannel = applyChannel;
	}

	public List<Sampling> getBindSamplingRecord() {
		return bindSamplingRecord;
	}

	public void setBindSamplingRecord(List<Sampling> bindSamplingRecord) {
		this.bindSamplingRecord = bindSamplingRecord;
	}

	public String getDogColorFlag() {
		return dogColorFlag;
	}

	public void setDogColorFlag(String dogColorFlag) {
		this.dogColorFlag = dogColorFlag;
	}

	public String getDogColorName() {
		return dogColorName;
	}

	public void setDogColorName(String dogColorName) {
		this.dogColorName = dogColorName;
	}

	public String getOrderDetailId() {
		return orderDetailId;
	}

	public void setOrderDetailId(String orderDetailId) {
		this.orderDetailId = orderDetailId;
	}

}