/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import com.cku.oa.dog.entity.DogSemen;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 犬只精子DAO接口
 *
 * @author lgl
 * @version 2017-08-28
 */
@MyBatisDao
public interface DogSemenDao extends CrudDao<DogSemen> {
    List<DogSemen> getBySemenBatchCode(@Param("semenBatchCode") String semenBatchCode);
    int deleteBySemenBatchCode(@Param("semenBatchCode") String semenBatchCode);
    DogSemen getBySemenCode(@Param("semenCode") String semenCode);
    List<DogSemen> getAvailableDogSemenByDogIdAndMemberCode(@Param("dogId") String dogId,@Param("memberCode") String memberCode);
    int setBreedCertifiedCode(Map map);
    int clearBreedCertifiedCode(Map map);
    int countByOriginalSemenCode(@Param("originalSemenCode") String originalSemenCode,@Param("id") String id);
    List<DogSemen> getUsedDogSemen(Map map);
}