/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.contest.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 赛场犬种Entity
 * @author yuanshuai
 * @version 2020-10-12
 */
public class ContestBreed extends DataEntity<ContestBreed> {
	
	private static final long serialVersionUID = 1L;
	private String breedNo;		// 编号
	private String code;		// 代码
	private String name;		// 名称
	private String groupNo;		// 犬种组
	private String languageNo;		// 语言
	
	public ContestBreed() {
		super();
	}

	public ContestBreed(String id){
		super(id);
	}

	@Length(min=1, max=11, message="编号长度必须介于 1 和 11 之间")
	public String getBreedNo() {
		return breedNo;
	}

	public void setBreedNo(String breedNo) {
		this.breedNo = breedNo;
	}
	
	@Length(min=1, max=32, message="代码长度必须介于 1 和 32 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	@Length(min=1, max=255, message="名称长度必须介于 1 和 255 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=1, max=11, message="犬种组长度必须介于 1 和 11 之间")
	public String getGroupNo() {
		return groupNo;
	}

	public void setGroupNo(String groupNo) {
		this.groupNo = groupNo;
	}
	
	@Length(min=1, max=11, message="语言长度必须介于 1 和 11 之间")
	public String getLanguageNo() {
		return languageNo;
	}

	public void setLanguageNo(String languageNo) {
		this.languageNo = languageNo;
	}
	
}