package com.cku.apidoc.web;

import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.apidoc.dao.ApiCategoryDao;
import com.cku.apidoc.dao.ApiInterfaceDao;
import com.cku.apidoc.dao.ApiParamsDao;
import com.cku.apidoc.entity.ApiCategory;
import com.cku.apidoc.entity.ApiInterface;
import com.cku.apidoc.entity.ApiParams;

@Controller
@RequestMapping(value="/apiDoc")
public class ApiDocController {
	@Autowired
	private ApiCategoryDao apiCategoryDao;
	@Autowired
	private ApiInterfaceDao apiInterfaceDao;
	@Autowired
	private ApiParamsDao apiParamsDao;
	
	
	@RequestMapping(value="")
	public String index(Model model){
		ApiCategory apiCategory = new ApiCategory();
		List<ApiCategory> categorys= apiCategoryDao.findAllList(apiCategory);
		JSONArray array = new JSONArray();
		for(ApiCategory category:categorys){
			JSONObject object = new JSONObject();
			object.put("id", category.getId());
			object.put("pId", category.getParent().getId());
			object.put("name", category.getName()+"(id:"+category.getId()+")");
			array.add(object);
		}
		model.addAttribute("categorys", array.toString());
		return "apiDoc/index";
	}
	
	
	@RequestMapping(value="/apiForm")
	public String form(Model model,HttpServletRequest request,HttpServletResponse response){
		String id = request.getParameter("id");
		
		List<ApiCategory> categorys= apiCategoryDao.findAllList();
		JSONArray array = new JSONArray();
		for(ApiCategory category:categorys){
			JSONObject object = new JSONObject();
			object.put("id", category.getId());
			object.put("pId", category.getParent().getId());
			object.put("name", category.getName()+"(id:"+category.getId()+")");
			array.add(object);
		}
		
		model.addAttribute("categorys", array.toString());
		if(id!=null&&!id.equals("")){
			ApiInterface ti = apiInterfaceDao.get(id);
			model.addAttribute("id", id);
			model.addAttribute("in",ti);
			return "apiDoc/edit";
		}
		
		return "apiDoc/form";
	}
	
	//得到所有接口
	@RequestMapping(value="/getByPId")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getTestInterfaceByPId(HttpServletResponse response,HttpServletRequest request) {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			String id = request.getParameter("id");
			ApiInterface in = new ApiInterface();
			in.setCategoryId(id);
			List<ApiInterface> result = apiInterfaceDao.findList(in);
		    JSONObject object = new JSONObject();
		    object.put("rc", 0);
		    JSONArray array = new JSONArray();
		    for(int i=0;i<result.size();i++){
		    	ApiInterface ai = result.get(i);
		    	JSONObject o = new JSONObject();
		    	o.put("categoryId", ai.getCategoryId());
		    	o.put("createTime", ai.getCreateTime().getTime());
		    	o.put("id",ai.getId());
		    	o.put("interName", ai.getInterName());
		    	o.put("method", ai.getMethod());
		    	o.put("interUrl", ai.getInterUrl());
		    	o.put("description", ai.getDescription());
		    	array.add(o);
		    }
		    object.put("items", array);
		    response.getWriter().write(object.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	//得到参数
	@RequestMapping(value="/getParams")
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void getParams(@RequestParam(value = "interfaceId", required = false)String interfaceId,
			HttpServletResponse response,HttpServletRequest request) {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			ApiParams params = new ApiParams();
			params.setInterfaceId(interfaceId);
			List<ApiParams> result = apiParamsDao.findList(params);
		    JSONObject object = new JSONObject();
		    object.put("rc", 0);
		    JSONArray array = new JSONArray();
		    for(int i=0;i<result.size();i++){
		    	ApiParams ai = result.get(i);
		    	JSONObject o = new JSONObject();
		    	o.put("createTime", ai.getCreateTime().getTime());
		    	o.put("id",ai.getId());
		    	o.put("interfaceId", ai.getInterfaceId());
		    	o.put("paramsName", ai.getParamsName());
		    	o.put("paramsType", ai.getParamsType());
		    	o.put("remarks", ai.getRemarks());
		    	o.put("paramsLimit", ai.getParamsLimit());
		    	array.add(o);
		    }
		    object.put("items", array);
		    object.put("total", result.size());
		    response.getWriter().write(object.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	//添加接口方法
	@RequestMapping(value="/add",method=RequestMethod.POST, headers = {"content-type=application/json","content-type=application/xml"})
	@ResponseBody//结果不会被解析为跳转路径，而是直接写入HTTP response body中
	public void add(HttpServletResponse response,HttpServletRequest request,@RequestBody ApiInterface apiInterface) {
		try {
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/html");
			if(apiInterface.getIsNewRecord()){
				apiInterface.preInsert();
				apiInterface.setCreateTime(new Date());
				apiInterface.setDescription(StringEscapeUtils.unescapeHtml4(apiInterface.getDescription()));
				apiInterfaceDao.insert(apiInterface);
				List<ApiParams> params = apiInterface.getParamList();
				for(ApiParams param:params){
					param.setCreateTime(new Date());
					param.preInsert();
					param.setInterfaceId(apiInterface.getId());
					apiParamsDao.insert(param);
				}
				
			}else{
				//删除所有的参数重新添加
				String id = apiInterface.getId();
				ApiParams params= new ApiParams();
				params.setInterfaceId(id);
				List<ApiParams> list = apiParamsDao.findList(params);
				for(ApiParams p:list){
					apiParamsDao.delete(p);
				}
				apiInterface.setDescription(StringEscapeUtils.unescapeHtml4(apiInterface.getDescription()));
				apiInterface.setCreateTime(new Date());
				apiInterfaceDao.update(apiInterface);
				
				List<ApiParams> ps = apiInterface.getParamList();
				if(ps != null&& ps.size()>0){
					for(ApiParams param:ps){
						param.setCreateTime(new Date());
						param.preInsert();
						param.setInterfaceId(apiInterface.getId());
						apiParamsDao.insert(param);
					}
				}
			}
			JSONObject object = new JSONObject();
			
		    response.getWriter().write(object.toString());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
