<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>配种证明管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					if($("#malePuppyRegisterNum").val()!=''||$("#femalePuppyRegisterNum").val()!=''){
						if($("#malePuppyRegisterNum").val()==''){
							$("#malePuppyRegisterNum").val(0);
						} else if($("#femalePuppyRegisterNum").val()=='') {
							$("#femalePuppyRegisterNum").val(0);
						}
						$("#dogRegisterNum").val($("#malePuppyRegisterNum").val()+","+$("#femalePuppyRegisterNum").val());
					} else {
						$("#puppyRegisterNum").val('');
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			/*页面初始化分隔登记数数据并分开展示在页面*/
            var registerNumList = $("#dogRegisterNum").val().split(',');
            if(registerNumList.length>0){
                $("#malePuppyRegisterNum").val(registerNumList[0]);
                $("#femalePuppyRegisterNum").val(registerNumList[1]);
            } else {
                $("#malePuppyRegisterNum").val(0);
                $("#femalePuppyRegisterNum").val(0);
            }
		});
	</script>
</head>

<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxDc}/dogNewborn">配种证明列表</a></li>
		<li class="active"><a href="${ctxDc}/dogNewborn/form?id=${dogNewborn.id}">配种证明<shiro:hasPermission name="dognewborn:dogNewborn:view">${not empty dogNewborn.id?'查看':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dognewborn:dogNewborn:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogNewborn" action="${ctx}/dognewborn/dogNewborn/edit" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">配种证明编号：</label>
			<div class="controls">
				<form:input path="breedCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">犬种类：</label>
            <div class="controls">
                <form:input path="dogBreed" htmlEscape="false" maxlength="10" class="input-xlarge " style="width:40px;" readonly="true"/>&nbsp;
                <form:input path="dogType.dogBreed" htmlEscape="false" class="input-xlarge" readonly="true"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label" >公犬主人姓名：</label>
			<div class="controls">
				<form:input path="maleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬主人会员号：</label>
			<div class="controls">
				<form:input path="mdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">母犬主人姓名：</label>
			<div class="controls">
				<form:input path="femaleDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬主人会员号：</label>
			<div class="controls">
				<form:input path="fdogOwnerCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">公犬姓名：</label>
			<div class="controls">
				<form:input path="maleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">公犬证书号：</label>
			<div class="controls">
				<form:input path="malePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">母犬姓名：</label>
			<div class="controls">
				<form:input path="femaleDogName" htmlEscape="false" maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">母犬证书号：</label>
			<div class="controls">
				<form:input path="femalePedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">配种日期：</label>
			<div class="controls">
				<input name="breedDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNewborn.breedDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogNewborn.birthday}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">出生数量：</label>
			<div class="controls">
				<form:input path="puppyBirthNum" htmlEscape="false" maxlength="10" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记数量：</label>
			<div class="controls">
				<form:hidden path="dogRegisterNum" htmlEscape="false" maxlength="10" class="input-xlarge "/>
				<input id="malePuppyRegisterNum" type="text" class="input-xlarge digits" htmlEscape="false" style="width: 20px;"  readonly="readonly">公
				<input id="femalePuppyRegisterNum" type="text" class="input-xlarge digits"  htmlEscape="false" style="width: 20px;"  readonly="readonly">母
			</div>
		</div>
		<div class="control-group" style="float: left">
            <label class="control-label">加急：</label>
            <div class="controls">
                <form:select path="urgent" class="input-xlarge " style="width: 80px;" disabled="true">
                    <form:option value="" label=""/>
                    <form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">近亲繁殖取DNA：</label>
            <div class="controls">
                <form:checkbox path="kinGetDna"  value="1" class="input-xlarge " disabled="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">近亲结果：</label>
            <div class="controls">
                <form:select path="kinBreed" class="input-xlarge " disabled="true" style="width: 80px;" >
                    <form:option value="0" label="请选择"/>
                    <form:options items="${fns:getDictList('kinResults')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">审核状态：</label>
            <div class="controls">
                <form:select path="reviewState" class="input-xlarge " onclick="changeState(this);" disabled="true">
                    <form:option value="" label=""/>
                    <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group" id="remarksDiv">
            <label class="control-label">审核的意见：</label>
            <div class="controls">
                <form:input path="reviewRemarks" htmlEscape="false" maxlength="255" class="input-xlarge " disabled="true"/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>