<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>单犬种俱乐部修改</title>
	<meta name="decorator" content="default"/>
	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<style>
		.form-horizontal .control-label{
			width:120px !important;

		}

	</style>
	<style>
		.picDiv>div{
			width:33%;
		}
	</style>
	<script type="text/javascript">
        $(document).ready(function() {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function(form){
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function(error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //回显犬只毛色信息
            var orgDogType = '${fns:escapeHtml(org.orgDogType)}';
            var orgDogTypeArray = orgDogType.split(",");
            $.each(orgDogTypeArray, function(i,val) {
                $("#orgDogType").find("option[value='"+val+"']").attr("selected",true);
            });
            $("#orgDogType").trigger("change");

        });

        function changeCouponCount(id, type) {
            parent.layer.open({
                type: 2,
                title: ['修改优惠券数量', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['600px', '360px'],
                content: "${ctx}/sys/singleOrg/orgCouponCountForm?id=" + id + "&type=" + type,
            });
            return false;
        }

        function bindOrgCouponCallback(data){
            window.location.reload();
        }
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctx}/sys/singleOrg/">单犬种俱乐部列表</a></li>
	<li class="active"><a href="${ctx}/sys/singleOrg/editForm?id=${org.id}">单犬种俱乐部修改</a></li>
</ul><br/>
<form:form id="inputForm" modelAttribute="org" action="${ctx}/sys/singleOrg/save" method="post" class="form-horizontal">
	<form:hidden path="id"/>
	<sys:message content="${message}"/>
	<form:hidden path="orgType" value="singleTypeClub"/>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">登录帐号：</label>
		<div class="controls">
				${fns:escapeHtml(org.user.loginName)}
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">登录密码：</label>
		<div class="controls">
			<input type="password" name="user.password" class="input-xlarge" />
			<span class="help-inline"><font color="red">空值为不修改</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">机构名称：</label>
		<div class="controls">
			<form:input path="name" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">授权地区：</label>
		<div class="controls">
			<form:select id="authorizedProvince" path="authorizedProvince" class="input-small required">
				<form:option value=""></form:option>
				<c:forEach items="${province}" var="p">
					<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
				</c:forEach>
			</form:select>
			<form:select id="authorizedCity" path="authorizedCity" class="input-small required">
				<form:option value=""></form:option>
				<c:forEach items="${authorizedProvince}" var="c">
					<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
				</c:forEach>
			</form:select>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<script>
        $("#authorizedProvince").change(function(){
            var extId = $("#authorizedProvince").val();
            //异步请求数据
            var url="${ctx}"+"/sys/area/treeData";
            $.get(url,{extId:extId},function(data){
                var content = "<option value=''></option>";
                for(var i in data){
                    content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
                }
                $("#authorizedCity").html(content).trigger("change");
            },"json")

        })
	</script>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">联系人：</label>
		<div class="controls">
			<form:input path="contact" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">联系电话：</label>
		<div class="controls">
			<form:input path="tel" htmlEscape="false" maxlength="50" class="input-xlarge required isTel"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">省市：</label>
		<div class="controls">
			<form:select id="province" path="province" class="input-small required">
				<form:option value=""></form:option>
				<c:forEach items="${province}" var="p">
					<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
				</c:forEach>
			</form:select>
			<form:select id="city" path="city" class="input-small required">
				<form:option value=""></form:option>
				<c:forEach items="${city}" var="c">
					<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
				</c:forEach>
			</form:select>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<script>
        $("#province").change(function(){
            var extId = $("#province").val();
            //extId = encodeURI(extId);
            //异步请求数据
            var url="${ctx}"+"/sys/area/treeData";
            $.get(url,{extId:extId},function(data){
                var content = "<option value=''></option>";
                for(var i in data){
                    content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
                }
                $("#city").html(content).trigger("change");
            },"json")

        })
	</script>

	<div class="control-group">
		<label class="control-label">街道：</label>
		<div class="controls">
			<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">座机电话：</label>
		<div class="controls">
			<form:input path="landlinePhone" htmlEscape="false" class="input-xlarge number"/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">审核状态：</label>
		<div class="controls">
			<form:select path="shenHeState" class="input-small required">
				<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">截止日期：</label>
		<div class="controls">
			<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
				   value="<fmt:formatDate value="${org.endDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group" style="float:left">
		<label class="control-label">官网显示：</label>
		<div class="controls">
			<form:radiobuttons path="displayOnWeb" items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">会员中心显示：</label>
		<div class="controls">
			<form:radiobuttons path="visibleFlag" items="${fns:getDictList('yes_no_reversal')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group" style="float:left">
		<label class="control-label">芯片扫描仪：</label>
		<div class="controls">
			<input type="radio" name="scanner" value="yes"/>是
			<input type="radio" name="scanner" value="no" checked="checked"/>否
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">押金：</label>
		<div class="controls">
			<form:input path="deposit" htmlEscape="false" class="input-xlarge isFloatGtZero"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">缴纳押金日期：</label>
		<div class="controls">
			<input name="depositDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
				   value="<fmt:formatDate value="${org.depositDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
				   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">会员费抵扣券数量：</label>
		<div class="controls">
				已用${org.memberCouponNumUsed}张，可用${org.memberCouponNumCanUse}张，总计${org.memberCouponNum}张
				<shiro:hasPermission name="sys:singleOrg:coupon">
					<input id="btnCouponUp" class="btn" type="button" value="+" onclick="changeCouponCount('${org.id}','up')"/>
					<input id="btnCouponDown" class="btn" type="button" value="-" onclick="changeCouponCount('${org.id}','down')"/>
				</shiro:hasPermission>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="control-group">
		<label class="control-label">经营犬种：</label>
		<div class="controls">
			<form:select id="orgDogType" path="orgDogType" class="input-xxlarge" multiple="true">
				<form:options items="${dogTypeList}" itemLabel="breedCnName" itemValue="id" htmlEscape="false"/>
			</form:select>
			<span class="help-inline"><font color="red">*</font></span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">cku会员编号：</label>
		<div class="controls">
			<form:input path="adminCode" htmlEscape="false" class="input-xlarge isFloatGtZero"/>
		</div>
	</div>
	<div style="clear:both;"></div>
	<div class="form-actions">
		<shiro:hasPermission name="sys:singleOrg:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>