<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>优惠券发放</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					$("#btnSubmit").attr("disabled",true);
					console.log($('#inputForm'))
					if($('#couponName').val() == ''){
						alert("优惠券名称为空！");
						$("#btnSubmit").attr("disabled",false);
						return
					} 
					if($('#memberCode_s').val() == ''){
						alert("会员/机构编号为空！");
						$("#btnSubmit").attr("disabled",false);
						return
					} 
					if($('#effectiveDate').val() == ''||$('#validDate').val() == ''){
						alert("有效期为空！");
						$("#btnSubmit").attr("disabled",false);
						return
					} 
					if($('#num').val() == ''){
						alert("请填写发放数量！");
						$("#btnSubmit").attr("disabled",false);
						return
					} 
					if($('#explains').val() == ''){
						alert("请填写优惠券说明！");
						$("#btnSubmit").attr("disabled",false);
						return
					} 
					loading('正在提交，请稍等...');
 				    $.post('${ctx}/coupon/sysCoupon/addSysCoupon',
 				    		$('#inputForm').serialize(),
 					function(data) {
 		 				if(data.rc==0){
 							alert("添加成功！");
 							parent.isYes = true;
 							parent.layer.closeAll();
 						}else{
 							$("#btnSubmit").attr("disabled",false);
 							alert("添加失败,错误信息："+data.msg);
 						} 
 				    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function searchMember (){
			 $.get('${ctx}/coupon/sysCoupon/getMemberName?code='+$('#memberCode_s').val(),
				function(data) {
	 				if(data.rc==0){
						$('#memberName').html(data.data)
					}else{
						alert("添加失败,错误信息："+data.msg);
					} 
			    }); 
		}
		function closeLayer(){
			parent.layer.closeAll();
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
		#btn111{margin-left: 50px;}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="sysCoupon" class="form-horizontal">
	<div class="control-group">
		<label class="control-label">优惠券名称：</label>
		<div class="controls">
			<form:select id="couponName" path="couponName" class="input-medium" cssStyle="width:200px">
			    <option value ="">请选择名称</option>
				<option value ="dogvideo">视频鉴定抵扣券</option>
				<option value = "memberdog">代金券（50元）</option>
			</form:select>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">有效期：</label>
		<div class="controls">
			<input id="effectiveDate" name="effectiveDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" placeholder="开始时间"/> -
				<input id="validDate" name="validDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" placeholder="结束时间"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">会员/机构编号：</label>
		<div class="controls">
				<form:input path="memberCode" id="memberCode_s" htmlEscape="false" maxlength="64" class="input-medium" placeholder="请输入会员/机构编号"/>
				<input id="btn111" class="btn btn-primary" type="button" value="查询" onclick="searchMember()"/></li>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">会员/机构名称：</label>
		<div class="controls">
		<div id="memberName"></div>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label"> 优惠券说明：</label>
		<div class="controls">
				<form:input path="explains" id="explains" htmlEscape="false" maxlength="64" class="input-medium" placeholder="请输入有会员使用说明"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">发放数量：</label>
		<div class="controls">
				<form:input path="num" type="number" htmlEscape="false" maxlength="64" class="input-medium" placeholder="请输入发放数量"/>
		</div>
	</div>
	<div class="control-group" style="text-align: center;">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="确认提交"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="关闭返回" onclick="closeLayer()"/>
	</div>
</form:form>
</body>
</html>