<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>大客户数据管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
        $(document).ready(function() {
            $("#btnImport").click(function(){
                $.jBox($("#importBox").html(), {title:"大客户数据导入", buttons:{"关闭":true},
                    bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
            });
        });
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		
	</script>
	
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/statistics/memberVip/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/statistics/memberVip/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/statistics/memberVip/">大客户数据列表</a></li>
		<shiro:hasPermission name="statistics:memberVip:edit"><li><a href="${ctx}/statistics/memberVip/form">大客户数据添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="memberVip" action="${ctx}/statistics/memberVip/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="16" class="input-medium"/>
			</li>
			<li><label>客户类型：</label>
				<form:select path="contractType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('contract_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>签约日期：</label>
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${memberVip.startDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:false});"/>
			</li>
			<li><label>客户经理：</label>
				<form:input path="manInCharge" htmlEscape="false" maxlength="16" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入大客户数据"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员姓名</th>
				<th>会员号</th>
				<th>客户类型</th>
				<th>合同签约数量</th>
				<th class="sort-column startDate">签约日期</th>
				<th>客户经理</th>
				<shiro:hasPermission name="statistics:memberVip:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="memberVip">
			<tr>
				<td>
						${fns:escapeHtml(memberVip.memberName)}
				</td>
				<td>
						${memberVip.memberCode}
				</td>
				<td>
						${fns:getDictLabel(memberVip.contractType, 'contract_type', '')}
				</td>
				<td>
						${memberVip.contractNum}
				</td>
				<td>
						<fmt:formatDate value="${memberVip.startDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
						${memberVip.manInCharge}
				</td>
				<shiro:hasPermission name="statistics:memberVip:edit">
					<td>
    						<a href="${ctx}/statistics/memberVip/form?id=${memberVip.id}">修改</a>
					</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>