<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展积分管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {

		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/score/showScore/">犬展积分列表</a></li>
		<li><a href="${ctx}/show/showScoreTitle/">积分榜管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="showScore" action="${ctx}/score/showScore/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬主人：</label>
				<form:input path="dogOwner" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>犬只证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>积分类型：</label>
				<form:select path="scoreType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_score_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>年份：</label>
				<form:select path="year" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="2016" label="2016"/>
					<form:option value="2015" label="2015"/>
					<form:option value="2014" label="2014"/>
					<form:option value="2013" label="2013"/>
					<form:option value="2012" label="2012"/>
					<form:option value="2011" label="2011"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>积分</th>
				<th>血统证书编号</th>
				<th>性别</th>
				<th>犬主人</th>
				<th>犬种中文名</th>
				<th>犬名</th>
				<th>积分类型</th>
				<th>年度</th>
				<th>管理</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="showScore">
			<tr>
				<td>
					${fns:escapeHtml(showScore.score)}
				</td>
				<td>
					${fns:escapeHtml(showScore.pedigreeCertified)}
				</td>
				<td>
					${fns:getDictLabel(showScore.dogGender, 'dog_gender', '')}
				</td>
				<td>
					${fns:escapeHtml(showScore.dogOwner)}
				</td>
				<td>
					${fns:escapeHtml(showScore.dogBreedNameCn)}
				</td>
				<td>
					${fns:escapeHtml(showScore.dogName)}
				</td>
				<td>
					${fns:escapeHtml(showScore.scoreType)}
				</td>
				<td>
					${fns:escapeHtml(showScore.year)}
				</td>
   				<td>
				<shiro:hasPermission name="score:showScore:view">
   					<a href="${ctx}/score/showScore/form?id=${showScore.id}">查看</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="score:showScore:edit">
   					<a href="${ctx}/score/showScore/editForm?id=${showScore.id}">编辑</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="score:showScore:delete">
					<a href="${ctx}/score/showScore/delete?id=${showScore.id}" onclick="return confirmx('确认要删除该犬展积分吗？', this.href)">删除</a>
				</shiro:hasPermission>
   				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>