<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展积分管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/score/showScore/">犬展积分列表</a></li>
		<li class="active"><a href="${ctx}/score/showScore/form?id=${showScore.id}">犬展积分<shiro:hasPermission name="score:showScore:edit">${not empty showScore.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="score:showScore:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showScore" action="${ctx}/score/showScore/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">积分：</label>
			<div class="controls">
				<form:input path="score" htmlEscape="false" type="number" maxlength="4" class="input-xlarge required" disabled="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书编号：</label>
			<div class="controls">
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="dogGender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<form:input path="dogOwner" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种中文名：</label>
			<div class="controls">
				<form:input path="dogBreedNameCn" htmlEscape="false" maxlength="20" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种英文名：</label>
			<div class="controls">
				<form:input path="dogBreedNameEn" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
				<form:input path="dogName" htmlEscape="false" maxlength="50" class="input-xlarge required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">积分类型：</label>
			<div class="controls">
				<form:radiobuttons path="scoreType" items="${fns:getDictList('show_score_type')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">年份：</label>
			<div class="controls">
				<form:select path="year" htmlEscape="false" type="number" maxlength="4" class="input-xlarge required">
					<form:option value="2016" label="2016"/>
					<form:option value="2015" label="2015"/>
					<form:option value="2014" label="2014"/>
					<form:option value="2013" label="2013"/>
					<form:option value="2012" label="2012"/>
					<form:option value="2011" label="2011"/>
				</form:select>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="score:showScore:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>