<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>代收代入管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function changeTotalTimeType(type){
			var arr = null;
			if(type==0){
				arr = util.getCurrentMonth();
			}else{
				arr = util.getCurrentYear();
			}
			if(arr!=null && arr.length>0){
				$("#startAddTime").val(util.formatDateLong(arr[0]));
				$("#endAddTime").val(util.formatDateLong(arr[1]));
				$("form").submit();
			}
		}

		var localType = null;
		//打开查询用户的弹窗
		function searchUser(type){
			localType = type;
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#memberCode"+localType).val(json.memberCode);
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentPayOther/">代收代付明细</a></li>
		<shiro:hasPermission name="finance:paymentPayOther:add"><li><a href="${ctx}/finance/paymentPayOther/form">代收代付录入</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="paymentPayOther" action="${ctx}/finance/paymentPayOther/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>流水号：</label>
				<form:input path="runningNum" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>收款人：</label>
				<form:input path="payee" id="memberCodep" htmlEscape="false" maxlength="64" class="input-medium"/>
				<button class="btn btn-default" type="button" id="memberCodeBtnp" onclick="searchUser('p')">查</button>
			</li>
			<li><label>付款人：</label>
				<form:input path="drawee" id="memberCoded" htmlEscape="false" maxlength="64" class="input-medium"/>
				<button class="btn btn-default" type="button" id="memberCodeBtnp" onclick="searchUser('d')">查</button>
			</li>
			<li><label>金额：</label>
				<form:input path="price" htmlEscape="false" class="input-medium"/>
			</li>
			<li><label>起始时间：</label>
				<input name="startAddTime" id="startAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${paymentPayOther.startAddTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>结束时间：</label>
				<input name="endAddTime" id="endAddTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${paymentPayOther.endAddTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>备注信息：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="统计"/>
				<input id="btnMonth" class="btn btn-primary" type="button" onclick="changeTotalTimeType(0)" value="本月"/>
				<input id="btnYear" onclick="changeTotalTimeType(1)" class="btn btn-primary" type="button" value="本年"/>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>流水号</th>
				<th>收款会员号</th>
				<th>收款人</th>
				<th>付款会员号</th>
				<th>付款人</th>
				<th>金额</th>
				<th>缴费时间</th>
				<th>备注</th>
				<th>操作人</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentPayOther">
			<tr>
				<td>
					${fns:escapeHtml(paymentPayOther.runningNum)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.payee)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.payeeName)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.drawee)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.draweeName)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.price)}
				</td>
				<td>
					<fmt:formatDate value="${paymentPayOther.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.remarks)}
				</td>
				<td>
					${fns:escapeHtml(paymentPayOther.updateBy.name)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>