<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>登记卡变更</title>
	<meta name="decorator" content="default"/>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>

<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/birthcertificate/dogBirthCertificate/transferList">登记卡管理</a></li>
		<li class="active"><a href="${ctx}/birthcertificate/dogBirthCertificate/transferForm?id=${fns:escapeHtml(dogBirthCertificateTransfer.id)}">登记卡变更</a></li>
	</ul><br/>
		<sys:message content="${message}"/>
		
		<div class="control-group">
			<label class="control-label">登记卡编号：</label>
			<div class="controls">
				<input id="birthCode" name="birthCode" type="text" readonly="readonly" value="${obj.birthCode}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		
	
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<input id="idNo" name="idNo" type="text" readonly="readonly" value="${obj.idNo}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">英文犬名：</label>
			<div class="controls">
				<input id="dogEnName" name="dogEnName" type="text" readonly="readonly" value="${obj.dogEnName}"  maxlength="100" class="input-xlarge required" />
			</div>
		</div>
		

		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input id="dogGender" name="dogGender" type="text" readonly="readonly" value="${fns:getDictLabels(obj.dogGender, 'dog_gender', '')}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
         <div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="dogBirth" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${obj.dogBirth}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
        
		<div class="control-group">
			<label class="control-label">种类：</label>
			<div class="controls">
				<input id="dogBreed" name="dogBreed" type="text" readonly="readonly" value="${obj.dogBreed}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
        
        <div class="control-group">
			<label class="control-label">繁殖人：</label>
			<div class="controls">
				<input id="transferorMemberName" name="transferorMemberName" type="text" readonly="readonly" value="${obj.transferorMemberName}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
        <div class="control-group">
			<label class="control-label">繁殖人会员号：</label>
			<div class="controls">
				<input id="transferorMemberCode" name="transferorMemberCode" type="text" readonly="readonly" value="${obj.transferorMemberCode}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
       <div class="control-group">
			<label class="control-label">新犬主：</label>
			<div class="controls">
				<input id="receiverMemberName" name="receiverMemberName" type="text" readonly="readonly" value="${obj.receiverMemberName}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
		 <div class="control-group">
			<label class="control-label">新犬主会员号：</label>
			<div class="controls">
				<input id="receiverMemberCode" name="receiverMemberCode" type="text" readonly="readonly" value="${obj.receiverMemberCode}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
         <div class="control-group">
			<label class="control-label">申请日期：</label>
			<div class="controls">
				<input name="createDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${obj.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		 <div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
			
			<input id="receiverMemberCode" name="receiverMemberCode" type="text" readonly="readonly" 
				value="${obj.businessStatus=='0'?'通过': obj.businessStatus=='1'? '未通过':'待审核'}"  maxlength="60" class="input-xlarge required" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<textarea path="obj.remark" htmlEscape="false" rows="4" readonly="readonly"  class="input-xxlarge " >${obj.remark}</textarea>
			</div>
		</div>
		
     
        
		
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
</body>
</html>