package com.cku.schools.sys;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.util.MD5Generator;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.servlet.ValidateCodeServlet;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.Area;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.security.FormAuthenticationFilter;
import com.thinkgem.jeesite.modules.sys.security.UsernamePasswordToken;
import com.thinkgem.jeesite.modules.sys.service.SystemService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 合作学校的用户登录
 * @author chaixueteng
 *
 */
@Controller
@RequestMapping(value="/schools")
public class SchoolLoginController {
	@Autowired
	private SystemService systemService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private UserService userService;

	//合作学校的用户退出
	@RequestMapping(value="/logout" , method=RequestMethod.GET)
	public String logout(HttpServletRequest request,HttpServletResponse response) throws IOException{
		try{
			SecurityUtils.getSubject().logout();
		}catch(Exception e){
			e.printStackTrace();
		}
		//return "redirect:http://www.cku.org.cn";
		return "schools/sys/sysLogin";
	}
	
	@RequestMapping(value = {"","/index"}, method = RequestMethod.GET)
	public String loginPage(){
		return "schools/sys/sysLogin";
	}
	
	//合作学校的登录
	@RequestMapping(value = "/login", method = RequestMethod.POST)
	public String login(@RequestParam String username,@RequestParam String password,@RequestParam String validateCode,HttpServletRequest request,Model model){
		String host = IPLimitUtil.getIpAddr((HttpServletRequest)request);
		//获取登录端 by zhuoHeng 2017年4月20日11:41:36
		String loginType = ServletUtils.getParameter(request, "loginType",null);
		try{
			TrainingInstitution trainingInstitution = doLogin(username, password, validateCode, host,loginType);
			UserUtils.getSession().setAttribute("trainingInstitution", trainingInstitution);
			model.addAttribute("date", new Date());
			return "schools/sys/index";
		}catch(Exception e){
			model.addAttribute(FormAuthenticationFilter.DEFAULT_USERNAME_PARAM, username);
			model.addAttribute(FormAuthenticationFilter.DEFAULT_MESSAGE_PARAM, e.getMessage());
			return "schools/sys/sysLogin";		
		}
	}
	
	//用户刷新页面
	@RequestMapping(value = "/login", method = RequestMethod.GET)
	public String getLogin(HttpServletRequest request,Model model){
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		if(trainingInstitution == null || !SecurityUtils.getSubject().isAuthenticated()){
			return "schools/sys/sysLogin";
		}
		return "schools/sys/index";
	}

	private TrainingInstitution doLogin(String username, String password, String validateCode,
			String host,String loginType) {
		if(StringUtils.isBlank(username)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录名不能为空");
		}
		if(StringUtils.isBlank(password)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "密码不能为空");
		}
		//验证码校验
		userService.checkValidateCode(validateCode);
		User user = systemService.getUserByLoginNameAndUserType(username,"3");
		if(user==null){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录帐号不存在");
		}
		if(!user.getPassword().equals(MD5Generator.generate16(password))){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您输入的密码不正确");
		}
		//合作机构可不可用是判断合作机构的截止时间
		TrainingInstitution trainingInstitution = new TrainingInstitution();
		trainingInstitution.setUser(user);
		List<TrainingInstitution> findGroomerList = trainingInstitutionDao.findGroomerList(trainingInstitution);
		if(findGroomerList.size() == 1){
			if("0".equals(user.getLoginFlag())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号未开放，请联系CKU处理");
			}else if(StringUtils.isBlank(user.getLoginFlag())){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号未开放，请联系CKU处理");
			}
		}else{
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "对不起您的帐号信息有误，请联系CKU处理");
		}
			 
		// 已到期
//		Member member = memberService.getByUserId(user.getId());
//		int result = member.getMemberEndDate().compareTo(DateUtils.parseDate(DateUtils.getDate()));
//		if (result < 0) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您好，贵校的合作年费已到期。为了不影响贵校的业务办理及其它合作事项，请尽快联系CKUGC工作人员。");
//		}
		//将用户信息存放到登录信息里
		UsernamePasswordToken token = new UsernamePasswordToken(username,password.toCharArray(),"3",false,host,validateCode,false,loginType);
		SecurityUtils.getSubject().login(token);
		
		return findGroomerList.get(0);
	}
	
	/**
	 * 密码页
	 * @Author chaixueteng
	 * @2016年10月13日上午9:57:54
	 */
	@RequestMapping(value="/rePassword")
	public String rePassword(Model model){
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		User user = trainingInstitution.getUser();
		model.addAttribute("user", user);
		return "schools/sys/rePassword";
	}
	
	/**
	 * 修改密码
	 * @Author chaixueteng
	 * @2016年10月13日上午11:10:48
	 */
	@RequestMapping(value="/updatePassword")
	public String updatePassword(String id,String oldPassword, String newPassword, Model model){
		User user = systemService.getUser(id);
		if (StringUtils.isNotBlank(oldPassword) && StringUtils.isNotBlank(newPassword)){
			if (SystemService.validatePassword(oldPassword, user.getPassword())){
				systemService.updatePasswordById(id, user.getLoginName(), newPassword);
				model.addAttribute("message", "修改密码成功");
			}else{
				model.addAttribute("message", "修改密码失败，旧密码错误");
			}
		}
		model.addAttribute("user", user);
		return "schools/sys/rePassword";
	}
	
	/**
	 * 
	 * @description: 获取验证码
	 * @author: laiguanglong
	 * @date: 2016年9月26日 下午6:27:34
	 */
	@RequestMapping(value = "/validateCode", method = RequestMethod.GET)
	public void getHospital(HttpServletRequest request,
			HttpServletResponse response) throws IOException, ServletException {
		ValidateCodeServlet servlet = new ValidateCodeServlet();
		servlet.doGet(request, response);
	}
	
	@ResponseBody
	@RequestMapping(value = "treeData")
	public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
		List<Map<String, Object>> mapList = Lists.newArrayList();
		extId = URLDecoder.decode(extId);
		List<Area> list = UserUtils.getCityByProvince(extId);
		for (int i=0; i<list.size(); i++){
			Area e = list.get(i);
			Map<String, Object> map = Maps.newHashMap();
			map.put("id", e.getId());
			map.put("pId", e.getParentId());
			map.put("name", e.getName());
			mapList.add(map);
		}
		return mapList;
	}
	/**
	 * 查询登录账号是否有效信息
	 * @Author chaixueteng
	 * @2016年10月23日下午2:27:00
	 */
	@RequestMapping("checkPayment")
	@ResponseBody
	public Object rockMsg(HttpServletRequest request,HttpServletResponse response){
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String memberCode = ti.getSchoolMemberCode();
		Member member = memberService.getByMemberCode(memberCode);
		Member byMemberCode = memberService.getByMemberCode(ti.getMemberCode());
		boolean activeFlag = MemberUtil.isActiveMember(byMemberCode);
		Calendar calendar = Calendar.getInstance();  
        calendar.setTime(new Date());  
        calendar.add(Calendar.DAY_OF_MONTH, -1);  
	    Date  currentDate = calendar.getTime(); 
		if(member.getMemberEndDate()==null||!activeFlag){
			return "{\"rc\":false}";
		}else if(member.getMemberEndDate().getTime()>currentDate.getTime()&&activeFlag){
			return "{\"rc\":true}";
		}else{
			return "{\"rc\":false}";
		}
	}
	
	@RequestMapping("expire")
	@ResponseBody
	public Map<String, Object> expire(HttpServletRequest request, HttpServletResponse response) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String memberCode = ti.getSchoolMemberCode();
		Member member = memberService.getByMemberCode(memberCode);
		int disparity = new Double(
				DateUtils.getDistanceOfTwoDate(DateUtils.parseDate(DateUtils.getDate()), member.getMemberEndDate()))
						.intValue();
		Map<String, Object> result = new HashMap<>();
		result.put("code", "-1");
		if (disparity == 30 || disparity == 15 || disparity == 10 || disparity == 1) {
			result.put("code", "0");
			result.put("disparity", disparity);
			result.put("memberCode", member.getMemberCode());
		}
		return result;
	}
	
}
