package com.cku.schools.mrschool.web;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.AgeUtil;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.schools.mrschool.service.SchoolsMemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 合作学校会员登记及管理
 *user chaixueteng
 *2017年6月19日
 */
@Controller
@RequestMapping(value="/schools/schoolsMember")
public class SchoolsMemberController extends BaseController{
	
	@Autowired
	public MemberService memberService;
	@Autowired
	public SchoolsMemberService schoolsMemberService;
	@Autowired
	public RestIDCardService restIDCardService;
	@ModelAttribute
	public Member get(@RequestParam(required=false) String id) {
		Member entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = memberService.get(id);
		}
		if (entity == null){
			entity = new Member();
		}
		return entity;
	}
	
	
	/**
	 * 会员登记
	 * @Author chaixueteng
	 * @2017年6月19日下午5:25:10
	 */
	@RequestMapping(value = "form")
	public String form(Member member, Model model) {
		model.addAttribute("date", new Date());
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String loginName = trainingInstitution.getUser().getLoginName();
		model.addAttribute("loginName", loginName);
		model.addAttribute("member", member);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(member.getProvince()));
		return "schools/mrschool/memberAdd";
	}
	/**
	 *保存会员信息
	 * @Author chaixueteng
	 * @2017年6月20日上午10:27:09
	 */
	@RequestMapping(value = "save", method=RequestMethod.POST)
	public String save(Member member, Model model, RedirectAttributes redirectAttributes,HttpServletRequest request){
		try {
            member.setName(StringEscapeUtils.unescapeHtml4(member.getName()));
			if (member.getIsNewRecord()) {//新增的验证实名
				int flag = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),member.getMemberSite(), true);
				if(flag==0){
					addMessage(redirectAttributes, "实名认证失败，请重试");
					return "redirect:/schools/schoolsMember/list?repage";
				}else{
					member.setAuthentication(String.valueOf(flag));
				}

			}
			memberService.save(member);
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:/schools/schoolsMember/list?repage";
	}

	/**
	 * 修改会员信息
	 * @Author chaixueteng
	 * @2017年6月21日下午2:29:09
	 */
	@RequestMapping(value = "edit")
	public String edit(Member member, Model model) {
		model.addAttribute("member", member);
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(member.getProvince()));
		return "schools/mrschool/memberEdit";
	}
	
	/**
	 * 会员列表
	 * @Author chaixueteng
	 * @2016年10月10日下午3:02:08
	 */
	@RequestMapping(value = {"list", ""})
	public String list(Member member,HttpServletRequest request, HttpServletResponse response, Model model) {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		String name = trainingInstitution.getUser().getName();
		member.setRegistrant(name.trim());
		Page<Member> page = memberService.findPage(new Page<Member>(request, response), member); 
		model.addAttribute("date", new Date());
		model.addAttribute("page", page);
		return "schools/mrschool/memberList";
	}
	

	/**
	 * 删除会员(逻辑)
	 * @Author chaixueteng
	 * @2017年6月21日下午2:26:31
	 */
	@RequestMapping(value = "delete")
	public String delete(Member member, RedirectAttributes redirectAttributes) {
		try {
			memberService.delete(member);
			addMessage(redirectAttributes, "删除用户会员成功");
		}catch (ZAException e) {
			e.printStackTrace();
			addMessage(redirectAttributes,e.getMessage());
		}
		return "redirect:/schools/schoolsMember/list?repage";
	}
	
	/**
	 * 查询会员信息
	 * @Author chaixueteng
	 * @2016年10月23日下午2:27:00
	 */
	@RequestMapping("checkStudent")
	@ResponseBody
	public Object checkStudent(HttpServletRequest request,HttpServletResponse response){
		String memberCode = request.getParameter("memberCode");
		return schoolsMemberService.checkStudent(memberCode);
	}
	
	/**
	 * 非本学校会员缴费列表
	 * @Author chaixueteng
	 * @2016年10月10日下午3:02:08
	 */
	@RequestMapping(value = "memberPay")
	public String memberPay(Member member,HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Member> page = memberService.findPage(new Page<Member>(request, response), member); 
		model.addAttribute("date", new Date());
		model.addAttribute("page", page);
		return "schools/mrschool/memberList";
	}
	
	/**
	 * 合作学校会员查询
	 * @Author chaixueteng
	 * @2017年6月28日下午6:49:13
	 */
	@RequestMapping(value = {"search"})
	public String search(Member member, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Member> page = new Page<Member>();
		if(member.getMemberCode() != null && member.getName() != null){
			page = memberService.findPage(new Page<Member>(request, response), member); 
		}
		model.addAttribute("page", page);
		return "schools/sys/memberSearch";
	}

	
	@RequestMapping(value = {"searchGroomer"})
	public String searchGroomer(Member member,String showCategory, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Member> page = new Page<>();
		if (Objects.equals(showCategory, "6") || Objects.equals(showCategory, "8")) {
			if (member.getMemberCode() != null) {
				page = memberService.findPage(new Page<>(request, response), member);
			}
			if(CollectionUtils.isEmpty(page.getList())) {
				page.setBusinessMessage("该会员不存在");
			} else {
				Member member1 = page.getList().get(0);
				if (member1.getGroomerEndDate() == null || member1.getGroomerEndDate().getTime() < new Date().getTime()) {
					page.setBusinessMessage("有效的美容会员才可报名!");
					page.getList().remove(member1);
				}
			}

		} else {
			// 登记人
			TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
			String name = trainingInstitution.getUser().getName();
			member.setRegistrant(name.trim());
			if (!"4".equals(showCategory)) {
				member.setGroomerCertificateFlag("groomer");
			}

			if (member.getMemberCode() != null && member.getName() != null) {
				page = memberService.findPage(new Page<>(request, response), member);
				if(CollectionUtils.isEmpty(page.getList())) {
					if (!"4".equals(showCategory)) {
						page.setBusinessMessage("该会员未在本校内获得结业证书，不能报名活动！");
					} else {
						page.setBusinessMessage("该会员非本校会员");
					}
				}
			}
		}

		model.addAttribute("page", page);
		model.addAttribute("showCategory", showCategory);
		return "schools/sys/groomerMemberSearch";
	}
	
	
	
	/**
	 * 会员注册十八周岁校验
	 * @throws ParseException 
	 * @Author chaixueteng
	 * @2017年7月7日下午2:13:37
	 */
	@RequestMapping(value="/ageCheck")
	@ResponseBody
	public String updateAddress(HttpServletRequest request, HttpServletResponse response) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		String age = request.getParameter("age");
		Date ageDate = sdf.parse(age);
		int age2 = AgeUtil.getAge(ageDate);
		if(age2>=18){
			return "{\"rc\":true}";
		}else{
			return "{\"rc\":false}";
		}
	}
}
