package com.cku.restful.v1.sys.web;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.dao.ExpressSendDao;
import com.cku.oa.sys.entity.ExpressSend;
import com.cku.oa.sys.entity.user.Member;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * t邮寄记录Controller
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/api/v1/expressSend")
public class RestExpressSendController extends BaseRestController {

    @Autowired
    private ExpressSendDao expressSendDao;

    @RequestMapping(value = "/getByKey", method = RequestMethod.GET)
    @ResponseBody
    public void getByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String key = request.getParameter("key");
        if (StringUtils.isBlank(key)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
        }
        JSONObject jo = new JSONObject();
        Member member = UserUtils.getLoginMember();
        ExpressSend expressSend = expressSendDao.getByMemberCodeAndContent(member.getMemberCode(), key);
        String expressName = "";
        String expressNo = "";
        if (expressSend != null) {
            expressName = DictUtils.getDictLabel(expressSend.getExpressName(), "express_name", "");
            //申通顺丰显示快递单号，其余不显示
            if ("shentong".equals(expressSend.getExpressName()) || "shunfeng".equals(expressSend.getExpressName())) {
                expressNo = expressSend.getExpressNo();
            }
        }
        jo.put("expressName", expressName);
        jo.put("expressNo", expressNo);
        ServletUtils.writeResponse(response, new RESTResponse("data", jo));
    }

}