package com.cku.restful.v1.sys.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.sys.dao.AssociationDao;
import com.cku.oa.sys.entity.Association;
import com.cku.restful.v1.sys.model.RestAssociation;
import com.cku.util.ServletUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 犬只协会Controller
 *
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "/api/v1/association")
public class RestAssociationController extends BaseRestController {

    @Autowired
    private AssociationDao associationDao;

    @RequestMapping(value = "", method = RequestMethod.GET)
    @ResponseBody
    public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String name = request.getParameter("name");
        Association example = new Association();
        if (StringUtils.isNotBlank(name)) {
            example.setName(name);
        }
        List<Association> result = associationDao.findList(example);
        List<RestAssociation> list = Lists.newArrayList();
        result.forEach(association -> {
            list.add(new RestAssociation(association));
        });
        Long totalCount = (long) list.size();
        ServletUtils.writeResponse(response, new RESTResponse("list",
                new PageBeanResult<RestAssociation>(list, totalCount)));
    }

}