/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.constant.Constants;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.cku.oa.handler.vo.HandlerRegisterVO;
import com.cku.restful.v1.groomer.model.RestGroomerShow;
import com.thinkgem.jeesite.common.utils.IdGen;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.handler.service.HandlerRegisterService;
import com.cku.oa.handler.service.HandlerShowService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.handler.model.RestHandlerRegister;
import com.cku.restful.v1.handler.model.RestHandlerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 报名Service
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class RestHandlerRegisterService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_A = "handler_register@A";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_B = "handler_register@B";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_C = "handler_register@C";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_SHOW = "handler_register@show";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_YAZHOU = "handler_register@YAZHOU";// 亚洲杯 牵犬师大赛

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_A = "handler_qualification_certificate@A";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_B = "handler_qualification_certificate@B";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_C = "handler_qualification_certificate@C";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_M = "handler_qualification_certificate@M";

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_ABC = "handler_register@PartnerExam";

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_MASTER = "handler_register@PartnerExamM";

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_MATCH_REG = "handler_register@PartnerMatch";

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_A = "handler_qualification_certificate@partnerDogA";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_B = "handler_qualification_certificate@partnerDogB";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_C = "handler_qualification_certificate@partnerDogC";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_M = "handler_qualification_certificate@partnerDogM";
	private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	@Autowired
	private HandlerRegisterService handlerRegisterService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private HandlerShowService handlerShowService;
	@Autowired
	private HandlerQualificationCertificateService handlerQualificationCertificateService;
	@Autowired
	private PaymentOrderService paymentOrderService;

	@Transactional(readOnly = false)
	public RESTResponse examinerRegisterPost(String json) {
		HandlerRegister vo = BeanUtil.toBean(json, HandlerRegister.class);
		// 参数校验
		HandlerRegister po = buildExaminerPo(vo);
		handlerRegisterService.validateExaminerBusiness(po);
		// 写入业务表
		handlerRegisterService.save(po);
		// 修改报名人数
		// handlerShowService.updateRegisterNum(po.getShowCode(), 1);
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		HandlerRegister vo = BeanUtil.toBean(json, HandlerRegister.class);
		// 参数校验
		validateParameter(vo, true);

		HandlerShow handlerShow = handlerShowService.getShow(vo.getShowCode());
		// 构造持久对象
		HandlerRegister po = buildPo(vo, handlerShow);
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			// 业务校验
			handlerRegisterService.validateBusiness(po, handlerShow, "app");
		} else {
			// 业务校验
			handlerRegisterService.validateBusiness(po, handlerShow);
		}
		// 写入业务表
		handlerRegisterService.save(po);
		String avatar = po.getAvatar();
		// 同步修改会员证件照为美容报名上传的图片 by zhuoHeng 2016年12月15日10:46:06
		Member member = UserUtils.getLoginMember();
		memberService.updateAvatar(avatar, member.getId());
		PaymentCart paymentCart;
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			paymentCart = buildTrainerPaymentCart(po);
			paymentCart = paymentCartService.addBusinessManage(paymentCart, "1210");// 所属业务类型
			String businessOrderCode = IdGen.uuid();
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1210");
		} else {
			// 写入购物车
			paymentCart = buildPaymentCart(po);
			paymentCartService.addToCart(paymentCart, "1052");
		}
		return new RESTResponse("data", paymentCart.getId());
	}

	@Transactional(readOnly = false)
	public RESTResponse handlerRegisterMatch(String json) {
		// 获取参数
		HandlerRegister vo = BeanUtil.toBean(json, HandlerRegister.class);
		// 参数校验
		validateParameter(vo, false);
		//查询活动
		HandlerShow handlerShow = handlerShowService.getShow(vo.getShowCode());
		// 构造持久对象
		HandlerRegister po = buildPo(vo, handlerShow);
		// 业务校验
		handlerRegisterService.validateBusiness(po, handlerShow);
		// 写入业务表
		handlerRegisterService.save(po);
		String avatar = po.getAvatar();
		if (StringUtils.isNotBlank(avatar)) {
			// 同步修改会员证件照为美容报名上传的图片 by zhuoHeng 2016年12月15日10:46:06
			Member member = UserUtils.getLoginMember();
			memberService.updateAvatar(avatar, member.getId());
		}
		// 写入购物车
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCartService.addToCart(paymentCart, "1052");
		return new RESTResponse("data", paymentCart.getId());
	}

	/**
	 *
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(HandlerRegister vo, boolean b) {
		if (StringUtils.isBlank(vo.getShowCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "赛事编号为空");
		}
		HandlerShow handlerShow = handlerShowService.getShow(vo.getShowCode());
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			if (StringUtils.isBlank(vo.getShowLevel())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别为空");
			}
			if (StringUtils.isBlank(vo.getAnyBreed())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "任意品种为空");
			}
		} else if (!"3".equals(handlerShow.getShowType())) {
			if (StringUtils.isBlank(vo.getShowLevel())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别为空");
			}
			if (b) {
				if (StringUtils.isBlank(vo.getAvatar())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛照片为空");
				}
			}
			if (b) {
				if (!"A".equals(vo.getShowLevel()) && !"B".equals(vo.getShowLevel()) && !"C".equals(vo.getShowLevel())
						&& !"none".equals(vo.getShowLevel())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参赛级别只能为A,B,C,无");
				}
			}
			if (!"1".equals(handlerShow.getShowType())) {

				if ("A".equals(vo.getShowLevel())) {
					if (StringUtils.isBlank(vo.getDesktopReviewerDog())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "桌面审查犬为空");
					}
					if (StringUtils.isBlank(vo.getFloorReviewerDog())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "地面审查犬为空");
					}
					if (StringUtils.isBlank(vo.getAnyBreed())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "任意品种为空");
					}
				}
				if ("B".equals(vo.getShowLevel())) {
					if (StringUtils.isBlank(vo.getDesktopReviewerDog())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "桌面审查犬为空");
					}
					if (StringUtils.isBlank(vo.getFloorReviewerDog())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "地面审查犬为空");
					}
				}
				if ("C".equals(vo.getShowLevel())) {
					if (StringUtils.isBlank(vo.getAnyBreed())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "任意品种为空");
					}
				}
			} else {
				if (StringUtils.isBlank(vo.getAnyBreed())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "任意品种为空");
				}
			}
		}
		if (!"12".equals(handlerShow.getShowType()) && !"13".equals(handlerShow.getShowType())) {
			if (b) {
				if (StringUtils.isBlank(vo.getSchoolNameCn())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训学校为空");
				}
			}
			if (!b) {// 校验cku证书号
				String do2g = vo.getShowDog().toLowerCase();
				if (do2g.contains("cku")) {
					// 查询并组装返回对象
					Dog dog = dogService.getByPedigreeCertifiedCode(vo.getShowDog());
					if (dog == null) {
						// 支持根据芯片号进行查询
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
					}
					if (!"0".equals(dog.getDogState())) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态非正常");
					}
					Calendar calendar = Calendar.getInstance();
					calendar.setTime(new Date());
					calendar.add(Calendar.YEAR, -1);
					Date oneYearBeforeDate = calendar.getTime();
					if (dog.getBirthdate().getTime() >= oneYearBeforeDate.getTime()) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄不足1岁");
					}
					DogType byDogBreedCode = dogTypeService.getByDogBreedCode(dog.getDogBreed());
					if (byDogBreedCode != null) {
						vo.setAnyBreed(byDogBreedCode.getBreedCnName());
					}
				}
			}
		}
	}

	/**
	 *
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private HandlerRegister buildPo(HandlerRegister vo, HandlerShow handlerShow) {
		Member member = UserUtils.getLoginMember();

		String shortName = "";
		if ("0".equals(handlerShow.getShowType())) {
			if ("A".equals(vo.getShowLevel())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
			} else if ("B".equals(vo.getShowLevel())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
			} else if ("C".equals(vo.getShowLevel())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
			}
		} else if ("1".equals(handlerShow.getShowType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_SHOW;
		} else if ("9".equals(handlerShow.getShowType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_YAZHOU;
		} else if ("12".equals(handlerShow.getShowType())) {
			if ("A".equals(vo.getShowLevel()) || "B".equals(vo.getShowLevel()) || "C".equals(vo.getShowLevel())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_ABC;
			} else if ("MASTER".equals(vo.getShowLevel())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_MASTER;
				handlerShow.setFee("500");
			}
		} else if ("13".equals(handlerShow.getShowType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_MATCH_REG;
		}
		if (StringUtils.isBlank(shortName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项为空！");
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		HandlerRegister po = new HandlerRegister();
		po.setRegisterCode(SysCodeUtil.getHandlerActivitySignCode("WB"));
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		po.setGender(member.getGender());
		po.setMobile(member.getMobile());
		po.setShowLevel(vo.getShowLevel());
		po.setSchoolNameCn(vo.getSchoolNameCn());

		po.setShowLeave("0");
		po.setLeaveCancel("0");
		po.setPaymentMemberCode(member.getMemberCode());
		po.setPaymentItemId(paymentChargingItem.getId());
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			po.setAnyBreed(vo.getAnyBreed());
			po.setFee(handlerShow.getFee());
			po.setOrderPrice(handlerShow.getFee());
		} else {
			po.setFee(paymentChargingItem.getPrice());
			po.setOrderPrice(paymentChargingItem.getPrice());
			if ("A".equals(vo.getShowLevel()) || "B".equals(vo.getShowLevel())) {
				po.setDesktopReviewerDog(vo.getDesktopReviewerDog());
				po.setFloorReviewerDog(vo.getFloorReviewerDog());
			}
			if ("A".equals(vo.getShowLevel()) || "C".equals(vo.getShowLevel())) {
				po.setAnyBreed(vo.getAnyBreed());
			}
			if ("none".equals(vo.getShowLevel())) {
				po.setAnyBreed(vo.getAnyBreed());
			}
			if ("预职业组".equals(vo.getShowLevel()) || "专业选手组".equals(vo.getShowLevel())) {
				po.setAnyBreed(vo.getAnyBreed());
				po.setShowDog(vo.getShowDog());
			}
		}
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProccessState("0");
		po.setAvatar(vo.getAvatar());
		po.setShowCode(handlerShow.getShowCode());
		return po;
	}

	private PaymentCart buildPaymentCart(HandlerRegister po) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentItemId());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("handler_register");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	/**
	 * 资格证书在线申领列表
	 * 
	 * @Author chaixueteng
	 * @2016年9月22日下午3:32:09
	 */
	public RESTResponse certificateList(HttpServletRequest request, String handlerShowType) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String registerCode = request.getParameter("registerCode");
		String showName = request.getParameter("showName");
		String showAddress = request.getParameter("showAddress");
		String showLevel = request.getParameter("showLevel");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		HandlerRegister register = new HandlerRegister();
		// 设置分页参数
		Page<HandlerRegister> page = new Page<HandlerRegister>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		String memberCode = member.getMemberCode();
		register.setMemberCode(memberCode);
		HandlerShow handlerShow = new HandlerShow();
		handlerShow.setShowType("0");
		register.setHandlerShow(handlerShow);
		register.setDelFlag("0");
		register.setPage(page);
		if (StringUtils.isNotBlank(registerCode)) {
			register.setRegisterCode(registerCode);
		}
		if (StringUtils.isNotBlank(showName)) {
			handlerShow.setShowName(showName);
		}
		if (StringUtils.isNotBlank(showAddress)) {
			handlerShow.setShowAddress(showAddress);
		}
		if (StringUtils.isNotBlank(showLevel)) {
			register.setShowLevel(showLevel);
		}
		register.setHandlerShowType(handlerShowType);
		Page<HandlerRegister> result = handlerRegisterService.findPage(page, register);
		List<HandlerRegister> findList = result.getList();
		List<RestHandlerRegister> list = new ArrayList<RestHandlerRegister>();
		for (HandlerRegister handlerRegister : findList) {
			if (StringUtils.isNotBlank(handlerRegister.getGrade())) {
				RestHandlerRegister vo = new RestHandlerRegister();
				RestHandlerShow restHandlerShow = new RestHandlerShow();
				BeanUtil.copyProperties(vo, handlerRegister, "yyyy-MM-dd HH:mm");
				vo.setGender(DictUtils.getDictLabel(handlerRegister.getGender(), "user_gender", ""));
				vo.setShowLevel(DictUtils.getDictLabel(handlerRegister.getShowLevel(), "groomer_test_level", ""));
				vo.setGrade(DictUtils.getDictLabel(handlerRegister.getGrade(), "handler_grade", ""));
				HandlerQualificationCertificate hqc = handlerQualificationCertificateService
						.getRegister(handlerRegister.getId());
				if (hqc == null) {
					vo.setPaymentState("3");
				} else {
					vo.setPaymentState(hqc.getPaymentState());
				}
				String levelEn = handlerRegister.getShowLevel();
				String shortName = "";
				HandlerShow registerHandlerShow = handlerRegister.getHandlerShow();
				if ("12".equals(registerHandlerShow.getShowType())) {
					if ("A".equals(levelEn)) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_A;
					} else if ("B".equals(levelEn)) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_B;
					} else if ("C".equals(levelEn)) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_C;
					} else if ("MASTER".equals(levelEn)) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_M;
					}
					vo.setShortName(shortName);
				}
				String handlerShowName = StringEscapeUtils.unescapeHtml4(registerHandlerShow.getShowName());
				restHandlerShow.setShowName(handlerShowName);
				restHandlerShow.setShowAddress(handlerShowName);
				dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));// 设置成东八区时间
				//机器时间
				restHandlerShow.setCurrentTime(dateFormat.format(new Date()));
				vo.setRestHandlerShow(restHandlerShow);
				list.add(vo);
			}
		}
		long count = list.size();
		return new RESTResponse("list", new PageBeanResult<RestHandlerRegister>(list, count));
	}

	/**
	 * 报名校验
	 * 
	 * @Author chaixueteng
	 * @2016年9月22日下午2:48:17
	 */
	public RESTResponse apply(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		String showCode = request.getParameter("showCode");
		HandlerShow show = handlerShowService.getShow(showCode);
		if (Objects.isNull(show)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动有误，请联系工作人员!");
		}
		Map<String, Object> memberMessage = handlerRegisterService.getMemberMessage(member.getMemberCode(),
				show.getTestLevel(), show.getId());
		memberMessage.put("referee", show.getReferee());
		return new RESTResponse("data", JSONObject.fromObject(memberMessage));
	}

	/**
	 * 牵犬师大赛报名校验
	 * 
	 * @Author chaixueteng
	 * @2016年9月22日下午2:48:17
	 */
	public RESTResponse applyMatch(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		String id = request.getParameter("id");
		Map<String, Object> memberMessage = handlerRegisterService.validApple(member.getMemberCode(), id);
		return new RESTResponse("data", JSONObject.fromObject(memberMessage));
	}

	private HandlerRegister buildExaminerPo(HandlerRegister vo) {
		Member member = UserUtils.getLoginMember();
		HandlerShow handlerShow = handlerShowService.getShow(vo.getShowCode());
		HandlerRegister po = new HandlerRegister();
		po.setRegisterCode(SysCodeUtil.getHandlerActivitySignCode("WB"));
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		po.setGender(member.getGender());
		po.setMobile(member.getMobile());
		po.setShowLevel(vo.getShowLevel());
		po.setSchoolNameCn("无");
		po.setFee(handlerShow.getFee());
		po.setShowLeave("0");
		po.setLeaveCancel("0");
		// po.setOrderPrice(paymentChargingItem.getPrice());
		// po.setPaymentMemberCode(member.getMemberCode());
		// po.setPaymentItemId(paymentChargingItem.getId());
//		if ("A".equals(vo.getShowLevel()) || "B".equals(vo.getShowLevel())) {
//			po.setDesktopReviewerDog(vo.getDesktopReviewerDog());
//			po.setFloorReviewerDog(vo.getFloorReviewerDog());
//		}
//		if ("A".equals(vo.getShowLevel()) || "C".equals(vo.getShowLevel())) {
//			po.setAnyBreed(vo.getAnyBreed());
//		}
//		if ("none".equals(vo.getShowLevel())) {
//			po.setAnyBreed(vo.getAnyBreed());
//		}
//		if ("预职业组".equals(vo.getShowLevel()) || "专业选手组".equals(vo.getShowLevel())) {
//			po.setAnyBreed(vo.getAnyBreed());
//			po.setShowDog(vo.getShowDog());
//		}
		po.setReviewState("1");
		po.setPaymentState("2");
		po.setProccessState("0");
		po.setAvatar(vo.getAvatar());
		po.setShowCode(handlerShow.getShowCode());
		po.setShowGroup(vo.getShowGroup());
		return po;
	}

	/**
	 * 资格证书在线申领
	 * 
	 * @Author chaixueteng
	 * @2016年9月29日下午3:58:07
	 */
	@SuppressWarnings("unused")
	@Transactional(readOnly = false)
	public RESTResponse receiveCertificate(String id) {
		Member member = UserUtils.getLoginMember();
		HandlerRegister handlerRegister = handlerRegisterService.get(id);
		if (Objects.isNull(handlerRegister)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "报名信息异常!");
		}
		HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
		if (Objects.isNull(handlerShow)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动信息有误,请联系工作人员!");
		}
		HandlerQualificationCertificate gqc = handlerQualificationCertificateService.getRegister(id);
		if (gqc == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "信息有误,请联系管理员!");
		} else if ("2".equals(gqc.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "资格证书已经申领,请勿重复申领!");
		}
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			if (!MemberUtil.isCkuActiveMember(member)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU会员无效！");
			}
		} else {
			if (!MemberUtil.isActiveMember(member)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效！");
			}
		}
		if ("MASTER".equals(gqc.getCertificateLevelEn().trim())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "教师级请联系业务部门办理申领!");
		}

		Date gradeTime = handlerRegister.getGradeTime();
		Calendar calendar = Calendar.getInstance();// 日历对象
		calendar.setTime(gradeTime);// 设置当前日期
		if ("12".equals(handlerShow.getShowType())) {
			calendar.add(Calendar.DATE, 60);// 天数+60
		} else {
			calendar.add(Calendar.DATE, 180);// 天数+180
		}
		long timeInMillis = calendar.getTimeInMillis();
		long time = new Date().getTime();
		if (timeInMillis < time) {// 超过180未申领 资格证书为过期
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "资格证书已经过期,请联系业务部门处理!");
		}
		// 加入购物车
		String levelEn = gqc.getCertificateLevelEn();
		String shortName = "";
		if ("12".equals(handlerShow.getShowType())) {
			if ("A".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_A;
			} else if ("B".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_B;
			} else if ("C".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_C;
			} else if ("MASTER".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_PARTNER_M;
			}
		} else {
			if ("A".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_A;
			} else if ("B".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_B;
			} else if ("C".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_C;
			} else if ("MASTER".equals(levelEn)) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_HQC_M;
			}
		}
		List<PaymentCart> paymentCartList = paymentCartService.getMyCart(true);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		for (PaymentCart paymentCart : paymentCartList) {
			if (paymentChargingItem.getId().equals(paymentCart.getChargingItemId())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车已有订单，请勿重复提交");
			}
		}

		PaymentOrderDetail paymentOrderDetail = new PaymentOrderDetail();
		paymentOrderDetail.setMemberCode(member.getMemberCode());
		paymentOrderDetail.setChargingItemId(paymentChargingItem.getId());
		List<PaymentOrderDetail> validOrder = paymentOrderDetailDao.validOrder(paymentOrderDetail);
		if (validOrder.size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有订单，请勿重复提交");
		}
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("handler_qualification_certificate");
		paymentCart.setBusinessIds(gqc.getId());
		// 添加购物车
		if ("12".equals(handlerShow.getShowType()) || "13".equals(handlerShow.getShowType())) {
			paymentCartService.addToCart(paymentCart, "1211");
		} else {
			paymentCartService.addToCart(paymentCart, "1054");
		}
		return new RESTResponse("data", paymentCart.getId());
	}

	public RESTResponse getExaminerHandlerRegister(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		List<HandlerRegister> list = new ArrayList<>();
		List<RestHandlerRegister> restList = new ArrayList<RestHandlerRegister>();
		if (member != null) {
			list = handlerRegisterService.getExaminerHandlerRegister(member.getMemberCode());
			for (HandlerRegister handlerRegister : list) {
				RestHandlerRegister vo = new RestHandlerRegister();
				RestHandlerShow restHandlerShow = new RestHandlerShow();
				BeanUtil.copyProperties(vo, handlerRegister, "yyyy-MM-dd HH:mm");
				vo.setGender(DictUtils.getDictLabel(handlerRegister.getGender(), "user_gender", ""));
				vo.setShowLevel(
						DictUtils.getDictLabel(handlerRegister.getShowLevel(), "10".equals(handlerRegister.getHandlerShow().getShowType())?"handler_test_level_examiner":"groomer_examiner_course_level", ""));

				vo.setGrade(DictUtils.getDictLabel(handlerRegister.getGrade(), "Grade", ""));
				vo.setPaymentState("2");
			
				HandlerShow handlerShow = handlerShowService.getShow(handlerRegister.getShowCode());
				Integer max = 0, registerNum = 0;
				if (null != handlerShow.getMaxNumber()) {
					max = handlerShow.getMaxNumber();
				}
				if (null != handlerShow.getRegisterNumber()) {
					registerNum = handlerShow.getRegisterNumber();
				}
				if ((handlerShow.getRegisterEndTime().after(new Date()) && max > registerNum)) {
					if (vo.getReviewState().equals("3")) {
						vo.setReviewState("已取消");
					}
					if (vo.getReviewState().equals("1")) {
						vo.setReviewState("已报名");
					}
				} else {
					vo.setReviewState("已结束");
				}
				restHandlerShow.setShowName(handlerRegister.getHandlerShow().getShowName());
				restHandlerShow.setShowAddress(handlerRegister.getHandlerShow().getShowName());
				restHandlerShow.setShowType(DictUtils.getDictLabel(handlerRegister.getHandlerShow().getShowType(),
						"handler_show_type", ""));
				restHandlerShow.setTestLevel(handlerRegister.getHandlerShow().getTestLevel());
				vo.setRestHandlerShow(restHandlerShow);
				vo.setShowGroup(handlerRegister.getShowGroup());
				
				if(StringUtils.isNotBlank(handlerRegister.getShowGroup())) {
					List<Dict> groups = DictUtils.getDictListValues("handler_show_group", handlerRegister.getShowGroup());
					String groupDesc = "";
					for(Dict dict : groups) {
						groupDesc += dict.getLabel() + ",";
					} 
					vo.setShowGroupDesc(groupDesc.endsWith(",") ? groupDesc.substring(0, groupDesc.length()-1) : groupDesc );
				}
				vo.setAvatar(member.getAvatar());
				restList.add(vo);
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
		}
		return new RESTResponse("list", restList);
	}

	/**
	 *
	 * @Description：：获取培训报名历史数据（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:21:16
	 */
	public RESTResponse getHandlerRegister(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		List<HandlerRegister> list = new ArrayList<>();
		List<RestHandlerRegister> restList = new ArrayList<RestHandlerRegister>();
		if (member != null) {
			list = handlerRegisterService.getHandlerRegister(member.getMemberCode());
			for (HandlerRegister handlerRegister : list) {
				RestHandlerRegister vo = new RestHandlerRegister();
				RestHandlerShow restHandlerShow = new RestHandlerShow();
				BeanUtil.copyProperties(vo, handlerRegister, "yyyy-MM-dd HH:mm");
				vo.setGender(DictUtils.getDictLabel(handlerRegister.getGender(), "user_gender", ""));
				vo.setShowLevel(DictUtils.getDictLabel(handlerRegister.getShowLevel(), "groomer_test_level", ""));
				vo.setGrade(DictUtils.getDictLabel(handlerRegister.getGrade(), "handler_grade", ""));
				HandlerQualificationCertificate hqc = handlerQualificationCertificateService
						.getRegister(handlerRegister.getId());
				if (hqc == null) {
					vo.setPaymentState("2");
				} else {
					vo.setPaymentState(hqc.getPaymentState());
				}
				vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));

				String showName = StringEscapeUtils.unescapeHtml4(handlerRegister.getHandlerShow().getShowName());
				restHandlerShow.setShowName(showName);
				restHandlerShow.setShowAddress(showName);
				restHandlerShow.setShowType(DictUtils.getDictLabel(handlerRegister.getHandlerShow().getShowType(),
						"handler_show_type", ""));
				vo.setRestHandlerShow(restHandlerShow);
				vo.setAvatar(member.getAvatar());
				restList.add(vo);
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
		}
		return new RESTResponse("list", restList);
	}

	@Transactional(readOnly = false)
	public RESTResponse resetExaminerReviewState(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		String id = ServletUtils.getParameter(request, "id");
		HandlerRegister model = handlerRegisterService.get(id);
		if (model == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未匹配到有效记录！");
		} else if (!member.getMemberCode().equals(model.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请人与登录会员不一致！");
		}
		handlerRegisterService.changeExaminerReviewState(id);
		// 修改报名人数
		handlerShowService.updateRegisterNum(model.getShowCode() , -1);
		return new RESTResponse();
	}
	
	/**
	 *
	 * @Description：更改个人证件照并重置培训报名审核状态（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月15日 上午10:08:22
	 */
	@Transactional(readOnly = false)
	public RESTResponse resetReviewState(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		String avatar = ServletUtils.getParameter(request, "avatar");
		String id = ServletUtils.getParameter(request, "id");
		HandlerRegister model = handlerRegisterService.get(id);
		if (model == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "未匹配到有效记录！");
		} else if (!member.getMemberCode().equals(model.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请人与登录会员不一致！");
		}
		if ("2".equals(model.getReviewState())) {
			handlerRegisterService.changeReviewState(id);
			memberService.updateAvatar(avatar, member.getId());
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前审核状态下的数据不允许被更改！");
		}
		return new RESTResponse();
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月10日 下午4:25:56
	 */
	public RESTResponse orderDetail(String id) {
		HandlerRegister model = handlerRegisterService.get(id);
		Map<String, String> map = new HashMap<>();
		map.put("key1", model.getShowLevel());
		map.put("key2", model.getDesktopReviewerDog());
		map.put("key3", model.getFloorReviewerDog());
		map.put("key4", model.getAnyBreed());
		map.put("key5", model.getName());
		map.put("key6", model.getMemberCode());
		// map.put("key7",model.getReferee());
		map.put("key8", model.getSchoolNameCn());
		map.put("key9", model.getHandlerShow().getShowType());
		return new RESTResponse("data", map);
	}

	/**
	 *
	 * @Description：：获取培训报名历史数据（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:21:16
	 */
	public RESTResponse getHandlerTrainerRegister(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		List<HandlerRegister> list = new ArrayList<>();
		List<RestHandlerRegister> restList = new ArrayList<RestHandlerRegister>();
		if (member != null) {
			list = handlerRegisterService.getHandlerTrainerRegister(member.getMemberCode());

			// 查询有没有退款或退款中
			Map<String, String> map = paymentOrderService
					.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
			List<HandlerRegisterVO> list2 = list.stream().map(a -> {
				HandlerRegisterVO b = new HandlerRegisterVO();
				BeanUtils.copyProperties(a, b);
				b.setBusinessRefundState(map.keySet().contains(a.getId()));
				return b;
			}).collect(Collectors.toList());

			for (HandlerRegisterVO handlerRegister : list2) {
				RestHandlerRegister vo = new RestHandlerRegister();
				RestHandlerShow restHandlerShow = new RestHandlerShow();
				BeanUtil.copyProperties(vo, handlerRegister, "yyyy-MM-dd HH:mm");
				vo.setGender(DictUtils.getDictLabel(handlerRegister.getGender(), "user_gender", ""));
				vo.setShowLevel(DictUtils.getDictLabel(handlerRegister.getShowLevel(), "groomer_test_level", ""));
				vo.setGrade(DictUtils.getDictLabel(handlerRegister.getGrade(), "Grade", ""));
				HandlerQualificationCertificate hqc = handlerQualificationCertificateService
						.getRegister(handlerRegister.getId());
				if (hqc == null) {
					vo.setPaymentState("2");
				} else {
					vo.setPaymentState(hqc.getPaymentState());
				}
				vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));

				String showName = StringEscapeUtils.unescapeHtml4(handlerRegister.getHandlerShow().getShowName());
				restHandlerShow.setShowName(showName);
				restHandlerShow.setShowAddress(showName);
				restHandlerShow.setShowType(DictUtils.getDictLabel(handlerRegister.getHandlerShow().getShowType(),
						"handler_show_type", ""));
				vo.setRestHandlerShow(restHandlerShow);
				vo.setAvatar(member.getAvatar());
				String levelEn = handlerRegister.getShowLevel();
				String shortName = "";
				HandlerShow registerHandlerShow = handlerRegister.getHandlerShow();
				if ("12".equals(registerHandlerShow.getShowType()) ) {
					if ("A".equals(levelEn) || "B".equals(levelEn)  || "C".equals(levelEn) ) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_ABC;
					} else if ("MASTER".equals(levelEn)) {
						shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_EXAM_MASTER;
					}
					vo.setShortName(shortName);
				} else if ("13".equals(registerHandlerShow.getShowType())) {
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_PARTNER_MATCH_REG;
					vo.setShortName(shortName);
				}
				vo.setBusinessRefundState(handlerRegister.isBusinessRefundState());
				restList.add(vo);
			}
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
		}
		return new RESTResponse("list", restList);
	}

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {
		HandlerRegister handlerRegister = new HandlerRegister();
		handlerRegister.setDelFlag("0");
		handlerRegister.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		handlerRegister.setId(ids);
		List<HandlerRegister> handlerRegisterServiceList = handlerRegisterService.findList(handlerRegister);
		StringBuffer sb = new StringBuffer();
		handlerRegisterServiceList.stream().forEach(i -> sb.append("'" + i.getShowCode() + "'").append(","));
		if (sb.length() > 0)
			sb.deleteCharAt(sb.length() - 1);
		List<RestHandlerShow> list = new ArrayList<>();
		if (com.thinkgem.jeesite.common.utils.StringUtils.isNotEmpty(sb)) {
			HandlerShow example = new HandlerShow();
			example.setDelFlag("0");
			example.setShowCodesText(String.valueOf(sb));
			List<HandlerShow> groomerShowList = handlerShowService.findList(example);
			for (HandlerShow handlerShow : groomerShowList) {
				RestHandlerShow vo = new RestHandlerShow();
				vo.setReviewStateCode("0");
				BeanUtil.copyProperties(vo, handlerShow, "yyyy-MM-dd HH:mm");
				vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "handler_show_type", ""));
				vo.setId(handlerRegisterServiceList.stream().filter(i -> i.getShowCode().equals(vo.getShowCode())).findFirst().get().getId());
				list.add(vo);
			}
		}
		return new RESTResponse("data", list);
	}

	private PaymentCart buildTrainerPaymentCart(HandlerRegister po) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentItemId());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(po.getOrderPrice());
		paymentCart.setTotalPrice(po.getOrderPrice());
		paymentCart.setBusinessTable("handler_register");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}
}