package com.cku.restful.v1.dog.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogPedigreeCertifiedRedoDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogPedigreeCertifiedRedoService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.restful.v1.dog.model.RestDogPedigreeCertifiedRedo;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 证书补做Service
 *
 * @author lgl
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestDogPedigreeCertifiedRedoService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_pedigree_certified_redo@All";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_pedigree_certified_redo@Zangao";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZERO= "dog_pedigree_certified_redo@Zero";

	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private DogPedigreeCertifiedRedoDao dogPedigreeCertifiedRedoDao;
    /**
     * 申请退款数据
     *
     * @param ids
     * @return
     */
    public RESTResponse getRefundList(String ids) {
        DogPedigreeCertifiedRedo example = new DogPedigreeCertifiedRedo();
        example.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
        example.setId(ids);
        example.setDelFlag("0");
        List<DogPedigreeCertifiedRedo> dogChipList = dogPedigreeCertifiedRedoService.findList(example);
        List<RestDogPedigreeCertifiedRedo> list = new ArrayList<RestDogPedigreeCertifiedRedo>();
        for (DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo : dogChipList) {
            RestDogPedigreeCertifiedRedo vo = new RestDogPedigreeCertifiedRedo();
            BeanUtil.copyProperties(vo, dogPedigreeCertifiedRedo, "yyyy-MM-dd");
            vo.setReviewStateCode(vo.getReviewState());
            vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "dog_pedigree_certified_redo_review_state", ""));
            vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(), "proccess_state", ""));
            list.add(vo);
        }
        return new RESTResponse("data", list);
    }

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String originalPedigreeCertified = request
				.getParameter("originalPedigreeCertified");
		String changeType = request.getParameter("changeType");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		DogPedigreeCertifiedRedo example = new DogPedigreeCertifiedRedo();
		//根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if(StringUtils.isBlank(example.getDogBreed())){
    		//根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
    	}else{
    		example.getSqlMap().put("dogBreedMap", " ='"+example.getDogBreed()+"'");
    	}
		// 设置分页参数
		Page<DogPedigreeCertifiedRedo> page = new Page<DogPedigreeCertifiedRedo>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setPage(page);
		if (StringUtils.isNotBlank(originalPedigreeCertified)) {
			example.setOriginalPedigreeCertified(originalPedigreeCertified);
		}
		if (StringUtils.isNotBlank(changeType)) {
			example.setChangeType(changeType);
		}
		// 查询并组装返回对象
		Page<DogPedigreeCertifiedRedo> result = dogPedigreeCertifiedRedoService
				.findPage(page, example);
		List<DogPedigreeCertifiedRedo> dogChipList = result.getList();
		List<RestDogPedigreeCertifiedRedo> list = new ArrayList<RestDogPedigreeCertifiedRedo>();
		for (DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo : dogChipList) {
			RestDogPedigreeCertifiedRedo vo = new RestDogPedigreeCertifiedRedo();
			BeanUtil.copyProperties(vo, dogPedigreeCertifiedRedo, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(),"dog_pedigree_certified_redo_review_state", ""));
			vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(),"proccess_state", ""));
//			if ("0".equals(dogPedigreeCertifiedRedo.getDelFlag())) {
//				if ("1".equals(vo.getReviewState())) {
//					vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(),"proccess_state", ""));
//				}else if("0".equals(vo.getReviewState())){
//					vo.setProcessState("");
//				}else if("2".equals(vo.getReviewState())){
//					vo.setProcessState("已撤销");
//				}else{
//					vo.setProcessState("撤销");
//				}
//			} else {
//				vo.setProcessState("已撤销");
//			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list",
				new PageBeanResult<RestDogPedigreeCertifiedRedo>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse delete(String id) {
		Member member = UserUtils.getLoginMember();
		DogPedigreeCertifiedRedo po = dogPedigreeCertifiedRedoService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		//已处理不能撤销
		if("1".equals(po.getProcessState())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该证书补做已处理，不允许撤销");
		}
		dogPedigreeCertifiedRedoService.delete(po);
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		DogPedigreeCertifiedRedo vo = BeanUtil.toBean(json,
				DogPedigreeCertifiedRedo.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		DogPedigreeCertifiedRedo po = buildPo(vo);
		// 业务校验
		dogPedigreeCertifiedRedoService.validateBusiness(po);
		// 写入业务表
		dogPedigreeCertifiedRedoService.save(po);
		// 写入购物车
        String businessOrderCode = IdGen.uuid();
        PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
        paymentCartService.addToCart(paymentCart, "1006");
        return new RESTResponse("data", paymentCart.getId());
	}

	/**
	 *
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(DogPedigreeCertifiedRedo vo) {
		if (StringUtils.isBlank(vo.getDogId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id为空");
		}
		if (StringUtils.isBlank(vo.getChangeType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "变更类型为空");
		}
		if (!"1".equals(vo.getChangeType()) && !"2".equals(vo.getChangeType())
				&& !"3".equals(vo.getChangeType()) && !"4".equals(vo.getChangeType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "变更类型只能为变更、丢失、登录、纸质证书补做");
		}
	}

	/**
	 *
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private DogPedigreeCertifiedRedo buildPo(DogPedigreeCertifiedRedo vo) {
		DogPedigreeCertifiedRedo po = new DogPedigreeCertifiedRedo();
		Dog dog = dogService.get(vo.getDogId());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该血统证书号有误");
		}
		po.setDogId(dog.getId());
		po.setOriginalPedigreeCertified(dog.getPedigreeCertifiedCode());
		po.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		po.setReviewState("0");
		po.setProcessState("0");
		po.setPaymentState("1");
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		if(vo.getChangeType().equals("4")){
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZERO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		po.setPrice(paymentChargingItem.getPrice());
		po.setChangeType(vo.getChangeType());
		po.setCallName(vo.getCallName());
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(vo.getStickerFlag())) {
//			po.setStickerFlag("1");
//		}
		po.setStickerFlag("0");
		return po;
	}

    private PaymentCart buildPaymentCart(DogPedigreeCertifiedRedo po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		Dog dog = dogService.get(po.getDogId());
		if ("230".equals(dog.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		//字质证书补做 0元收费
		if(po.getChangeType().equals("4")){
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZERO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName("证书"
				+ DictUtils.getDictLabel(po.getChangeType(),
						"dog_pedigree_certified_redo_type",
						paymentChargingItem.getName()));
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_pedigree_certified_redo");
		paymentCart.setBusinessIds(po.getId());
        paymentCart.setBusinessOrderCode(businessOrderCode);
        return paymentCartService.addBusinessManage(paymentCart, "1006");
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String dogId = request.getParameter("dogId");
		if (StringUtils.isBlank(dogId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id为空");
		}
		Dog dog = dogService.get(dogId);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬id有误");
		}
		// 获取价格
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		DogPedigreeCertifiedRedo changeType = dogPedigreeCertifiedRedoDao.getByDogIdChangeType(dogId);
		if(Objects.nonNull(changeType) &&  "4".equals(changeType.getChangeType())){
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZERO;
		}else{
			if ("230".equals(dog.getDogBreed())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
			}
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		JSONObject jo = new JSONObject();
		jo.put("price", paymentChargingItem.getPrice());
		return new RESTResponse("data", jo);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 下午1:56:47
	 */
	public RESTResponse orderDetail(String id) {
		DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = dogPedigreeCertifiedRedoService.get(id);
		Map<String, String> map = new HashMap<>();
		if(Objects.nonNull(dogPedigreeCertifiedRedo) && StringUtils.isNotBlank(dogPedigreeCertifiedRedo.getDogId())) {
			Dog dog = dogService.get(dogPedigreeCertifiedRedo.getDogId());
			DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
			SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
			map.put("key1", "犬主人："+dog.getDogOwner());
			map.put("key2", "会员号："+dog.getMemberCode());
			map.put("key3", "犬名："+dog.getNameEn());
			String breedCnName = "";
			if(dogType==null){
				breedCnName = dogTypeService.getUnMapBreedCnName(dog.getDogBreed());
			}else{
				breedCnName = dogType.getBreedCnName();
			}
			map.put("key4", "犬种："+breedCnName);
			map.put("key5", "登记卡编号："+dog.getBirthCertificateLevelCode());
			if(dog.getBirthdate()!=null&&!"".equals(dog.getBirthdate())){
				map.put("key6", "出生日期："+sdf.format(dog.getBirthdate()));
			} else {
				map.put("key6", "出生日期：");
			}
			map.put("key7", "性别："+DictUtils.getDictLabel(dog.getGender(), "dog_gender", ""));
			map.put("key8", "毛色："+dog.getColorFlag());
		}
		return new RESTResponse("data",map);
	}

    public RESTResponse checkCallName(HttpServletRequest request) {
		String callName = request.getParameter("callName");
		if(StringUtils.isBlank(callName)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "呼名为空");
		}
		demandSensitiveWordService.validCallName(callName);
		return new RESTResponse();
    }
}
