package com.cku.restful.v1.contest.service;

import com.cku.core.PageBeanResult;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.contest.entity.*;
import com.cku.oa.contest.service.*;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.restful.v1.contest.model.*;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

/**
 * @author yuanshuai
 */
@Service
@Transactional(readOnly = true)
public class RestCkuContestService {

	@Autowired
	public MainShowsDao mainShowsDao;
	@Autowired
	public ChildShowsDao childShowsDao;
	@Autowired
	public ShowApplyService showApplyService;
	@Autowired
	public ContestExhibitService contestExhibitService;
	@Autowired
	public ContestWinnerService contestWinnerService;
	@Autowired
	public ContestBreedService contestBreedService;
	@Autowired
	private ContestJudgeTypeClassService contestJudgeTypeClassService;
	@Autowired
	public ContestClassService contestClassService;
	@Autowired
	public ContestCriticService contestCriticService;
	@Autowired
	public ContestGradeDisqualifiedService contestGradeDisqualifiedService;
	@Autowired
	public ContestGradeService contestGradeService;
	@Autowired
	public LanguageService languageService;

	public static final String CONTEST_MAIN = "main";
	public static final String CONTEST_CHILD = "child";

	/**
	 * @Description 犬种列表
	 * @author yuanshuai
	 * @date 2020/11/4 16:06
	 */
	public PageBeanResult<RestContestBreed> getBreedList() {
		List<ContestBreed> breedList = contestBreedService.findList(new ContestBreed());
		List<RestContestBreed> restList = Lists.newArrayList();
		for (ContestBreed contestBreed : breedList) {
			RestContestBreed rest = new RestContestBreed(contestBreed);
			restList.add(rest);
		}
		return new PageBeanResult<>(restList);
	}

	/**
	 * @Description 设置，字典信息
	 * @author yuanshuai
	 * @date 2020/11/4 16:06
	 */
	public RestContestSetting getSettingData(HttpServletRequest request) {
		RestContestSetting setting = new RestContestSetting();
		//赛事信息
		String mainShowId = request.getParameter("contest_event_no");
		if (!StringUtils.isBlank(mainShowId)) {
			List<ChildShows> childShowsList = childShowsDao.getByMainShowId(mainShowId);
			List<RestContest> restContestList = convertRestList(childShowsList);
			setting.getContest().setItems(restContestList);
			setting.getContest().setTotal(String.valueOf(restContestList.size()));
		}
		//年龄组别字典
		List<ContestClass> contestClassList = contestClassService.findList(new ContestClass());
		List<RestContestClass> restContestClassList = Lists.newArrayList();
		for (ContestClass data : contestClassList) {
			RestContestClass rest = new RestContestClass(data);
			restContestClassList.add(rest);
		}
		setting.getContest_class().setItems(restContestClassList);
		setting.getContest_class().setTotal(String.valueOf(restContestClassList.size()));
		//评价字典
		List<ContestGrade> contestGradeList = contestGradeService.findList(new ContestGrade());
		List<RestContestGrade> restContestGradeList = Lists.newArrayList();
		for (ContestGrade data : contestGradeList) {
			RestContestGrade rest = new RestContestGrade(data);
			restContestGradeList.add(rest);
		}
		setting.getContest_grade().setItems(restContestGradeList);
		setting.getContest_grade().setTotal(String.valueOf(restContestGradeList.size()));
		//赛制字典
		List<ContestJudgeTypeClass> contestJudgeTypeClassList = contestJudgeTypeClassService.findList(new ContestJudgeTypeClass());
		List<RestContestJudgeTypeClass> restContestJudgeTypeClassList = Lists.newArrayList();
		for (ContestJudgeTypeClass data : contestJudgeTypeClassList) {
			RestContestJudgeTypeClass rest = new RestContestJudgeTypeClass(data);
			restContestJudgeTypeClassList.add(rest);
		}
		setting.getJudge_type_class().setItems(restContestJudgeTypeClassList);
		setting.getJudge_type_class().setTotal(String.valueOf(restContestJudgeTypeClassList.size()));
		//失格评价字典
		List<ContestGradeDisqualified> contestGradeDisqualifiedList = contestGradeDisqualifiedService.findList(new ContestGradeDisqualified());
		List<RestContestGradeDisqualified> restContestGradeDisqualifiedList = Lists.newArrayList();
		for (ContestGradeDisqualified data : contestGradeDisqualifiedList) {
			RestContestGradeDisqualified rest = new RestContestGradeDisqualified(data);
			restContestGradeDisqualifiedList.add(rest);
		}
		setting.getContest_grade_disqualified().setItems(restContestGradeDisqualifiedList);
		setting.getContest_grade_disqualified().setTotal(String.valueOf(restContestGradeDisqualifiedList.size()));
		//失格部位字典
		List<ContestCritic> contestCriticList = contestCriticService.findList(new ContestCritic());
		List<RestContestCritic> restContestCriticList = Lists.newArrayList();
		for (ContestCritic data : contestCriticList) {
			RestContestCritic rest = new RestContestCritic(data);
			restContestCriticList.add(rest);
		}
		setting.getContest_critic().setItems(restContestCriticList);
		setting.getContest_critic().setTotal(String.valueOf(restContestCriticList.size()));
		//语言字典
		List<Language> languageList = languageService.findList(new Language());
		List<RestLanguage> restLanguageList = Lists.newArrayList();
		for (Language data : languageList) {
			RestLanguage rest = new RestLanguage(data);
			restLanguageList.add(rest);
		}
		setting.getLanguage().setItems(restLanguageList);
		setting.getLanguage().setTotal(String.valueOf(restLanguageList.size()));
		return setting;
	}

	/**
	 * @Description： 赛事列表转成接口用数据
	 * @author: yuanshuai
	 * @date: 2020/11/12 13:50
	 */
	private List<RestContest> convertRestList(List<ChildShows> childShowsList) {
		List<RestContest> restContestList = Lists.newArrayList();
		if (childShowsList != null && childShowsList.size() > 0) {
			for (ChildShows childShows : childShowsList) {
				RestContest restContest = new RestContest(childShows);
				if (StringUtils.isBlank(restContest.getJudge_type())) {
					throw new ZAException(ZAErrorCode.ZA_ERROR, "请先通过CKUOA选择赛事的犬展赛制");
				}
				restContestList.add(restContest);
			}
		}
		return restContestList;
	}

	/**
	 * @Description： 获得主赛事信息
	 * @author: yuanshuai
	 * @date: 2020/11/6 9:59
	 */
	public List<RestContestEvent> getMainShowList() {
		List<RestContestEvent> restContestEvents = Lists.newArrayList();
		List<String> contestEventStrList = contestExhibitService.getAllContestEventList();
		for (String mainShowId : contestEventStrList) {
			MainShows mainShows = mainShowsDao.get(mainShowId);
			if (mainShows != null) {
				RestContestEvent restContestEvent = new RestContestEvent(mainShows);
				restContestEvents.add(restContestEvent);
			}
		}
		return restContestEvents;
	}

	/**
	 * @param request
	 * @Description： 获得子赛事信息
	 * @author: yuanshuai
	 * @date: 2020/11/6 10:18
	 */
	public List<RestContest> getChildShowList(HttpServletRequest request) {
		//子赛事信息
		String mainShowId = request.getParameter("contest_event_no");
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "请输入主赛事编号");
		}
		List<ChildShows> childShowsList = childShowsDao.getByMainShowId(mainShowId);
		if (childShowsList == null || childShowsList.size() <= 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "主赛事编号有误");
		}
		return convertRestList(childShowsList);
	}

	/**
	 * @Description： 获得犬只信息
	 * @author: yuanshuai
	 * @date: 2020/11/6 10:25
	 */
	public PageBeanResult<RestContestExhibit> getApplyDogList(HttpServletRequest request) {
		String mainShowId = request.getParameter("contest_event_no");
		if (StringUtils.isBlank(mainShowId)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "请输入主赛事编号");
		}
		List<RestContestExhibit> restContestExhibitList = getRestContestExhibitListByContest(mainShowId, CONTEST_MAIN);
		return new PageBeanResult<>(restContestExhibitList);
	}

	/**
	 * @Description： 根据主赛事id获取犬只信息
	 * @author: yuanshuai
	 * @date: 2020/11/12 13:41
	 */
	private List<RestContestExhibit> getRestContestExhibitListByContest(String contestId, String type) {
		List<RestContestExhibit> restContestExhibitList = Lists.newArrayList();
		List<ContestExhibit> exhibitList = contestExhibitService.getExhibitListByContest(contestId,type);
		for (ContestExhibit exhibit : exhibitList) {
			ShowApply showApply = showApplyService.getByShowMainIdAndPedigreeCertified(exhibit.getContestEventNo(), exhibit.getPedigreeCode());
			ContestBreed breed = contestBreedService.getByBreedNo(exhibit.getBreedNo(), "1");
			ChildShows childShows = childShowsDao.get(exhibit.getContestNo());
			ContestClass contestClass = contestClassService.getByClassNo(exhibit.getClassNo());
			if (showApply != null) {
				RestContestExhibit restContestExhibit = new RestContestExhibit(exhibit, showApply, breed, childShows, contestClass);
				restContestExhibitList.add(restContestExhibit);
			}
		}
		return restContestExhibitList;
	}

	/**
	 * @Description： 获取成绩及犬只信息
	 * @author: yuanshuai
	 * @date: 2020/11/10 14:32
	 */
	public Map<String, Map<String, Object>> getWinnersAndApplyDog(HttpServletRequest request) {
		String contestId = request.getParameter("contest_no");
		String type = CONTEST_CHILD;
		if (StringUtils.isBlank(contestId)) {
			contestId = request.getParameter("contest_event_no");
			type = CONTEST_MAIN;
		}
		if (StringUtils.isBlank(contestId)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "赛事编号有误");
		}
		Map<String, Map<String, Object>> restMap = Maps.newHashMap();
		//获取犬只信息
		Map<String, Object> exhibitMap = Maps.newHashMap();
		List<RestContestExhibit> restContestExhibitList = getRestContestExhibitListByContest(contestId, type);
		exhibitMap.put("items", restContestExhibitList);
		exhibitMap.put("total", restContestExhibitList.size());
		restMap.put("exhibits", exhibitMap);
		//获取成绩
		Map<String, Object> winnersMap = Maps.newHashMap();
		List<RestContestWinner> restContestWinnerList = getRestContestWinnerListContest(contestId, type);
		winnersMap.put("items", restContestWinnerList);
		winnersMap.put("total", restContestWinnerList.size());
		restMap.put("winners", winnersMap);
		return restMap;
	}

	/**
	 * @Description： 根据主赛事id获取犬只成绩
	 * @author: yuanshuai
	 * @date: 2020/11/12 13:41
	 */
	private List<RestContestWinner> getRestContestWinnerListContest(String contestId, String type) {
		List<RestContestWinner> restContestWinnerList = Lists.newArrayList();
		List<ContestWinner> winnerList = contestWinnerService.getWinnerByContest(contestId, type);
		for (ContestWinner winner : winnerList) {
			RestContestWinner restContestExhibit = new RestContestWinner(winner);
			restContestWinnerList.add(restContestExhibit);
		}
		return restContestWinnerList;
	}

	/**
	 * @Description： 上传单条成绩
	 * @author: yuanshuai
	 * @date: 2020/11/9 15:42
	 */
	@Transactional(readOnly = false)
	public void updateWinner(HttpServletRequest request) throws InvocationTargetException, IllegalAccessException {
		//获取参数
		RestContestWinner restContestWinner = new RestContestWinner();
		BeanUtils.populate(restContestWinner, request.getParameterMap());
		saveWinnerByUnique(new ContestWinner(restContestWinner));
	}

	/**
	 * @Description： 添加活修改成绩
	 * @author: yuanshuai
	 * @date: 2020/11/11 13:10
	 */
	@Transactional(readOnly = false)
	private synchronized void saveWinnerByUnique(ContestWinner contestWinner) {
		if (contestWinnerService.checkDataUnique(contestWinner)) {
			contestWinner.setDisplay("1");
			ChildShows childShows = childShowsDao.get(contestWinner.getContestNo());
			contestWinner.setContestEventNo(childShows.getMainShowId());
			contestWinnerService.insert(contestWinner);
		} else {
			contestWinnerService.updateWinner(contestWinner);
		}
	}

	/**
	 * @Description： 上传所有成绩
	 * @author: yuanshuai
	 * @date: 2020/11/10 13:43
	 */
	@Transactional(readOnly = false)
	public void updateWinners(String json) throws UnsupportedEncodingException {
		String decodeJson = URLDecoder.decode(json, "utf-8");
		List<RestContestWinner> restContestWinnerList = BeanUtil.toList(decodeJson.substring(0, decodeJson.length() - 1), RestContestWinner.class);
		if (restContestWinnerList == null || restContestWinnerList.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "成绩有误，请重试");
		}
		for (RestContestWinner restContestWinner : restContestWinnerList) {
			saveWinnerByUnique(new ContestWinner(restContestWinner));
		}
	}


	/**
	 * @Description： 上传狗信息
	 * @author: yuanshuai
	 * @date: 2020/11/11 15:19
	 */
	@Transactional(readOnly = false)
	public void updateApplyDog(String json) throws UnsupportedEncodingException {
		String decodeJson = URLDecoder.decode(json, "utf-8");
		List<RestContestExhibit> restContestExhibitList = BeanUtil.toList(decodeJson.substring(0, decodeJson.length() - 1), RestContestExhibit.class);
		for (RestContestExhibit restContestExhibit : restContestExhibitList) {
			contestExhibitService.updateGrade(new ContestExhibit(restContestExhibit));
		}
	}
}
