package com.cku.restful.v1.breeder.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogBirthCertificateTransferService;
import com.cku.restful.v1.breeder.dto.RestBirthCertificateRequestVo;
import com.cku.restful.v1.breeder.dto.RestTransferReviewRequestVo;
import com.cku.restful.v1.breeder.dto.TransferListRequestVo;
import com.cku.restful.v1.breeder.dto.TransferListResponseVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Controller
@Api(tags = "APP登记卡转让接口")
@RequestMapping(value = "/api/v1/breeder/dog/birthcertificate/transfer")
public class RestDogBirthCertificateTransfer {

	@Autowired
	private DogBirthCertificateTransferService dogBirthCertificateTransferService;

	@ApiOperation(value = "登记卡转让-列表")
	@RequestMapping(value = "list", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<TransferListResponseVo> getList(@Valid TransferListRequestVo requestVo,
			HttpServletRequest request, HttpServletResponse response) throws IOException {
		return dogBirthCertificateTransferService.getRestList(requestVo);
	}

	@ApiOperation(value = "登记卡转让-查询")
	@RequestMapping(value = "search", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<TransferListResponseVo> search(@Valid RestBirthCertificateRequestVo vo , HttpServletRequest request) {
		return dogBirthCertificateTransferService.search(vo,request);
	}

	@ApiOperation(value = "登记卡转让-转让")
	@RequestMapping(value = "transfer", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<?> transfer(@RequestBody @Valid RestBirthCertificateRequestVo vo , HttpServletRequest request) {
		return dogBirthCertificateTransferService.transfer(vo,request);
	}

	@ApiOperation(value = "登记卡转让-短信")
	@RequestMapping(value = "sms", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<?> sendCode(HttpServletRequest request, HttpServletResponse response) {
		try {
			dogBirthCertificateTransferService.sms();
		}catch(ZAException e) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
		}
		return ResultDto.SUCCESSFUL();
	}

	@ApiOperation(value = "登记卡转让-审核")
	@RequestMapping(value = "review", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<?> review(@RequestBody @Valid RestTransferReviewRequestVo vo, HttpServletRequest request,
			HttpServletResponse response) {
		return dogBirthCertificateTransferService.review(vo);
	}
}
