package com.cku.restful.v1.appreciation.web;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.appreciation.entity.AppreciationCertificate;
import com.cku.oa.appreciation.service.AppreciationApplyService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.appreciation.model.RestAppreciationCertificate;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/v1/appreciation")
@Api(tags = "鉴赏课程证书接口")
public class RestAppreciationCertificateController extends BaseRestController {

	@Autowired
	private AppreciationApplyService appreciationApplyService;

	@ApiOperation(value = "证书数量查询")
	@RequestMapping(value = "/certificates/count", method = RequestMethod.GET)
	public ResultDto<Integer> certificateCount(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		Member member = UserUtils.getLoginMember();
		Integer certificateCount = appreciationApplyService.countByMemberCode(member.getMemberCode());
		return ResultDto.success(certificateCount);
	}

	@ApiOperation(value = "证书列表查询")
	@RequestMapping(value = "/certificates", method = RequestMethod.GET)
	public ListResultDto<RestAppreciationCertificate> certificates(HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
		List<RestAppreciationCertificate> resultList = null;
		List<AppreciationCertificate> certificateList = appreciationApplyService
				.findListByMemberCodeOrCertificateCode(member.getMemberCode(),null);
		if (CollectionUtils.isNotEmpty(certificateList)) {
			resultList = certificateList.stream().map(ac -> {
				return RestAppreciationCertificate.builder().certificateCode(ac.getCertificateCode())
						.courseName(ac.getCourseName()).issueDate(ac.getIssueDate()).memberCode(ac.getMemberCode())
						.courseStartDate(ac.getCourseStartDate()).courseEndDate(ac.getCourseEndDate())
						.memberName(ac.getMemberName()).build();
			}).collect(Collectors.toList());
		}
		return ListResultDto.success(resultList);
	}

}
