package com.cku.oa.show.service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ListResultDto;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.show.constant.ShowRankingScoreTypeConstant;
import com.cku.oa.show.dao.ChildShowsDao;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowReportInfoDao;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.dao.ShowScoreDao;
import com.cku.oa.show.dao.ShowScoreRankingDao;
import com.cku.oa.show.dao.ShowScoreTitleDao;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowReportInfo;
import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowScore;
import com.cku.oa.show.entity.ShowScoreRanking;
import com.cku.oa.show.entity.ShowScoreTitle;
import com.cku.oa.show.vo.ShowScoreRankingBBEExportVO;
import com.cku.oa.show.vo.ShowScoreRankingDQZExportVO;
import com.cku.oa.sys.dao.FciDogDao;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.restful.v1.show.model.CkuShowScore;
import com.cku.restful.v1.show.model.CkuShowScoreDetail;
import com.cku.restful.v1.show.model.CkuShowScoreRankingAbstractVO;
import com.cku.restful.v1.show.model.CkuShowScoreRankingDqzAbstract;
import com.cku.restful.v1.show.model.CkuShowScoreRankingGroupAbstract;
import com.cku.restful.v1.show.model.CkuShowScoreRankingMaxMonth;
import com.cku.restful.v1.show.model.CkuShowScoreRankingMonths;
import com.cku.restful.v1.show.model.CkuShowScoreRankingSearchVO;
import com.cku.thirdparty.oss.OssApiClient;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;

/**
 * 赛事成绩排名表Service
 * 
 * @author xx
 * @version 2021-07-20
 */
@Service
@Transactional(readOnly = true)
public class ShowScoreRankingService extends CrudService<ShowScoreRankingDao, ShowScoreRanking> {

	@Autowired
	private ShowScoreDao showScoreDao;
	@Autowired
	private ShowResultsDao showResultsDao;
	@Autowired
	private FciDogDao fciDogDao;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private DogTypeDao dogTypeDao;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private ChildShowsDao childShowsDao;
	@Autowired
	private ShowReportInfoDao showReportInfoDao;
	@Autowired
	private ShowScoreTitleDao showScoreTitleDao;

	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	public ShowScoreRanking get(String id) {
		return super.get(id);
	}

	public List<ShowScoreRanking> findList(ShowScoreRanking showScoreRanking) {
		return super.findList(showScoreRanking);
	}

	public Page<ShowScoreRanking> findPage(Page<ShowScoreRanking> page, ShowScoreRanking showScoreRanking) {
		return super.findPage(page, showScoreRanking);
	}

	@Transactional(readOnly = false)
	public void save(ShowScoreRanking showScoreRanking) {
		super.save(showScoreRanking);
	}

	@Transactional(readOnly = false)
	public void delete(ShowScoreRanking showScoreRanking) {
		super.delete(showScoreRanking);
	}

	@Transactional(readOnly = false)
	public ShowScoreRanking get(String year, String scoreType, String pedigreeCertified) {
		ShowScoreRanking entity = new ShowScoreRanking();
		entity.setYear(year);
		entity.setScoreType(scoreType);
		entity.setPedigreeCertified(pedigreeCertified);
		return dao.getOne(entity);
	}

	/**
	 * 刷新排名记录
	 * 
	 * @param showCode
	 * @param isUpdateLastYear  是否可以跨年更新
	 */
	@Transactional(readOnly = false)
	public void createRankings(String showCode,Boolean isUpdateLastYear) {
		// 查询该赛事编号的归属年份是否为今年,不是今年就不用更新积分榜
		MainShows mainShows = mainShowsDao.getByShowCodePrefix(showCode);
		
		int year = LocalDate.now().getYear();
		if(isUpdateLastYear) {
			//每年跨年后技术手动更新去年最后几场赛事
			 year = Integer.valueOf(mainShows.getYear());
		}else {
			//后台业务刷新
			if (mainShows == null || !StringUtils.isNotBlank(mainShows.getYear())
					|| year != Integer.valueOf(mainShows.getYear())) {
				return;
			}
		}
		
		// 逻辑删除本年旧数据
		dao.delLogical(year + "",null,null);
				
		// 成年犬组
		createRankings(year + "", null, "3", showCode);
		// 本土繁殖积分榜
		createRankings(year + "", null,  "20", showCode);
		// 犬主人组
		createRankings(year + "", null,  "ohc", showCode);
		// 繁殖人组
		createRankings(year + "", null,  "bbe", showCode);
		// 单犬种积分榜
		createRankings(year + "", null,  "dqz", showCode);
		// 组别榜
		createRankings(year + "", null,  "group", showCode);
		
		// 上升趋势 0持平 1上升 2下降
		dao.saveTrendByYearAndMonth(year + "",null,null);

		// 对多余的冗余数据进行物理删除
		dao.delPhysicalByYearAndMonth(year + "",null, showCode,null);
		
		// 月度榜单
		// 逻辑删除计算月份的旧数据
		ChildShows childShows = childShowsDao.getByShowCode(showCode);
	    LocalDate localDate = childShows.getStartTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
		String year1 =  String.valueOf(localDate.getYear());
		String month =  String.valueOf(localDate.getMonthValue());
		// 逻辑删除月度旧数据
		dao.delLogical(year1,month,null);
		// 特幼犬组月度积分榜
		createRankings(year1 , month, "1", showCode);
		// 特幼犬组月度积分榜
		createRankings(year1 , month, "2", showCode);
		// 上升趋势 0持平 1上升 2下降
		dao.saveTrendByYearAndMonth(year1 ,month,null);
		// 对多余的冗余数据进行物理删除
		dao.delPhysicalByYearAndMonth(year1 ,month, showCode,null);
	}

	@Transactional(readOnly = false)
	private void createRankings(String year,String month,  String scoreType, String showCode) {
		/**
		 * 计算积分
		 */
		List<ShowScore> showScoreList = null;
		List<ShowResults> resultsList = null;
		List<String> pedigreeCertifiedList = new ArrayList<>();
		if ("2020".equals(year)) {
//	            2020年五月一号起没有中国冠军登录的犬不能上榜
			pedigreeCertifiedList = showResultsDao.getDogAgeGroups();
		}
		if ("2".equals(scoreType)||"1".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank12(year, month,scoreType);
		}else if ("3".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank3(year, pedigreeCertifiedList);
		} else if ("20".equals(scoreType)) {
			showScoreList = showScoreDao.getScoreRank20(year, scoreType, null, null, pedigreeCertifiedList);
		} else if ("ohc".equals(scoreType)) {
			resultsList = showResultsDao.getOHCScore(year, null, null);
		} else if ("bbe".equals(scoreType)) {
			resultsList = showResultsDao.getBBEScore(year, null, null, null);
		} else if ("dqz".equals(scoreType)) {
			// 单犬种积分单独计算
			showScoreList = showScoreDao.getScoreRankDZQ(year);
		}else if ("group".equals(scoreType)||"1".equals(scoreType)) {
			//24年新增组别榜-年榜
			showScoreList = showScoreDao.getScoreRankGroup(year, pedigreeCertifiedList);
		}

		if (showScoreList != null && showScoreList.size() > 0) {
			int ranking = 1;
			for (int i = 0; i < showScoreList.size(); i++) {
				ShowScore showScore = showScoreList.get(i);
				ShowScoreRanking entity = new ShowScoreRanking();
				entity.setPedigreeCertified(showScore.getPedigreeCertified());
				entity.setDogOwner(showScore.getDogOwner());
				entity.setDogBreedNameCn(showScore.getDogBreedNameCn());
				entity.setDogBreedNameEn(showScore.getDogBreedNameEn());
				entity.setDogName(showScore.getDogName());
				entity.setDogBreedGroup(showScore.getDogBreedGroup());
				entity.setYear(year);
				entity.setMonth(month);
				entity.setScoreType(scoreType);
				entity.setScore(Double.valueOf(showScore.getScore()));
				Dog dog = dogDao.getByPedigreeCertifiedCode(showScore.getPedigreeCertified());
				if (dog != null) {
					entity.setDogBreed(dog.getDogBreed());
					DogType dogType = dogTypeDao.getByDogBreedCode(dog.getDogBreed());
					if (dogType != null) {
						entity.setDogBreedGroup(dogType.getTypeGroup());// 犬組赛事分组
					}
				}
				// 排名
				entity.setRanking(ranking);
				// 版本号
				entity.setVersion(showCode);
				entity.preInsert();
				dao.insert(entity);
				if (i < showScoreList.size() - 1) {
					ShowScore showScore2 = showScoreList.get(i + 1);
					if (!showScore2.getScore().equals(showScore.getScore())) {
						ranking++;
					}
					if ("dqz".equals(scoreType)
							&& !showScore2.getDogBreedNameEn().equals(showScore.getDogBreedNameEn())) {// 单犬种只计算犬种内排名
						ranking = 1;
					}else if ("group".equals(scoreType)
							&& !showScore2.getDogBreedGroup().equals(showScore.getDogBreedGroup())) {// 组别榜只计算组别内排名
						ranking = 1;
					}
				}
			}
		}
		if (resultsList != null && resultsList.size() > 0) {
			int ranking = 1;
			for (int i = 0; i < resultsList.size(); i++) {
				ShowResults data = resultsList.get(i);
				ShowScoreRanking entity = new ShowScoreRanking();
				entity.setPedigreeCertified(data.getPedigreeCertified());
				entity.setDogOwner(data.getDogOwnerNameCn());
				entity.setDogBreedNameCn(data.getBreedCnName());
				entity.setDogBreedNameEn(data.getBreedEnName());
				entity.setDogName(data.getDogName());
				entity.setYear(year);
				entity.setScoreType(scoreType);
				entity.setScore(Double.valueOf(data.getScore()));
				Dog dog = dogDao.getByPedigreeCertifiedCode(data.getPedigreeCertified());
				if (dog != null) {
					entity.setDogBreed(dog.getDogBreed());
					DogType dogType = dogTypeDao.getByDogBreedCode(dog.getDogBreed());
					if (dogType != null) {
						entity.setDogBreedGroup(dogType.getTypeGroup());// 犬組赛事分组
					}
				}
				// 排名
				entity.setRanking(ranking);
				// 版本号
				entity.setVersion(showCode);
				entity.preInsert();
				dao.insert(entity);
				if (i < resultsList.size() - 1) {
					ShowResults showScore2 = resultsList.get(i + 1);
					if (!data.getScore().equals(showScore2.getScore())) {
						ranking++;
					}
				}
			}
		}

		/**
		 * 计算排名 20220302 业务认为用全犬种积分计算犬种组合犬种排名不公平，取消这两个排名
		 */
//		ShowScoreRanking entity = new ShowScoreRanking();
//		entity.setYear(year);
//		entity.setScoreType(scoreType);
//		List<ShowScoreRanking> list = dao.findList(entity);
//		// 犬种组排名
//		Map<String, List<ShowScoreRanking>> map = list.stream().filter(a -> a.getDogBreedGroup() != null)
//				.collect(Collectors.groupingBy(ShowScoreRanking::getDogBreedGroup));
//		for (String key : map.keySet()) {
//			List<ShowScoreRanking> groupList = map.get(key).stream()
//					.sorted(Comparator.comparing(ShowScoreRanking::getScore).reversed()).collect(Collectors.toList());
//			int ranking = 1;
//			for (int i = 0; i < groupList.size(); i++) {
//				ShowScoreRanking data = groupList.get(i);
//				data.setGorupRanking(ranking);
//				data.preUpdate();
//				dao.update(data);
//				if (i < groupList.size() - 1) {
//					ShowScoreRanking data2 = groupList.get(i + 1);
//					if (!data2.getScore().equals(data.getScore())) {
//						ranking++;
//					}
//				}
//			}
//		}
//		// 犬种排名
//		Map<String, List<ShowScoreRanking>> map2 = list.stream().filter(a -> a.getDogBreed() != null)
//				.collect(Collectors.groupingBy(ShowScoreRanking::getDogBreed));
//		for (String key : map2.keySet()) {
//			List<ShowScoreRanking> groupList = map2.get(key).stream()
//					.sorted(Comparator.comparing(ShowScoreRanking::getScore).reversed()).collect(Collectors.toList());
//			int ranking = 1;
//			for (int i = 0; i < groupList.size(); i++) {
//				ShowScoreRanking data = groupList.get(i);
//				data.setDogBreedRanking(ranking);
//				data.preUpdate();
//				dao.update(data);
//				if (i < groupList.size() - 1) {
//					ShowScoreRanking data2 = groupList.get(i + 1);
//					if (!data2.getScore().equals(data.getScore())) {
//						ranking++;
//					}
//				}
//			}
//		}

	}

	private String getAgeGroup(String year, String scoreType) {
		String result = "";
		if ("2013".equals(year) || "2014".equals(year) || "2015".equals(year) || "2016".equals(year)
				|| "2017".equals(year) || "2018".equals(year) || "2019".equals(year) || "2020".equals(year)
				|| "2021".equals(year)) {
			if ("1".equals(scoreType) || "8".equals(scoreType)) {
				result = "AND age_group IN (1,2)";
			}
			if ("2".equals(scoreType) || "7".equals(scoreType)) {
				result = "AND age_group IN (3,4)";
			}
			if ("6".equals(scoreType) || "30".equals(scoreType)) {
				result = "AND age_group > 4";
			}
			if ("3".equals(scoreType) || "20".equals(scoreType)) {
				if ("2020".equals(year)) {
					result = "AND (\n" + "\t\t\t(\n" + "\t\t\t\tsr.age_group IN ('12', '13', '14')\n"
							+ "\t\t\t\tAND scd.start_time >= '2020-05-01 00:00:00'\n" + "\t\t\t)\n"
							+ "\t\t\tOR scd.start_time < '2020-05-01 00:00:00'\n" + "\t\t)";
				} else {
					result = "AND age_group IN ('12','13','14')";
				}
			}
		} else {
			if ("1".equals(scoreType)) {
				result = "AND age_group < 5";
			}
			if ("2".equals(scoreType)) {
				result = "AND age_group >4";
			}
		}
		return result;
	}

	public List<CkuShowScore> findListFCKU(ShowScoreRanking showScoreRanking) {
		List<CkuShowScore> resultList = new ArrayList<>();
		List<ShowScoreRanking> list = super.findList(showScoreRanking);
		if (list.size() > 0) {
			// 犬只照片：与赛事播报BIS1犬只使用同一张照片
			List<String> pedigreeCertifiedList = list.stream().map(a -> a.getPedigreeCertified())
					.collect(Collectors.toList());
			Map<String, String> infoMap = getBis1PicMap(pedigreeCertifiedList);
			for (ShowScoreRanking ssr : list) {
				CkuShowScore css = new CkuShowScore(ssr);
				css.setRanking(ssr.getRanking());
				if (!"bbe".equals(showScoreRanking.getScoreType()) && !StringUtils.isBlank(ssr.getSecondDogOwner())) {
					css.setDogOwner(css.getDogOwner() + "/" + ssr.getSecondDogOwner());
				}
				if (infoMap.get(ssr.getPedigreeCertified()) != null) {
					css.setDogPhoto(infoMap.get(ssr.getPedigreeCertified()));
				}
				resultList.add(css);
			}
		}
		return resultList;
	}
	/**
	 * 查询赛事播报图片
	 * @param pedigreeCertifiedList
	 * @return
	 * 犬只照片来源于赛事播报BIS1/2/3/4的犬只照片，
	 * 同犬只照片超过1张，选择顺序优先级为BIS1，BIS2，BIS3，BIS4，同级别如存在多张照片，选用日期最近的一张。
	 */
	@Transactional(readOnly = false)
	public Map<String, String> getBis1PicMap(List<String> pedigreeCertifiedList) {
		Map<String, String> infoMap = new HashMap<>();
		if (pedigreeCertifiedList.size() > 0) {
			List<ShowReportInfo> infosT = showReportInfoDao.getBisPics(pedigreeCertifiedList);
			List<ShowReportInfo> infos = new ArrayList<>();
			Set<String> set = new HashSet<>();
			for(ShowReportInfo info:infosT) {
				if(!set.contains(info.getBis1PedigreeCertified())) {
					set.add(info.getBis1PedigreeCertified());
					infos.add(info);
				}
			}
			if(infos!=null&&infos.size()>0) {
				//查询阿里云路径
				List<BaseFile> bfiles = fileService.getByIds( infos.stream().map(a->a.getBis1Pic()).collect(Collectors.toList()));
				Map<String, String> bfilesMap = bfiles.stream().collect(HashMap::new,
						(m, v) -> m.put(v.getId(), ossApiClient.getOssUrl(v.getLocation(),v.getName())), HashMap::putAll);
				infoMap = infos.stream().collect(HashMap::new,
						(m, v) -> m.put(v.getBis1PedigreeCertified(), 
								bfilesMap.get(v.getBis1Pic())), HashMap::putAll);
			}
		}
		return infoMap;
	}

	@Transactional(readOnly = false)
	public ListResultDto<CkuShowScoreRankingAbstractVO> getQqzAbstract(String year) {
		List<CkuShowScoreRankingAbstractVO> listResult = new ArrayList<>();
		// 成年犬组
		listResult.add(buildCkuShowScoreRankingAbstractVO("3", year, 10));
		// 本土繁殖积分榜
		listResult.add(buildCkuShowScoreRankingAbstractVO("20", year, 3));
		// 犬主人组
		listResult.add(buildCkuShowScoreRankingAbstractVO("ohc", year, 3));
		// 繁殖人组
		listResult.add(buildCkuShowScoreRankingAbstractVO("bbe", year, 3));
		if ("2020".equals(year)) {
			// 幼小犬组
			listResult.add(buildCkuShowScoreRankingAbstractVO("2", year, 3));
			// 特幼犬组
			listResult.add(buildCkuShowScoreRankingAbstractVO("1", year, 3));
		}
		//2023以后要展示幼小、特幼本月的月榜前三条
		if (Integer.valueOf(year) >= 2023 ) {
			// 幼小犬组
			listResult.add(buildCkuShowScoreRankingMonthAbstractVO("2", year, 3));
			// 特幼犬组
			listResult.add(buildCkuShowScoreRankingMonthAbstractVO("1", year, 3));
		}
		return ListResultDto.success(listResult);

	}
	
	private CkuShowScoreRankingAbstractVO buildCkuShowScoreRankingMonthAbstractVO(String scoreType, String year,
			Integer limit) {
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setLimit(limit != null ? Integer.valueOf(limit) : null);// 请求多少条
		showScoreRanking.setScoreType(scoreType);
		showScoreRanking.setYear(year);
		//查询本年最新的月度榜单月份是几月
		String maxMonth = dao.findMaxMonth(year, scoreType);
		showScoreRanking.setMonth(maxMonth);
		List<CkuShowScore> resultList = findListFCKU(showScoreRanking);

		return CkuShowScoreRankingAbstractVO.builder().scoreType(scoreType).scoreTitle(getScoreTitle(scoreType)).month(maxMonth)
				.list(resultList).build();
	}

	private CkuShowScoreRankingAbstractVO buildCkuShowScoreRankingAbstractVO(String scoreType, String year,
			Integer limit) {
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setLimit(limit != null ? Integer.valueOf(limit) : null);// 请求多少条
		showScoreRanking.setScoreType(scoreType);
		showScoreRanking.setYear(year);
		List<CkuShowScore> resultList = findListFCKU(showScoreRanking);

		return CkuShowScoreRankingAbstractVO.builder().scoreType(scoreType).scoreTitle(getScoreTitle(scoreType))
				.list(resultList).build();
	}

	private String getScoreTitle(String scoreType) {
		String scoreTitle = "";
		switch (scoreType) {
		case "3":
			scoreTitle = "成年犬榜";
			break;
		case "2":
			scoreTitle = "幼小犬榜";
			break;
		case "1":
			scoreTitle = "特幼犬榜";
			break;
		case "20":
			scoreTitle = "本土繁殖积分榜";
			break;
		case "ohc":
			scoreTitle = "犬主人榜";
			break;
		case "bbe":
			scoreTitle = "繁殖人榜";
			break;
		case "dqz":
			scoreTitle = "单犬种积分榜";
			break;
		case "group":
			scoreTitle = "全犬种组别榜";
			break;
		case "Eukanuba":
			scoreTitle = "优卡杯积分榜";
			break;
		case "sdAdult":
			scoreTitle = "顺德成年犬组";
			break;
		case "sdPuppy":
			scoreTitle = "顺德幼小犬组";
			break;
		case "sdBaby":
			scoreTitle = "顺德特幼犬组";
			break;
		default:
			break;
		}
		return scoreTitle;
	}

	@Transactional(readOnly = false)
	public ListResultDto<CkuShowScoreRankingDqzAbstract> getDqzAbstract(String year,Integer limit) {
		List<CkuShowScoreRankingDqzAbstract> listResult = new ArrayList<>();
		// 十个犬种组
		List<HashMap<String, Object>> list = fciDogDao.getFciGroup();
		list.stream().forEach(a -> {
			CkuShowScoreRankingDqzAbstract dqzAbstract = CkuShowScoreRankingDqzAbstract.builder()
					.dogBreedGroupCode(a.get("group_no").toString())
					.dogBreedGroup(a.get("chinese_group_name").toString()).build();
			// 犬种组列表
			List<CkuShowScoreRankingAbstractVO> list1 = new ArrayList<>();
			ShowScoreRanking showScoreRanking = new ShowScoreRanking();
			showScoreRanking.setScoreType("dqz");
			showScoreRanking.setYear(year);
			showScoreRanking.setDogBreedGroup(a.get("group_no").toString().replaceFirst("^0*", ""));
			List<CkuShowScore> resultList = findListFCKU(showScoreRanking);
			Map<String, List<CkuShowScore>> map = resultList.stream()
					.collect(Collectors.groupingBy(CkuShowScore::getDogBreedNameCn));
			for (String key : map.keySet()) {
				List<CkuShowScore> groupList = map.get(key).stream()
						.sorted(Comparator.comparing(CkuShowScore::getRanking)).limit(limit!=null?limit:3).collect(Collectors.toList());
				CkuShowScoreRankingAbstractVO vo = CkuShowScoreRankingAbstractVO.builder().scoreTitle(key)
						.scoreType(groupList.size() > 0 ? groupList.get(0).getDogBreed() : null).build();
				vo.setList(groupList);
				list1.add(vo);
			}
			dqzAbstract.setList(list1);
			listResult.add(dqzAbstract);
		});

		return ListResultDto.success(listResult);

	}

	@Transactional(readOnly = false)
	public RESTResponse getFciDogByGroupId(String groupId, String year, String scoreType) {
		if (StringUtils.isNotBlank(groupId)) {
			groupId = groupId.replaceFirst("^0*", "");
		}
		List<HashMap<String, Object>> list = fciDogDao.getRankingFciDogByGroupId(groupId, year, scoreType);
		for (HashMap<String, Object> map : list) {
			if ("澳大利亚卡尔比犬".equals(map.get("chinese_breed_name"))) {
				map.put("chinese_breed_name", "澳大利亚牧羊犬");
			}
		}
		return new RESTResponse("0", list);
	}

	@Autowired
	private OssApiClient ossApiClient;
	
	@Autowired
	private FileService fileService;
	
	@Transactional(readOnly = false)
	public RESTResponse getScore(String groupNo, String year, String month, String scoreType, String fciStandardNo,
			String rankLimit) {
		if (StringUtils.isNotBlank(groupNo)) {
			groupNo = groupNo.replaceFirst("^0*", "");
		}
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		// 官网积分榜特有参数 groupNo、fciStandardNo 对积分榜结果进行过滤，不传查询全犬种排名
		if (StringUtils.isNotBlank(fciStandardNo)) {
			showScoreRanking.setDogBreed(fciStandardNo);
		} else if (StringUtils.isNotBlank(groupNo)) {
			showScoreRanking.setDogBreedGroup(groupNo);
		} 
		if (StringUtils.isBlank(fciStandardNo) && ShowRankingScoreTypeConstant.DQZ.equals(scoreType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "单犬种积分榜必传犬种编号！");
		}
		if (StringUtils.isBlank(groupNo) && ShowRankingScoreTypeConstant.GROUP.equals(scoreType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "组别榜必传犬种组编号！");
		}
		if (StringUtils.isNotBlank(rankLimit)) {
			showScoreRanking.setRankLimit(Integer.valueOf(rankLimit));
		} else {
			showScoreRanking.setRankLimit(100);
		}
		showScoreRanking.setScoreType(scoreType);
		showScoreRanking.setYear(year);
		showScoreRanking.setMonth(month);

		HashMap<String, Object> result = new HashMap<String, Object>();
		List<CkuShowScore> resultList = new ArrayList<CkuShowScore>();
		//2023年及以后得幼小 特幼榜都是月榜
		if (!(StringUtils.isBlank(month) && ("1".equals(scoreType)||"2".equals(scoreType))
						&&Integer.valueOf(year)>=2023)) {//月榜不传月份直接返回空
			List<ShowScoreRanking> list = findList(showScoreRanking);
			// 犬只照片：与赛事播报BIS1犬只使用同一张照片
			List<String> pedigreeCertifiedList = list.stream().map(a -> a.getPedigreeCertified())
					.collect(Collectors.toList());
			Map<String, String> infoMap = getBis1PicMap(pedigreeCertifiedList);
			for (ShowScoreRanking ssr : list) {
				CkuShowScore css = new CkuShowScore(ssr);
				css.setRanking(ssr.getRanking());
				if (StringUtils.isNotBlank(infoMap.get(ssr.getPedigreeCertified()))) {
					css.setDogPhoto(infoMap.get(ssr.getPedigreeCertified()));
				}
				//第二犬主
				css.setDogOwner(StringUtils.isNotBlank(ssr.getSecondDogOwner())?ssr.getDogOwner()+ "/"+ssr.getSecondDogOwner():ssr.getDogOwner());
				resultList.add(css);
			}		
		}
		result.put("list", resultList);
		result.put("scoreTitle", getScoreTitle(year, scoreType));
		return new RESTResponse("data", result);
	}

	private String getScoreTitle(String year, String scoreType) {
		ShowScoreTitle scoreTitle = showScoreTitleDao.getByYearAndGroup(year, scoreType);
		if (scoreTitle != null) {
			return scoreTitle.getTitle();
		} else {
			return "";
		}
	}

	@Transactional(readOnly = false)
	public RESTResponse getScoreDetail(String year, String scoreType, String pedigreeCertified) {
		if (StringUtils.isBlank(year) || StringUtils.isBlank(scoreType) || StringUtils.isBlank(pedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少必要参数");
		}
		CkuShowScoreDetail detail = new CkuShowScoreDetail();
		Dog dog = dogDao.getByPedigreeCertifiedCode(pedigreeCertified);
		if (dog != null) {
			detail.setPedigreeCertified(dog.getPedigreeCertifiedCode());
			detail.setPicture("1".equals(dog.getPictureReviewState()) ? dog.getPicture() : null);
			detail.setGender(dog.getGender());
			detail.setDogName(dog.getNameEn());
			detail.setNickname(dog.getCallName());
			detail.setBirthdate(sdf.format(dog.getBirthdate()));
			detail.setDogOwner(StringUtils.isNotBlank(dog.getSecondDogOwner())?dog.getDogOwner()+ "/"+dog.getSecondDogOwner():dog.getDogOwner());
			detail.setBreeder(dog.getBreeder());
		}
		ShowScoreRanking data = get(year, scoreType, pedigreeCertified);
		if(data!=null) {
			detail.setDogBreedNameCn(data.getDogBreedNameCn());
			// 积分
			detail.setScore(data.getScore().toString().split("\\.")[0]);
			// 排名
			detail.setRanking(data.getRanking());
		}
		// 1、单犬种积分 没有返回0
		ShowScoreRanking data2 = get(year, "dqz", pedigreeCertified);
		if (data2 != null) {
			detail.setDqzScore(data2.getScore().toString());
			detail.setDogBreedRanking(data2.getRanking());
		} else {
			detail.setDqzScore("0");
		}
		// 2、照片改为使用赛事播报的犬只照片，注意UI设计调整
		ShowReportInfo info = showReportInfoDao.getBisPic(pedigreeCertified);
		if (info != null) {
			BaseFile bfile = fileService.get(info.getBis1Pic());
			detail.setDogPhoto(ossApiClient.getOssUrl(bfile.getLocation(),bfile.getName()));
		}
		return new RESTResponse("data", detail);
	}

	@Transactional(readOnly = false)
	public ListResultDto<CkuShowScoreRankingSearchVO> searchScoreOpen(String year, String scoreType, String key) {
		if (StringUtils.isBlank(year) || StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少必要参数");
		}
		List<CkuShowScoreRankingSearchVO> listSearchVO = new ArrayList<>();
		//查询
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setScoreType(scoreType);
		showScoreRanking.setYear(year);
		showScoreRanking.setKey(key);
		List<CkuShowScore> resultList = findListFCKU(showScoreRanking);
		
		if(resultList!=null &&resultList.size()>0) {
			// 对归属榜单进行分类
			Map<String, List<CkuShowScore>> map = resultList.stream()
					.collect(Collectors.groupingBy(CkuShowScore::getScoreType));
			List<CkuShowScoreRankingAbstractVO> listResult1 = new ArrayList<>();//全犬种积分榜
			List<CkuShowScoreRankingAbstractVO> listResult2 = new ArrayList<>();//单犬种积分榜
			for(String type:map.keySet()) {
				List<CkuShowScore> ss = map.get(type).stream().sorted(Comparator.comparing(CkuShowScore::getRanking))
						.collect(Collectors.toList());
				CkuShowScoreRankingAbstractVO vo =  CkuShowScoreRankingAbstractVO.builder().scoreType(type).scoreTitle(getScoreTitle(type))
						.list(ss).build();
				if("dqz".equals(type)) {
					listResult2.add(vo);
				}else{
					listResult1.add(vo);
				}
			}
			if(listResult1.size()>0) {
				CkuShowScoreRankingSearchVO  searchVO1 = CkuShowScoreRankingSearchVO.builder().group("全犬种积分榜").build();
				searchVO1.setList(listResult1);
				listSearchVO.add(searchVO1);
			}
			if(listResult2.size()>0) {
				CkuShowScoreRankingSearchVO  searchVO2 = CkuShowScoreRankingSearchVO.builder().group("单犬种积分榜").build();
				searchVO2.setList(listResult2);
				listSearchVO.add(searchVO2);
			}
		}

		return ListResultDto.success(listSearchVO);

	}
	
	
	public void export( HttpServletResponse response) throws IOException {
		//成年犬榜
		int year = LocalDate.now().getYear();
		//查询本年标题
		List<ShowScoreTitle> titles = showScoreTitleDao.getByYear(year+"");
		Map<String,String> titlesMap = titles.stream().collect(Collectors.toMap(ShowScoreTitle::getAgeGroup,ShowScoreTitle::getTitle));
		
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setRankLimit(100);
		showScoreRanking.setScoreType("3");
		showScoreRanking.setYear(year+"");
		List<ShowScoreRanking> list1 = findList(showScoreRanking);
		list1.forEach(a->{
			a.setDogOwner(StringUtils.isNotBlank(a.getSecondDogOwner())?a.getDogOwner()+"\\"+a.getSecondDogOwner():a.getDogOwner());
			a.setTitle(titlesMap.get("3"));
			if(StringUtils.isNoneBlank(a.getDogOwner())) {
				a.setDogOwner(a.getDogOwner().replace("&middot;", "·"));
			}
		});							
		ExportExcel excel = new ExportExcel("成年犬榜", ShowScoreRanking.class,5);
		excel.setDataList(list1, 0);
		//本土繁殖榜
		showScoreRanking.setScoreType("20");
		List<ShowScoreRanking> list2 = findList(showScoreRanking);
		excel.addSheet("本土繁殖榜", ShowScoreRanking.class);
		list2.forEach(a->{
			a.setDogOwner(StringUtils.isNotBlank(a.getSecondDogOwner())?a.getDogOwner()+"\\"+a.getSecondDogOwner():a.getDogOwner());
			a.setTitle(titlesMap.get("20"));
			if(StringUtils.isNoneBlank(a.getDogOwner())) {
				a.setDogOwner(a.getDogOwner().replace("&middot;", "·"));
			}
		});	
		excel.setDataList(list2, 1);
		//犬主人榜
		showScoreRanking.setScoreType("ohc");
		List<ShowScoreRanking> list3 = findList(showScoreRanking);
		excel.addSheet("犬主人榜", ShowScoreRanking.class);
		list3.forEach(a->{
			a.setDogOwner(StringUtils.isNotBlank(a.getSecondDogOwner())?a.getDogOwner()+"\\"+a.getSecondDogOwner():a.getDogOwner());
			a.setTitle(titlesMap.get("ohc"));
			if(StringUtils.isNoneBlank(a.getDogOwner())) {
				a.setDogOwner(a.getDogOwner().replace("&middot;", "·"));
			}
		});	
		excel.setDataList(list3, 2);
		//繁殖人组榜
		showScoreRanking.setScoreType("bbe");
		List<ShowScoreRanking> list4 = findList(showScoreRanking);
		excel.addSheet("繁殖人组榜", ShowScoreRankingBBEExportVO.class);
		list4.forEach(a->{
			a.setTitle(titlesMap.get("bbe"));
			if(StringUtils.isNoneBlank(a.getDogOwner())) {
				a.setDogOwner(a.getDogOwner().replace("&middot;", "·"));
			}
		});	
		excel.setDataList(list4, 3);
		//单犬种榜  
		showScoreRanking.setScoreType("dqz");
		List<ShowScoreRanking> list5 = findList(showScoreRanking);
		excel.addSheet("单犬种榜", ShowScoreRankingDQZExportVO.class);
		list5.forEach(a->{
			a.setDogOwner(StringUtils.isNotBlank(a.getSecondDogOwner())?a.getDogOwner()+"\\"+a.getSecondDogOwner():a.getDogOwner());
			a.setTitle(titlesMap.get("dqz"));
			if(StringUtils.isNoneBlank(a.getDogOwner())) {
				a.setDogOwner(a.getDogOwner().replace("&middot;", "·"));
			}
		});	
		list5 = list5.stream().sorted(Comparator.comparing(ShowScoreRanking::getDogBreed, Comparator.nullsLast(String::compareTo))
				.thenComparing(ShowScoreRanking::getRanking,Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
		excel.setDataList(list5, 4);
		String fileName = "当前积分榜-"+sdf.format(new Date())+".xlsx";
		excel.write(response, fileName).dispose();
	}
	
	
	@Transactional(readOnly = false)
	public void clearShowScoreRanking(String year) throws Exception {
		// 1、删除所有不符合的犬只
		List<ShowScoreRanking>  errorGenerationList = dao.findErrorGenerationList(year);
		if(errorGenerationList.size()==0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, year + "当前没有代数错误的犬只！");
		}
		for(ShowScoreRanking r : errorGenerationList) {
			r.setRemarks("ID1005000犬只代数排除");
			r.preUpdate();
			dao.updateForDel(r);
		}
		Set<String> scoreTypeSet = errorGenerationList.stream().map(a->a.getScoreType()).collect(Collectors.toSet());
		// 2、重算被影响的榜单的排名，插入新排名，删除旧排名
		for(String scoreType :scoreTypeSet ) {
			ShowScoreRanking entry = new ShowScoreRanking();
			entry.setYear(year);
			entry.setScoreType(scoreType);
			entry.getPage().setOrderBy("ranking");		
			List<ShowScoreRanking>  list = dao.findList(entry);
			String version =  "20221110-ID1005000";
			int ranking = 1;
			for(int i=0;i<list.size();i++) {
				ShowScoreRanking r = list.get(i);
				ShowScoreRanking entity = new ShowScoreRanking();
				entity.setPedigreeCertified(r.getPedigreeCertified());
				entity.setDogOwner(r.getDogOwner());
				entity.setDogBreedNameCn(r.getDogBreedNameCn());
				entity.setDogBreedNameEn(r.getDogBreedNameEn());
				entity.setDogName(r.getDogName());
				entity.setYear(year);
				entity.setScoreType(scoreType);
				entity.setScore(r.getScore());
				entity.setDogBreed(r.getDogBreed());
				entity.setDogBreedGroup(r.getDogBreedGroup());
				// 排名
				entity.setRanking(ranking);
				// 版本号
				entity.setVersion(version);
				entity.preInsert();
				dao.insert(entity);
				//计算下一个排名
				if (i < list.size() - 1) {
					ShowScoreRanking r2 = list.get(i + 1);
					if (!r2.getScore().equals(r.getScore())) {
						ranking++;
					}
				}
				r.setRemarks("ID1005000重排名次");
				r.preUpdate();
				dao.updateForDel(r);
			}
		}
	}
	
	
	
	@Transactional(readOnly = false)
	public ResultDto<CkuShowScoreRankingMonths> getMonths(String year) {
		//特幼
		List<String>  list = dao.getMonths(year, "1");
		//幼小
		List<String>  list2 = dao.getMonths(year, "2");
		
		return ResultDto.success(CkuShowScoreRankingMonths.builder().tyMonths(list).yxMonths(list2).build());
	}
	
	@Transactional(readOnly = false)
	public ResultDto<CkuShowScoreRankingMaxMonth> getMaxMonth(String year) {
		//特幼
		String  tyMaxMonth = dao.findMaxMonth(year, "1");
		//幼小
		String  yxMaxMonth = dao.findMaxMonth(year, "2");
		
		return ResultDto.success(CkuShowScoreRankingMaxMonth.builder().tyMaxMonth(tyMaxMonth).yxMaxMonth(yxMaxMonth)
				.build());
	}

	
	

	@Transactional(readOnly = false)
	public ListResultDto<CkuShowScoreRankingGroupAbstract> getGroupAbstract(String year,Integer limit) {
		List<CkuShowScoreRankingGroupAbstract> listResult = new ArrayList<>();
		// 十个犬种组
		List<HashMap<String, Object>> list = fciDogDao.getFciGroup();
		list.stream().forEach(a -> {
			CkuShowScoreRankingGroupAbstract groupAbstract = CkuShowScoreRankingGroupAbstract.builder()
					.dogBreedGroupCode(a.get("group_no").toString())
					.dogBreedGroup(a.get("chinese_group_name").toString()).build();
			// 犬种组排名
			ShowScoreRanking showScoreRanking = new ShowScoreRanking();
			showScoreRanking.setScoreType(ShowRankingScoreTypeConstant.GROUP);
			showScoreRanking.setYear(year);
			showScoreRanking.setDogBreedGroup(a.get("group_no").toString().replaceFirst("^0*", ""));
			showScoreRanking.setLimit(limit);
			List<CkuShowScore> resultList = findListFCKU(showScoreRanking);
			groupAbstract.setList(resultList);
			listResult.add(groupAbstract);
		});

		return ListResultDto.success(listResult);

	}
	
	@Transactional(readOnly = false)
	public void delLogical(String year,String scoreType) {
		dao.delLogical(year,null,scoreType);
	}
	
	@Transactional(readOnly = false)
	public void saveTrend(String year,String scoreType) {
		// 上升趋势 0持平 1上升 2下降
		dao.saveTrendByYearAndMonth(year ,null,scoreType);
	}
	
	@Transactional(readOnly = false)
	public void delPhysical(String year,String showCode,String scoreType) {
		// 对多余的冗余数据进行物理删除
		dao.delPhysicalByYearAndMonth(year,null, showCode,scoreType);
	}
	
	
	@Transactional(readOnly = false)
	public ListResultDto<CkuShowScoreRankingAbstractVO> getHKAbstract(String year) {
		String scoreType = "HK";
		List<CkuShowScoreRankingAbstractVO> listResult = new ArrayList<>();

		List<CkuShowScore> resultList = new ArrayList<>();
		ShowScoreRanking showScoreRanking = new ShowScoreRanking();
		showScoreRanking.setLimit(8);// 请求多少条
		showScoreRanking.setScoreType(scoreType);
		showScoreRanking.setYear(year);
		List<ShowScoreRanking> list = super.findList(showScoreRanking);
			for (ShowScoreRanking ssr : list) {
				CkuShowScore css = new CkuShowScore(ssr);
				css.setRanking(ssr.getRanking());
				css.setKennlCnName(null);
				css.setKennlEnName(null);
				resultList.add(css);
			}
			
		listResult.add(CkuShowScoreRankingAbstractVO.builder().scoreType(scoreType).scoreTitle(getScoreTitle(scoreType))
				.list(resultList).build());
		return ListResultDto.success(listResult);

	}
	
	
	
	

}