package com.cku.oa.show.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.entity.ShowMainJudgeInfo;
import com.cku.oa.show.dao.ShowMainJudgeInfoDao;

/**
 * 赛事裁判关联信息表Service
 * @author xx
 * @version 2021-08-06
 */
@Service
@Transactional(readOnly = true)
public class ShowMainJudgeInfoService extends CrudService<ShowMainJudgeInfoDao, ShowMainJudgeInfo> {

	public ShowMainJudgeInfo get(String id) {
		return super.get(id);
	}
	
	public List<ShowMainJudgeInfo> findList(ShowMainJudgeInfo showMainJudgeInfo) {
		return super.findList(showMainJudgeInfo);
	}
	
	public Page<ShowMainJudgeInfo> findPage(Page<ShowMainJudgeInfo> page, ShowMainJudgeInfo showMainJudgeInfo) {
		return super.findPage(page, showMainJudgeInfo);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowMainJudgeInfo showMainJudgeInfo) {
		super.save(showMainJudgeInfo);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowMainJudgeInfo showMainJudgeInfo) {
		super.delete(showMainJudgeInfo);
	}
	
	
	public List<ShowMainJudgeInfo> findListByShowMainId(String showMainId) {
		return dao.findListByShowMainId(showMainId);
	}
	
	public ShowMainJudgeInfo findByShowMainIdAndshowJudgeId(String showMainId,String showJudgeId) {
		return dao.findByShowMainIdAndshowJudgeId(showMainId, showJudgeId);
	}
	
}