/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.dog.entity.Dog;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 冠军登录Entity
 * 
 * @author zhuoHeng
 * @version 2016-07-14
 */
public class ChampionLogin extends DataEntity<ChampionLogin> {

	private static final long serialVersionUID = 1L;
	private String runningNumber; // 缴费流水号
	@ExcelField(title = "登录类型", align = 2, sort = 1)
	private String loginType; // 登录类型
	@ExcelField(title = "登录序号", align = 2, sort = 6)
	private String loginCode; // 登录序号
	@ExcelField(title = "血统证书号", align = 2, sort = 5)
	private String pedigreeCertified; // 血统证书号
	private Date printTime; // 签发日期
	private String paymentState; // 支付状态
	private String printState; // 打印状态
	private String dogBreed; // 犬种
	private String membershipCode; // 会员号
	private String ckuState; // cku_state
	private String price; // 订单价格
	private String paymentMembershipCode; // 付款会员号
	private String postType; // 邮寄类型
	private String postAddress; // 邮寄地址
	private String operater; // 操作人
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核原因
	private Date paymentTime; // 支付时间
	private Date proccessTime; // 处理时间
	private String proccessState; // 审核状态
	private String dogOwner; // 犬主人
	private String memberNum; // 犬主会员号
	private String sign; // 身份识别标识
	private String dogName; // 犬名
	private String dogGender; // 犬只性别
	private String chargingItemId; // 接收参数
	private String memberCode; // 接收参数
	private Dog dog;
	private String shortName;// 项目对应的shortName
	private String dogImg;// 犬只图片
	private String stickerFlag;// 申请贴纸标识:0不申请;1申请
	private String isHaveDogDna;// 是否进行DNA存档 0否，1是
	@ExcelField(title = "备注", align = 2, sort = 20)
	private String importRemark; // 导入用备注
	@ExcelField(title = "犬只头衔", align = 2, sort = 10)
	private String nameTitle; // 导入用犬只头衔
	@ExcelField(title = "订单项目", align = 2, sort = 15)
	private String orderProject; // 导入用订单项目名称
	// 开始截至日期
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date beginCreateDate;
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date endCreateDate;

	// 查询用属性 查询哪几种登录类型
	private List<String> loginTypes; // 登录类型

	// 特定排序字段
	private int loginTypeOrder;
	
	private Date paymentTimeLimit; //限制时间大于支付时间，则统计
	
	public Date getPaymentTimeLimit() {
		return paymentTimeLimit;
	}

	public void setPaymentTimeLimit(Date paymentTimeLimit) {
		this.paymentTimeLimit = paymentTimeLimit;
	}

	public int getLoginTypeOrder() {
		return loginTypeOrder;
	}

	public void setLoginTypeOrder(int loginTypeOrder) {
		this.loginTypeOrder = loginTypeOrder;
	}

	public List<String> getLoginTypes() {
		return loginTypes;
	}

	public void setLoginTypes(List<String> loginTypes) {
		this.loginTypes = loginTypes;
	}

	public ChampionLogin() {
		super();
	}

	public ChampionLogin(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "缴费流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 100, message = "登录类型长度必须介于 0 和 100 之间")
	public String getLoginType() {
		return loginType;
	}

	public void setLoginType(String loginType) {
		this.loginType = loginType;
	}

	@Length(min = 0, max = 100, message = "登录序号长度必须介于 0 和 100 之间")
	public String getLoginCode() {
		return loginCode;
	}

	public void setLoginCode(String loginCode) {
		this.loginCode = loginCode;
	}

	@Length(min = 0, max = 100, message = "血统证书号长度必须介于 0 和 100 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPrintTime() {
		return printTime;
	}

	public void setPrintTime(Date printTime) {
		this.printTime = printTime;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@Length(min = 0, max = 100, message = "打印状态长度必须介于 0 和 100 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@Length(min = 0, max = 50, message = "犬种长度必须介于 0 和 50 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 0, max = 50, message = "会员号长度必须介于 0 和 50 之间")
	public String getMembershipCode() {
		return membershipCode;
	}

	public void setMembershipCode(String membershipCode) {
		this.membershipCode = membershipCode;
	}

	@Length(min = 0, max = 100, message = "cku_state长度必须介于 0 和 100 之间")
	public String getCkuState() {
		return ckuState;
	}

	public void setCkuState(String ckuState) {
		this.ckuState = ckuState;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	@Length(min = 0, max = 50, message = "付款会员号长度必须介于 0 和 50 之间")
	public String getPaymentMembershipCode() {
		return paymentMembershipCode;
	}

	public void setPaymentMembershipCode(String paymentMembershipCode) {
		this.paymentMembershipCode = paymentMembershipCode;
	}

	@Length(min = 0, max = 50, message = "邮寄类型长度必须介于 0 和 50 之间")
	public String getPostType() {
		return postType;
	}

	public void setPostType(String postType) {
		this.postType = postType;
	}

	@Length(min = 0, max = 100, message = "邮寄地址长度必须介于 0 和 100 之间")
	public String getPostAddress() {
		return postAddress;
	}

	public void setPostAddress(String postAddress) {
		this.postAddress = postAddress;
	}

	@Length(min = 0, max = 255, message = "操作人长度必须介于 0 和 255 之间")
	public String getOperater() {
		return operater;
	}

	public void setOperater(String operater) {
		this.operater = operater;
	}

	@Length(min = 0, max = 64, message = "审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 64, message = "审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min = 0, max = 64, message = "审核状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return "0";
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public String getDogOwner() {
		return dogOwner;
	}

	public String getMemberNum() {
		return memberNum;
	}

	public String getSign() {
		return sign;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public void setMemberNum(String memberNum) {
		this.memberNum = memberNum;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	public String getChargingItemId() {
		return chargingItemId;
	}

	public void setChargingItemId(String chargingItemId) {
		this.chargingItemId = chargingItemId;
	}

	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public Dog getDog() {
		return dog;
	}

	public void setDog(Dog dog) {
		this.dog = dog;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getDogImg() {
		return dogImg;
	}

	public void setDogImg(String dogImg) {
		this.dogImg = dogImg;
	}

	public String getStickerFlag() {
		return stickerFlag;
	}

	public void setStickerFlag(String stickerFlag) {
		this.stickerFlag = stickerFlag;
	}

	public String getIsHaveDogDna() {
		return isHaveDogDna;
	}

	public void setIsHaveDogDna(String isHaveDogDna) {
		this.isHaveDogDna = isHaveDogDna;
	}

	public String getImportRemark() {
		return importRemark;
	}

	public void setImportRemark(String importRemark) {
		this.importRemark = importRemark;
	}

	public String getNameTitle() {
		return nameTitle;
	}

	public void setNameTitle(String nameTitle) {
		this.nameTitle = nameTitle;
	}

	public String getOrderProject() {
		return orderProject;
	}

	public void setOrderProject(String orderProject) {
		this.orderProject = orderProject;
	}

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}
}