package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.groomer.entity.GroomerQualificationCertificateChange;
import com.cku.oa.groomer.service.GroomerQualificationCertificateChangeService;

/**
 * 美容资格证书换发Controller
 * @author yuanshuai
 * @version 2024-02-18
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerQualificationCertificateChange")
public class GroomerQualificationCertificateChangeController extends BaseController {

	@Autowired
	private GroomerQualificationCertificateChangeService groomerQualificationCertificateChangeService;
	
	@ModelAttribute
	public GroomerQualificationCertificateChange get(@RequestParam(required=false) String id) {
		GroomerQualificationCertificateChange entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerQualificationCertificateChangeService.get(id);
		}
		if (entity == null){
			entity = new GroomerQualificationCertificateChange();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerQualificationCertificateChange:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerQualificationCertificateChange groomerQualificationCertificateChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerQualificationCertificateChange> page = groomerQualificationCertificateChangeService.findPage(new Page<>(request, response), groomerQualificationCertificateChange);
		model.addAttribute("page", page);
		return "oa/groomer/groomerQualificationCertificateChangeList";
	}

	@RequiresPermissions("groomer:groomerQualificationCertificateChange:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(GroomerQualificationCertificateChange groomerQualificationCertificateChange, Model model) {
		model.addAttribute("isView", 1);
		model.addAttribute("groomerQualificationCertificateChange", groomerQualificationCertificateChange);
		return "oa/groomer/groomerQualificationCertificateChangeForm";
	}

	@RequiresPermissions("groomer:groomerQualificationCertificateChange:edit")
	@RequestMapping(value = "editForm")
	public String editForm(GroomerQualificationCertificateChange groomerQualificationCertificateChange, Model model) {
		model.addAttribute("isView", 0);
		model.addAttribute("groomerQualificationCertificateChange", groomerQualificationCertificateChange);
		return "oa/groomer/groomerQualificationCertificateChangeForm";
	}

	@RequiresPermissions("groomer:groomerQualificationCertificateChange:edit")
	@RequestMapping(value = "save")
	@ResponseBody
	public ResultDto<String> save(GroomerQualificationCertificateChange groomerQualificationCertificateChange) {
		try {
			restBeanValidator(groomerQualificationCertificateChange);
			groomerQualificationCertificateChangeService.saveData(groomerQualificationCertificateChange);
		} catch (ZAException e) {
			e.printStackTrace();
			return ResultDto.error(ZAErrorCode.ZA_VALID_FAILED, "保存美容资格证书换发失败：" + e.getMessage());
		}
		return ResultDto.success("保存美容资格证书换发成功");
	}
	
	@RequiresPermissions("groomer:groomerQualificationCertificateChange:del")
	@RequestMapping(value = "delete")
	public String delete(GroomerQualificationCertificateChange groomerQualificationCertificateChange, RedirectAttributes redirectAttributes) {
		groomerQualificationCertificateChangeService.delete(groomerQualificationCertificateChange);
		addMessage(redirectAttributes, "删除美容资格证书换发成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerQualificationCertificateChange/?repage";
	}

}