package com.cku.oa.goods.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.goods.dao.SkuDao;
import com.cku.oa.goods.entity.Sku;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 商品Service
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
@Service
@Transactional(readOnly = true)
public class SkuService extends CrudService<SkuDao, Sku> {

	@Autowired
	private SkuItemRelService skuItemRelService;

	public Sku get(String id) {
		return super.get(id);
	}

	public List<Sku> findList(Sku sku) {
		return super.findList(sku);
	}

	public Page<Sku> findPage(Page<Sku> page, Sku sku) {
		return super.findPage(page, sku);
	}

	/**
	 * 根据ID列表获取商品列表
	 *
	 * @author yuanshuai
	 * @date 2023/6/18 16:52
	 */
	public List<Sku> findListByIdList(List<String> idList) {
		if (CollectionUtils.isEmpty(idList)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品ID列表为空");
		}
		return dao.findListByIdList(idList);
	}

	/**
	 * 根据业务服务查询商品列表
	 *
	 * @author yuanshuai
	 * @date 2023/7/28 16:43
	 */
	public List<Sku> findListByBusiness(String businessId) {
		if (StringUtils.isBlank(businessId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务服务ID为空");
		}
		return dao.findListByBusiness(businessId);
	}

	@Transactional(readOnly = false)
	public void save(Sku sku) {
		super.save(sku);
		//保存关联收费项目
		skuItemRelService.save(sku.getId(), sku.getItemIds());
	}

	@Transactional(readOnly = false)
	public void delete(Sku sku) {
		//已上架不允许删除
		if (1 == sku.getSaleFlag()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已上架商品不允许删除");
		}
		super.delete(sku);
	}

}