package com.cku.oa.gcWeb.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.oa.gcWeb.entity.GCWebBanner;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.gcWeb.service.GCWebBannerService;

/**
 * 美容官网轮播图Controller
 * @author yuanshuai
 * @version 2023-01-31
 */
@Controller
@RequestMapping(value = "${adminPath}/gcWeb/banner")
public class GCWebBannerController extends BaseController {

	@Autowired
	private GCWebBannerService gcWebBannerService;
	
	@ModelAttribute
	public GCWebBanner get(@RequestParam(required=false) String id) {
		GCWebBanner entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = gcWebBannerService.get(id);
		}
		if (entity == null){
			entity = new GCWebBanner();
		}
		return entity;
	}
	
	@RequiresPermissions("gcWeb:banner:view")
	@RequestMapping(value = {"list", ""})
	public String list(GCWebBanner gcWebBanner, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GCWebBanner> page = gcWebBannerService.findPage(new Page<>(request, response), gcWebBanner);
		model.addAttribute("gcWebBanner", gcWebBanner);
		model.addAttribute("page", page);
		return "oa/gcWeb/gcWebBannerList";
	}

	@RequiresPermissions("gcWeb:banner:view")
	@RequestMapping(value = "form")
	public String form(GCWebBanner gcWebBanner, Model model) {
		model.addAttribute("gcWebBanner", gcWebBanner);
		return "oa/gcWeb/gcWebBannerForm";
	}

	@RequiresPermissions("gcWeb:banner:edit")
	@RequestMapping(value = "save")
	public String save(GCWebBanner gcWebBanner, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, gcWebBanner)){
			return form(gcWebBanner, model);
		}
		gcWebBannerService.save(gcWebBanner);
		addMessage(redirectAttributes, "保存美容官网轮播图成功");
		return "redirect:"+Global.getAdminPath()+"/gcWeb/banner/?repage";
	}
	
	@RequiresPermissions("gcWeb:banner:del")
	@RequestMapping(value = "delete")
	public String delete(GCWebBanner gcWebBanner, RedirectAttributes redirectAttributes) {
		gcWebBannerService.delete(gcWebBanner);
		addMessage(redirectAttributes, "删除美容官网轮播图成功");
		return "redirect:"+Global.getAdminPath()+"/gcweb/banner/?repage";
	}

}