package com.cku.oa.dog.web;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ResultDto;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogPedigreeCertifiedRedo;
import com.cku.oa.dog.service.DogPedigreeCertifiedRedoService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.vo.DogPedigreeCertifiedRedoVO;
import com.cku.oa.finance.service.PaymentOrderService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 证书补做Controller
 * 
 * @author lgl
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "${adminPath}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo")
public class DogPedigreeCertifiedRedoController extends BaseController {

	@Autowired
	private DogPedigreeCertifiedRedoService dogPedigreeCertifiedRedoService;
	@Autowired
	private DogService dogService;

	private final static String REPAGE = "redirect:" + Global.getAdminPath()
			+ "/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/?repage";

	private final static String AUTHORITY_PRDFIX = "dogpedigreecertifiedredo:dogPedigreeCertifiedRedo:";

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required = true) String runningNumber,
			@RequestParam(required = true) String chargingItemId, @RequestParam(required = true) String memberCode,
			Model model) {
		model.addAttribute("dogPedigreeCertifiedRedo",
				new DogPedigreeCertifiedRedo(runningNumber, chargingItemId, memberCode));
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoOrderAdd";
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "getDogByPedigreeCertified")
	@ResponseBody
	public Object getDogByPedigreeCertified(@RequestParam(required = true) String pedigreeCertified) {
		HashMap<String, String> map = dogPedigreeCertifiedRedoService.getDogByPedigreeCertified(pedigreeCertified);
		return map;
	}

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "add")
	@ResponseBody
	public Object add(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedRedoService.add(dogPedigreeCertifiedRedo);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, Model model) {
		List<DogPedigreeCertifiedRedo> list = dogPedigreeCertifiedRedoService.findList(dogPedigreeCertifiedRedo);
		// 查询有没有退款或退款中
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(list.stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedRedoVO> list2 = list.stream().map(a -> {
			DogPedigreeCertifiedRedoVO b = new DogPedigreeCertifiedRedoVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		model.addAttribute("list", list2);
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoOrderList";
	}

	@ModelAttribute
	public DogPedigreeCertifiedRedo get(@RequestParam(required = false) String id) {
		DogPedigreeCertifiedRedo entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = dogPedigreeCertifiedRedoService.get(id);
		}
		if (entity == null) {
			entity = new DogPedigreeCertifiedRedo();
		}
		return entity;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = { "list", "" })
	public String list(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<DogPedigreeCertifiedRedo> page = dogPedigreeCertifiedRedoService
				.findPage(new Page<DogPedigreeCertifiedRedo>(request, response), dogPedigreeCertifiedRedo);

		// 查询有没有退款或退款中 fmdog_breed_certified_code
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<DogPedigreeCertifiedRedo> list = page.getList().stream().map(a -> {
			DogPedigreeCertifiedRedoVO b = new DogPedigreeCertifiedRedoVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		if ("230".equals(dogPedigreeCertifiedRedo.getDogBreed())) {
			return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoListZangao";
		}
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "view")
	@RequestMapping(value = "form")
	public String form(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, Model model) {
		model.addAttribute("dogPedigreeCertifiedRedo", dogPedigreeCertifiedRedo);
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "editForm")
	public String editForm(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, Model model) {
		model.addAttribute("dogPedigreeCertifiedRedo", dogPedigreeCertifiedRedo);
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoEditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "edit")
	@RequestMapping(value = "edit")
	public String edit(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, Model model,
			RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogPedigreeCertifiedRedo)) {
			return editForm(dogPedigreeCertifiedRedo, model);
		}
		dogPedigreeCertifiedRedoService.save(dogPedigreeCertifiedRedo);
		addMessage(redirectAttributes, "编辑证书补做成功");
		return repage(dogPedigreeCertifiedRedo);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "delete")
	@RequestMapping(value = "delete")
	public String delete(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, RedirectAttributes redirectAttributes) {
		try {
			dogPedigreeCertifiedRedoService.delete(dogPedigreeCertifiedRedo);
			addMessage(redirectAttributes, "删除证书补做成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "删除证书补做失败：" + e.getMessage());
		}
		return repage(dogPedigreeCertifiedRedo);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		model.addAttribute("dogPedigreeCertifiedRedo", dogPedigreeCertifiedRedoService.get(id));
		return "oa/dog/dogpedigreecertifiedredo/dogPedigreeCertifiedRedoAuditForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
		HashMap<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			dogPedigreeCertifiedRedoService.audit(dogPedigreeCertifiedRedo);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resolve")
	@RequestMapping(value = "resolve")
	public String resolve(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo, RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "处理证书补做成功");
		try {
			dogPedigreeCertifiedRedoService.resolve(dogPedigreeCertifiedRedo);
		} catch (Exception e) {
			addMessage(redirectAttributes, "处理证书补做失败:" + e.getMessage());
		}
		return repage(dogPedigreeCertifiedRedo);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "print")
	@RequestMapping(value = "print")
	public String print(DogPedigreeCertifiedRedo print, Model model,HttpServletRequest request) {
		DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = dogPedigreeCertifiedRedoService.get(print.getId());
		Dog dog = dogService.get(dogPedigreeCertifiedRedo.getDogId());
		return dogService.processPrintBusiness(dog, model, Boolean.TRUE);
	}

	@RequiresPermissions(AUTHORITY_PRDFIX + "resetPrint")
	@RequestMapping(value = "resetPrint")
	@ResponseBody
	public ResultDto<Boolean> resetPrint(DogPedigreeCertifiedRedo resetPrint, RedirectAttributes redirectAttributes) {
		DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo = dogPedigreeCertifiedRedoService.get(resetPrint.getId());
		dogService.resetPrint(dogPedigreeCertifiedRedo.getDogId());
		return ResultDto.success("重置证书打印成功", Boolean.TRUE);
	}

	/**
	 * 
	 * @description: 根据犬种判断是否跳藏獒的列表页
	 * @author: laiguanglong
	 * @date: 2016年9月3日 下午3:48:33
	 */
	private String repage(DogPedigreeCertifiedRedo dogPedigreeCertifiedRedo) {
		if ("230".equals(dogPedigreeCertifiedRedo.getDogBreed())) {
			return REPAGE + "&dogBreed=230";
		}
		return REPAGE;
	}
}