package com.cku.oa.dog.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鼻纹模拟Entity
 * @author yuanshuai
 * @version 2023-08-14
 */
public class DogNoseMock extends DataEntity<DogNoseMock> {
	
	private static final long serialVersionUID = 1L;
	private String pedigreeCertified;		// 证书号
	private String chipCode;		// 芯片号
	private String nameEn;		// 英文名
	private String dogBreed;		// 犬种
	private String noseCode;		// 鼻纹编号
	
	public DogNoseMock() {
		super();
	}

	public DogNoseMock(String id){
		super(id);
	}

	@Length(min=0, max=64, message="证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}
	
	@Length(min=0, max=64, message="芯片号长度必须介于 0 和 64 之间")
	public String getChipCode() {
		return chipCode;
	}

	public void setChipCode(String chipCode) {
		this.chipCode = chipCode;
	}

	public String getNameEn() {
		return nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Length(min=0, max=16, message="犬种长度必须介于 0 和 16 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}
	
	@Length(min=0, max=64, message="鼻纹编号长度必须介于 0 和 64 之间")
	public String getNoseCode() {
		return noseCode;
	}

	public void setNoseCode(String noseCode) {
		this.noseCode = noseCode;
	}
	
}