/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 繁育证书Entity
 * @author zhuoHeng
 * @version 2016-08-22
 */
public class DogBreedCertified extends DataEntity<DogBreedCertified> {
	
	private static final long serialVersionUID = 1L;
	private String dogId;		// 犬只id
	private String breedDeadline;		// 繁育期限
	private String breedGrade;		// 繁育级别
	private String shoulder;		// 肩高
	private String bodyLength;		// 体长
	private String chestDepth;		// 胸深
	private String weight;		// 体重
	private String testicles;		// 睾丸
	private String appraises;		// 总体评价
	private String dogFurColor;		// 毛色与毛质
	private String disposition;		// 性情
	private String attention;		// 注意力
	private String nerveSituation;		// 神经状况
	private String naturalDegree;		// 自然程度
	private String instinctConfidenceSuffer;		// 本能自信和承受力
	private String sexTypical;		// 性别特性
	private String physique;		// 体格
	private String expressive;		// 表现力
	private String trunk;		// 躯干情况
	private String bones;		// 骨骼
	private String muscles;		// 肌肉
	private String forelimbs;		// 前肢
	private String hindlimbs;		// 后肢
	private String back;		// 背部
	private String elbowJoint;		// 肘关节连接
	private String strengthOfPasterns;		// 前系强度
	private String front;		// 正面
	private String croup;		// 尻部
	private String strengthOfHocks;		// 飞节强度
	private String gait;		// 步态
	private String stepsForward;		// 步幅_前展
	private String stepsBackward;		// 步幅_后蹬
	private String nails;		// 趾甲
	private String feet;		// 趾
	private String head;		// 头部
	private String colourOfTeeth;		// 眼睛颜色
	private String upperJaw;		// 上颚
	private String underjaw;		// 下颚
	private String teeth;		// 牙齿
	private String faultsOfTeeth;		// 牙齿缺陷
	private String otherStrengthsWcaknesses;		// 其他优缺点
	private String suggestionsOnBreeding;		// 种犬繁育的意见
	private Date breedIdentifyTime;		// 繁育鉴定日期
	private String breedIdentifyLocation;		// 繁育鉴定地点
	private String breedCertifiedCode;		// 繁育证书编号
	private String breedIdentifyReferee;		// 繁育鉴定裁判
	private String kinBreed;		// 近亲繁殖
	private String breedResults;		// 繁殖成绩
	private String reviewState;		// 审核状态
	private Date reviewTime;		// 审核时间
	private String reviewRemarks;		// 审核的意见
	private String runningNumber;		// 流水号
	private String paymentState;		// 付款的状态
	private Date paymentTime;		// 付款时间
	private Date processTime;		// 流程变更的时间
	private String processState;		// 处理状态
	private String printState;     //打印状态
	private Date printTime;        //打印时间
	private Dog dog;       //犬只信息对象
	private List<String> childShowsList; //犬只成绩集合
	private String dogBreed;
	
	
	private Date createDate;   //起止时间
	private Date endDate;		//结束时间
	
	
	public DogBreedCertified() {
		super();
	}

	public DogBreedCertified(String id){
		super(id);
	}

	@Length(min=0, max=64, message="犬只id长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}
	
	@Length(min=0, max=20, message="繁育期限长度必须介于 0 和 20 之间")
	public String getBreedDeadline() {
		return breedDeadline;
	}

	public void setBreedDeadline(String breedDeadline) {
		this.breedDeadline = breedDeadline;
	}
	
	@Length(min=0, max=20, message="繁育级别长度必须介于 0 和 20 之间")
	public String getBreedGrade() {
		return breedGrade;
	}

	public void setBreedGrade(String breedGrade) {
		this.breedGrade = breedGrade;
	}
	
	@Length(min=0, max=20, message="肩高长度必须介于 0 和 20 之间")
	public String getShoulder() {
		return shoulder;
	}

	public void setShoulder(String shoulder) {
		this.shoulder = shoulder;
	}
	
	@Length(min=0, max=20, message="体长长度必须介于 0 和 20 之间")
	public String getBodyLength() {
		return bodyLength;
	}

	public void setBodyLength(String bodyLength) {
		this.bodyLength = bodyLength;
	}
	
	@Length(min=0, max=20, message="胸深长度必须介于 0 和 20 之间")
	public String getChestDepth() {
		return chestDepth;
	}

	public void setChestDepth(String chestDepth) {
		this.chestDepth = chestDepth;
	}
	
	@Length(min=0, max=20, message="体重长度必须介于 0 和 20 之间")
	public String getWeight() {
		return weight;
	}

	public void setWeight(String weight) {
		this.weight = weight;
	}
	
	@Length(min=0, max=20, message="睾丸长度必须介于 0 和 20 之间")
	public String getTesticles() {
		return testicles;
	}

	public void setTesticles(String testicles) {
		this.testicles = testicles;
	}
	
	@Length(min=0, max=20, message="总体评价长度必须介于 0 和 20 之间")
	public String getAppraises() {
		return appraises;
	}

	public void setAppraises(String appraises) {
		this.appraises = appraises;
	}
	
	@Length(min=0, max=20, message="毛色与毛质长度必须介于 0 和 20 之间")
	public String getDogFurColor() {
		return dogFurColor;
	}

	public void setDogFurColor(String dogFurColor) {
		this.dogFurColor = dogFurColor;
	}
	
	@Length(min=0, max=20, message="性情长度必须介于 0 和 20 之间")
	public String getDisposition() {
		return disposition;
	}

	public void setDisposition(String disposition) {
		this.disposition = disposition;
	}
	
	@Length(min=0, max=20, message="注意力长度必须介于 0 和 20 之间")
	public String getAttention() {
		return attention;
	}

	public void setAttention(String attention) {
		this.attention = attention;
	}
	
	@Length(min=0, max=20, message="神经状况长度必须介于 0 和 20 之间")
	public String getNerveSituation() {
		return nerveSituation;
	}

	public void setNerveSituation(String nerveSituation) {
		this.nerveSituation = nerveSituation;
	}
	
	@Length(min=0, max=20, message="自然程度长度必须介于 0 和 20 之间")
	public String getNaturalDegree() {
		return naturalDegree;
	}

	public void setNaturalDegree(String naturalDegree) {
		this.naturalDegree = naturalDegree;
	}
	
	@Length(min=0, max=20, message="本能自信和承受力长度必须介于 0 和 20 之间")
	public String getInstinctConfidenceSuffer() {
		return instinctConfidenceSuffer;
	}

	public void setInstinctConfidenceSuffer(String instinctConfidenceSuffer) {
		this.instinctConfidenceSuffer = instinctConfidenceSuffer;
	}
	
	@Length(min=0, max=20, message="性别特性长度必须介于 0 和 20 之间")
	public String getSexTypical() {
		return sexTypical;
	}

	public void setSexTypical(String sexTypical) {
		this.sexTypical = sexTypical;
	}
	
	@Length(min=0, max=20, message="体格长度必须介于 0 和 20 之间")
	public String getPhysique() {
		return physique;
	}

	public void setPhysique(String physique) {
		this.physique = physique;
	}
	
	@Length(min=0, max=20, message="表现力长度必须介于 0 和 20 之间")
	public String getExpressive() {
		return expressive;
	}

	public void setExpressive(String expressive) {
		this.expressive = expressive;
	}
	
	@Length(min=0, max=20, message="躯干情况长度必须介于 0 和 20 之间")
	public String getTrunk() {
		return trunk;
	}

	public void setTrunk(String trunk) {
		this.trunk = trunk;
	}
	
	@Length(min=0, max=20, message="骨骼长度必须介于 0 和 20 之间")
	public String getBones() {
		return bones;
	}

	public void setBones(String bones) {
		this.bones = bones;
	}
	
	@Length(min=0, max=20, message="肌肉长度必须介于 0 和 20 之间")
	public String getMuscles() {
		return muscles;
	}

	public void setMuscles(String muscles) {
		this.muscles = muscles;
	}
	
	@Length(min=0, max=20, message="前肢长度必须介于 0 和 20 之间")
	public String getForelimbs() {
		return forelimbs;
	}

	public void setForelimbs(String forelimbs) {
		this.forelimbs = forelimbs;
	}
	
	@Length(min=0, max=20, message="后肢长度必须介于 0 和 20 之间")
	public String getHindlimbs() {
		return hindlimbs;
	}

	public void setHindlimbs(String hindlimbs) {
		this.hindlimbs = hindlimbs;
	}
	
	@Length(min=0, max=20, message="背部长度必须介于 0 和 20 之间")
	public String getBack() {
		return back;
	}

	public void setBack(String back) {
		this.back = back;
	}
	
	@Length(min=0, max=20, message="肘关节连接长度必须介于 0 和 20 之间")
	public String getElbowJoint() {
		return elbowJoint;
	}

	public void setElbowJoint(String elbowJoint) {
		this.elbowJoint = elbowJoint;
	}
	
	@Length(min=0, max=20, message="前系强度长度必须介于 0 和 20 之间")
	public String getStrengthOfPasterns() {
		return strengthOfPasterns;
	}

	public void setStrengthOfPasterns(String strengthOfPasterns) {
		this.strengthOfPasterns = strengthOfPasterns;
	}
	
	@Length(min=0, max=20, message="正面长度必须介于 0 和 20 之间")
	public String getFront() {
		return front;
	}

	public void setFront(String front) {
		this.front = front;
	}
	
	@Length(min=0, max=20, message="尻部长度必须介于 0 和 20 之间")
	public String getCroup() {
		return croup;
	}

	public void setCroup(String croup) {
		this.croup = croup;
	}
	
	@Length(min=0, max=20, message="飞节强度长度必须介于 0 和 20 之间")
	public String getStrengthOfHocks() {
		return strengthOfHocks;
	}

	public void setStrengthOfHocks(String strengthOfHocks) {
		this.strengthOfHocks = strengthOfHocks;
	}
	
	@Length(min=0, max=20, message="步态长度必须介于 0 和 20 之间")
	public String getGait() {
		return gait;
	}

	public void setGait(String gait) {
		this.gait = gait;
	}
	
	@Length(min=0, max=20, message="步幅_前展长度必须介于 0 和 20 之间")
	public String getStepsForward() {
		return stepsForward;
	}

	public void setStepsForward(String stepsForward) {
		this.stepsForward = stepsForward;
	}
	
	@Length(min=0, max=20, message="步幅_后蹬长度必须介于 0 和 20 之间")
	public String getStepsBackward() {
		return stepsBackward;
	}

	public void setStepsBackward(String stepsBackward) {
		this.stepsBackward = stepsBackward;
	}
	
	@Length(min=0, max=20, message="趾甲长度必须介于 0 和 20 之间")
	public String getNails() {
		return nails;
	}

	public void setNails(String nails) {
		this.nails = nails;
	}
	
	@Length(min=0, max=20, message="趾长度必须介于 0 和 20 之间")
	public String getFeet() {
		return feet;
	}

	public void setFeet(String feet) {
		this.feet = feet;
	}
	
	@Length(min=0, max=20, message="头部长度必须介于 0 和 20 之间")
	public String getHead() {
		return head;
	}

	public void setHead(String head) {
		this.head = head;
	}
	
	@Length(min=0, max=20, message="眼睛颜色长度必须介于 0 和 20 之间")
	public String getColourOfTeeth() {
		return colourOfTeeth;
	}

	public void setColourOfTeeth(String colourOfTeeth) {
		this.colourOfTeeth = colourOfTeeth;
	}
	
	@Length(min=0, max=20, message="上颚长度必须介于 0 和 20 之间")
	public String getUpperJaw() {
		return upperJaw;
	}

	public void setUpperJaw(String upperJaw) {
		this.upperJaw = upperJaw;
	}
	
	@Length(min=0, max=20, message="下颚长度必须介于 0 和 20 之间")
	public String getUnderjaw() {
		return underjaw;
	}

	public void setUnderjaw(String underjaw) {
		this.underjaw = underjaw;
	}
	
	@Length(min=0, max=20, message="牙齿长度必须介于 0 和 20 之间")
	public String getTeeth() {
		return teeth;
	}

	public void setTeeth(String teeth) {
		this.teeth = teeth;
	}
	
	@Length(min=0, max=20, message="牙齿缺陷长度必须介于 0 和 20 之间")
	public String getFaultsOfTeeth() {
		return faultsOfTeeth;
	}

	public void setFaultsOfTeeth(String faultsOfTeeth) {
		this.faultsOfTeeth = faultsOfTeeth;
	}
	
	public String getOtherStrengthsWcaknesses() {
		return otherStrengthsWcaknesses;
	}

	public void setOtherStrengthsWcaknesses(String otherStrengthsWcaknesses) {
		this.otherStrengthsWcaknesses = otherStrengthsWcaknesses;
	}
	
	public String getSuggestionsOnBreeding() {
		return suggestionsOnBreeding;
	}

	public void setSuggestionsOnBreeding(String suggestionsOnBreeding) {
		this.suggestionsOnBreeding = suggestionsOnBreeding;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBreedIdentifyTime() {
		return breedIdentifyTime;
	}

	public void setBreedIdentifyTime(Date breedIdentifyTime) {
		this.breedIdentifyTime = breedIdentifyTime;
	}
	
	@Length(min=0, max=100, message="繁育鉴定地点长度必须介于 0 和 100 之间")
	public String getBreedIdentifyLocation() {
		return breedIdentifyLocation;
	}

	public void setBreedIdentifyLocation(String breedIdentifyLocation) {
		this.breedIdentifyLocation = breedIdentifyLocation;
	}
	
	@Length(min=0, max=100, message="繁育证书编号长度必须介于 0 和 100 之间")
	public String getBreedCertifiedCode() {
		return breedCertifiedCode;
	}

	public void setBreedCertifiedCode(String breedCertifiedCode) {
		this.breedCertifiedCode = breedCertifiedCode;
	}
	
	@Length(min=0, max=100, message="繁育鉴定裁判长度必须介于 0 和 100 之间")
	public String getBreedIdentifyReferee() {
		return breedIdentifyReferee;
	}

	public void setBreedIdentifyReferee(String breedIdentifyReferee) {
		this.breedIdentifyReferee = breedIdentifyReferee;
	}
	
	public String getKinBreed() {
		return kinBreed;
	}

	public void setKinBreed(String kinBreed) {
		this.kinBreed = kinBreed;
	}
	
	public String getBreedResults() {
		return breedResults;
	}

	public void setBreedResults(String breedResults) {
		this.breedResults = breedResults;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}
	
	@Length(min=0, max=255, message="审核的意见长度必须介于 0 和 255 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}
	
	@Length(min=0, max=100, message="流水号长度必须介于 0 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}
	
	@Length(min=0, max=20, message="付款的状态长度必须介于 0 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}
	
	@Length(min=0, max=20, message="处理状态长度必须介于 0 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

    public Dog getDog() {
        return dog;
    }

    public void setDog(Dog dog) {
        this.dog = dog;
    }

    public List<String> getChildShowsList() {
        return childShowsList;
    }

    public void setChildShowsList(List<String> childShowsList) {
        this.childShowsList = childShowsList;
    }

    public String getPrintState() {
        return printState;
    }

    public Date getPrintTime() {
        return printTime;
    }

    public void setPrintState(String printState) {
        this.printState = printState;
    }

    public void setPrintTime(Date printTime) {
        this.printTime = printTime;
    }

	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
    
	
}