/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.appreciation.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 鉴赏课Entity
 * @author xx
 * @version 2022-02-17
 */
public class AppreciationCourseware extends DataEntity<AppreciationCourseware> {
	
	private static final long serialVersionUID = 1L;
	private String coursewareName;		// 资料名称
	private String url;		// 资料url
	private String states;		// 课件状态（on_off_sale）


	//列表用
	// 开始 修改时间
	private Date beginUpdateDate;
	// 结束 修改时间
	private Date endUpdateDate;
	//课程数量
	private Integer coursesCount;
	//课程名称
	private String coursesName;
	//课程ID
	private String coursesId;

	public AppreciationCourseware() {
		super();
	}

	public AppreciationCourseware(String id){
		super(id);
	}

	@Length(min=1, max=100, message="资料名称长度必须介于 0 和 100 之间")
	public String getCoursewareName() {
		return coursewareName;
	}

	public void setCoursewareName(String coursewareName) {
		this.coursewareName = coursewareName;
	}
	
	@Length(min=1, max=200, message="资料url长度必须介于 0 和 200 之间")
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}
	
	@Length(min=0, max=1, message="课件状态长度必须介于 0 和 1 之间")
	public String getStates() {
		return states;
	}

	public void setStates(String states) {
		this.states = states;
	}
	
	public Date getBeginUpdateDate() {
		return beginUpdateDate;
	}

	public void setBeginUpdateDate(Date beginUpdateDate) {
		this.beginUpdateDate = beginUpdateDate;
	}
	
	public Date getEndUpdateDate() {
		return endUpdateDate;
	}

	public void setEndUpdateDate(Date endUpdateDate) {
		this.endUpdateDate = endUpdateDate;
	}

	public Integer getCoursesCount() {
		return coursesCount;
	}

	public void setCoursesCount(Integer coursesCount) {
		this.coursesCount = coursesCount;
	}

	public String getCoursesName() {
		return coursesName;
	}

	public void setCoursesName(String coursesName) {
		this.coursesName = coursesName;
	}

	public String getCoursesId() {
		return coursesId;
	}

	public void setCoursesId(String coursesId) {
		this.coursesId = coursesId;
	}
}