//我的狗信息
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //列表数据
        me.listData = ko.observableArray([]);
        //配种证明号
        me.fmdogBreedCertifiedCode = ko.observable("");
        //血统证书号或芯片号
        me.pedigreeCertifiedCode = ko.observable("");
        me.dogStates = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.finddogList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.finddogList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.finddogList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.finddogList(false);
            }
            return false;
        }
        /*
         犬只状态改变
         */
        me.changeDogState=function(data,event){
            var options=$("#type option:selected");
            me.dogStates(options.val());
        }
        /**
         * 查询我的狗信息
         */
        me.finddogList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["fmdogBreedCertifiedCode"] = me.fmdogBreedCertifiedCode();
            sendData["pedigreeCertifiedCode"] = me.pedigreeCertifiedCode();
            sendData["dogState"] = me.dogStates();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'dog/dog',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            $.each(json.list,function(index,item){
                                if(item.dogState=="0"){
                                    item.dogState="正常";
                                }else if(item.dogState=="2"){
                                    item.dogState="未审核";
                                }else if(item.dogState=="3"){
                                    item.dogState="已注销";
                                }else if(item.dogState=="4"){
                                    item.dogState="已冻结";
                                }else if(item.dogState=="5"){
                                    item.dogState="已出口";
                                }else{
                                    item.dogState="已删除";
                                }
                            });
                            me.listData(json.list);
                        }else{
                            layer.msg("检索结果为空！");
                            me.listData([]);
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询我的狗信息失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        $(function(){
            me.finddogList(false);
        });

        context.app.loading(false);
        context.app.isShop(false);
    }
});